/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.jans.as.model.BaseTest;
import io.jans.as.model.common.Display;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.util.Util;
import io.jans.orm.annotation.AttributeEnum;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UtilTest
extends BaseTest {
    @Test
    public void asInt_forNull_shouldFallback() {
        Assert.assertEquals((int)-1, (int)Util.asInt(null, (int)-1));
    }

    @Test
    public void asInt_forInteger_shouldReturnInteger() {
        Assert.assertEquals((int)5, (int)Util.asInt((Integer)5, (int)-1));
    }

    @Test
    public void putArray_whenListIsNull_shouldNotFail() {
        JSONObject json = new JSONObject();
        Util.putArray((JSONObject)json, null, (String)"key");
        Assert.assertNull((Object)json.optJSONArray("key"));
    }

    @Test
    public void putArray_whenListIsNotEmpty_shouldAddArray() {
        JSONObject json = new JSONObject();
        Util.putArray((JSONObject)json, (List)Lists.newArrayList((Object[])new String[]{"a"}), (String)"key");
        JSONArray jsonArray = json.optJSONArray("key");
        Assert.assertNotNull((Object)jsonArray);
        Assert.assertEquals((Object)jsonArray.get(0), (Object)"a");
    }

    @Test
    public void putArray_whenListIsEmpty_shouldNotAddArray() {
        JSONObject json = new JSONObject();
        Util.putArray((JSONObject)json, (List)Lists.newArrayList(), (String)"key");
        Assert.assertNull((Object)json.optJSONArray("key"));
    }

    @Test
    public void putNotBlank_keyNull_nothing() {
        this.showTitle("putNotBlank_keyNull_nothing");
        HashMap map = new HashMap();
        Util.putNotBlank(map, null, (Object)"value0");
        Assert.assertEquals((int)map.size(), (int)0);
    }

    @Test
    public void putNotBlank_valueStringEmpty_nothing() {
        this.showTitle("putNotBlank_valueStringEmpty_nothing");
        HashMap map = new HashMap();
        Util.putNotBlank(map, (String)"key0", (Object)"");
        Assert.assertEquals((int)map.size(), (int)0);
    }

    @Test
    public void putNotBlank_validParams_mapUpdated() {
        this.showTitle("putNotBlank_validParams_mapUpdated");
        HashMap map = new HashMap();
        Util.putNotBlank(map, (String)"key0", (Object)"value0");
        Assert.assertEquals((int)map.size(), (int)1);
        Assert.assertTrue((boolean)map.containsKey("key0"));
        Assert.assertEquals((String)String.valueOf(map.get("key0")), (String)"value0");
    }

    @Test
    public void escapeLog_paramNull_returnEmpty() {
        this.showTitle("escapeLog_paramNull_returnEmpty");
        Object param = null;
        String result = Util.escapeLog(param);
        Assert.assertEquals((String)result, (String)"", (String)"result is no empty");
    }

    @Test
    public void escapeLog_validParagraph_string() {
        this.showTitle("escapeLog_validParagraph_string");
        String param = "Hello world\nthis is a paragraph\nto test some  functionality.";
        String result = Util.escapeLog((Object)param);
        Assert.assertEquals((String)result, (String)"Hello world_this is a paragraph_to test some  functionality.");
    }

    @Test
    public void createJsonMapper_methodCall_objectMapperNotNull() {
        this.showTitle("createJsonMapper_methodCall_objectMapperNotNull");
        ObjectMapper objectMapper = Util.createJsonMapper();
        Assert.assertNotNull((Object)objectMapper);
    }

    @Test
    public void asJsonSilently_null_stringJsonFromObject() {
        this.showTitle("asJsonSilently_null_stringJsonFromObject");
        String stringJson = Util.asJsonSilently(null);
        Assert.assertNotNull((Object)stringJson);
        Assert.assertNotEquals((Object)stringJson, (Object)"");
    }

    @Test
    public void asJsonSilently_validObject_stringJsonFromObject() {
        this.showTitle("asJsonSilently_validObject_stringJsonFromObject");
        Date dateObject = new Date();
        String stringJson = Util.asJsonSilently((Object)dateObject);
        Assert.assertNotNull((Object)stringJson);
        Assert.assertEquals((String)stringJson, (String)String.valueOf(dateObject.getTime()));
    }

    @Test
    public void asPrettyJson_validObject_prettyStringJsonFromObject() throws IOException {
        this.showTitle("asPrettyJson_validObject_prettyStringJsonFromObject");
        List<String> list = Arrays.asList("1", "2");
        String stringJson = Util.asPrettyJson(list);
        Assert.assertNotNull((Object)stringJson);
        Assert.assertEquals((String)stringJson, (String)"[ \"1\", \"2\" ]");
    }

    @Test
    public void getBytes_validString_byteArray() throws IOException {
        this.showTitle("getBytes_validString_byteArray");
        String input = "Hello world";
        byte[] byteArray = Util.getBytes((String)input);
        Assert.assertNotNull((Object)byteArray);
        Assert.assertEquals((byte[])byteArray, (byte[])new byte[]{72, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100});
    }

    @Test
    public void asList_jsonArray_listString() throws IOException {
        this.showTitle("asList_jsonArray_listString");
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)"value1");
        jsonArray.put((Object)"value2");
        jsonArray.put((Object)"value3");
        List result = Util.asList((JSONArray)jsonArray);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((String)((String)result.get(0)), (String)"value1");
        Assert.assertEquals((String)((String)result.get(1)), (String)"value2");
        Assert.assertEquals((String)((String)result.get(2)), (String)"value3");
    }

    @Test
    public void asEnumList_jsonArrayAndClassType_listEnums() throws IOException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        this.showTitle("asEnumList_jsonArrayAndClassType_listEnums");
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)SubjectType.PAIRWISE.getValue());
        jsonArray.put((Object)SubjectType.PUBLIC.getValue());
        List result = Util.asEnumList((JSONArray)jsonArray, SubjectType.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertEquals((String)((SubjectType)result.get(0)).getValue(), (String)SubjectType.PAIRWISE.getValue());
        Assert.assertEquals((String)((SubjectType)result.get(1)).getValue(), (String)SubjectType.PUBLIC.getValue());
    }

    @Test
    public void addToListIfHas_jsonObjectWithKey_listWithNewValues() throws JSONException {
        this.showTitle("addToListIfHas_jsonObjectWithKey_listWithNewValues");
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)"value0");
        jsonArray.put((Object)"value1");
        jsonObject.putOpt("array", (Object)jsonArray);
        ArrayList listString = new ArrayList();
        Util.addToListIfHas(listString, (JSONObject)jsonObject, (String)"123");
        Assert.assertTrue((boolean)listString.isEmpty());
        Util.addToListIfHas(listString, (JSONObject)jsonObject, (String)"array");
        Assert.assertEquals((int)listString.size(), (int)2);
        Assert.assertEquals((String)((String)listString.get(0)), (String)"value0");
        Assert.assertEquals((String)((String)listString.get(1)), (String)"value1");
    }

    @Test
    public void addToJSONObjectIfNotNull_jsonObjectAndKeyAndValue_jsonObjectWithNewValue() throws JSONException {
        this.showTitle("addToJSONObjectIfNotNull_jsonObjectAndKeyAndValue_jsonObjectWithNewValue");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key0", (Object)"value0");
        Util.addToJSONObjectIfNotNull((JSONObject)jsonObject, (String)"key1", (Object)"value1");
        Assert.assertTrue((boolean)jsonObject.has("key1"));
        Assert.assertEquals((String)jsonObject.getString("key1"), (String)"value1");
        Assert.assertEquals((int)jsonObject.length(), (int)2, (String)"Length is unexpected");
        Util.addToJSONObjectIfNotNull((JSONObject)jsonObject, (String)"key0", (Object)"value00");
        Assert.assertTrue((boolean)jsonObject.has("key0"));
        Assert.assertEquals((String)jsonObject.getString("key0"), (String)"value00");
        Assert.assertEquals((int)jsonObject.length(), (int)2, (String)"Length is unexpected");
    }

    @Test
    public void addToJSONObjectIfNotNull_jsonObjectAndKeyAndObjectValue_jsonObjectWithNewValue() {
        this.showTitle("addToJSONObjectIfNotNull_jsonObjectAndKeyAndObjectValue_jsonObjectWithNewValue");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key0", (Object)new Date());
        Util.addToJSONObjectIfNotNull((JSONObject)jsonObject, (String)"key1", (Object)100.0);
        Assert.assertTrue((boolean)jsonObject.has("key1"));
        Assert.assertEquals((Object)jsonObject.get("key1"), (Object)100.0);
        Assert.assertEquals((int)jsonObject.length(), (int)2, (String)"Length is unexpected");
        Util.addToJSONObjectIfNotNull((JSONObject)jsonObject, (String)"key0", (Object)100L);
        Assert.assertTrue((boolean)jsonObject.has("key0"));
        Assert.assertEquals((Object)jsonObject.get("key0"), (Object)100L);
        Assert.assertEquals((int)jsonObject.length(), (int)2, (String)"Length is unexpected");
    }

    @Test
    public void addToJSONObjectIfNotNull_jsonObjectAndKeyAndEnumValue_jsonObjectWithNewValue() {
        this.showTitle("addToJSONObjectIfNotNull_jsonObjectAndKeyAndEnumValue_jsonObjectWithNewValue");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key0", (Object)"value0");
        Util.addToJSONObjectIfNotNull((JSONObject)jsonObject, (String)"key1", (AttributeEnum)SubjectType.PAIRWISE);
        Assert.assertTrue((boolean)jsonObject.has("key1"));
        Assert.assertEquals((String)jsonObject.getString("key1"), (String)SubjectType.PAIRWISE.getValue());
        Assert.assertEquals((int)jsonObject.length(), (int)2, (String)"Length is unexpected");
        Util.addToJSONObjectIfNotNull((JSONObject)jsonObject, (String)"key0", (AttributeEnum)SubjectType.PUBLIC);
        Assert.assertTrue((boolean)jsonObject.has("key0"));
        Assert.assertEquals((String)jsonObject.getString("key0"), (String)SubjectType.PUBLIC.getValue());
        Assert.assertEquals((int)jsonObject.length(), (int)2, (String)"Length is unexpected");
    }

    @Test
    public void addToJSONObjectIfNotNull_jsonObjectAndKeyAndStringArray_jsonObjectWithNewValue() {
        this.showTitle("addToJSONObjectIfNotNull_jsonObjectAndKeyAndStringArray_jsonObjectWithNewValue");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key0", (Object)"value0");
        Util.addToJSONObjectIfNotNull((JSONObject)jsonObject, (String)"key1", (String[])new String[]{"value1", "value2"});
        Assert.assertTrue((boolean)jsonObject.has("key1"));
        Assert.assertEquals((int)jsonObject.length(), (int)2, (String)"Length is unexpected");
        JSONArray jsonArray = jsonObject.getJSONArray("key1");
        Assert.assertEquals((int)jsonArray.length(), (int)2);
        Assert.assertEquals((String)jsonArray.getString(0), (String)"value1");
        Assert.assertEquals((String)jsonArray.getString(1), (String)"value2");
    }

    @Test
    public void asString_listHashParamName_stringResultSpaceSeparated() {
        this.showTitle("asString_listHashParamName_stringResultSpaceSeparated");
        ArrayList<Display> listHashParams = new ArrayList<Display>();
        listHashParams.add(Display.PAGE);
        listHashParams.add(Display.EMBEDDED);
        listHashParams.add(Display.POPUP);
        String result = Util.asString(listHashParams);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"page embedded popup");
    }

    @Test
    public void listAsString_listString_stringResultSpaceSeparated() {
        this.showTitle("listAsString_listString_stringResultSpaceSeparated");
        ArrayList<String> listString = new ArrayList<String>();
        listString.add("value0");
        listString.add("value1");
        listString.add("value2");
        String result = Util.listAsString(listString);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"value0 value1 value2");
    }

    @Test
    public void mapAsString_mapOfStrings_stringResultJSONArrayFormat() {
        this.showTitle("mapAsString_mapOfStrings_stringResultSpaceSeparated");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key0", "value0");
        map.put("key1", "value1");
        map.put("key2", "value2");
        String result = Util.mapAsString(map);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"[{\"key1\":\"value1\"},{\"key2\":\"value2\"},{\"key0\":\"value0\"}]");
    }

    @Test
    public void allNotBlank_arrayOfStringsOneNull_false() {
        this.showTitle("allNotBlank_arrayOfStringsOneNull_false");
        String[] arrayString = new String[]{"value0", null, "value2"};
        Assert.assertFalse((boolean)Util.allNotBlank((String[])arrayString));
    }

    @Test
    public void allNotBlank_arrayOfStringsOneEmpty_false() {
        this.showTitle("allNotBlank_arrayOfStringsOneEmpty_false");
        String[] arrayString = new String[]{"value0", "", "value2"};
        Assert.assertFalse((boolean)Util.allNotBlank((String[])arrayString));
    }

    @Test
    public void allNotBlank_arrayOfValidStrings_true() {
        this.showTitle("allNotBlank_arrayOfValidStrings_true");
        String[] arrayString = new String[]{"value0", "value1", "value2"};
        Assert.assertTrue((boolean)Util.allNotBlank((String[])arrayString));
    }

    @Test
    public void splittedStringAsList_stringInputAndStringSplitter_listString() {
        this.showTitle("splittedStringAsList_stringInputAndStringSplitter_listString");
        List listString = Util.splittedStringAsList((String)"Hello-World, -this-is-a-test", (String)"-");
        Assert.assertNotNull((Object)listString);
        Assert.assertEquals((int)listString.size(), (int)6);
        Assert.assertEquals((String)((String)listString.get(0)), (String)"Hello");
        Assert.assertEquals((String)((String)listString.get(5)), (String)"test");
    }

    @Test
    public void jsonArrayStringAsList_stringJsonInput_listString() {
        this.showTitle("jsonArrayStringAsList_stringJsonInput_listString");
        String stringJsonArray = "[\"Hello\",\"World\",\"this is a test\"]";
        List listString = Util.jsonArrayStringAsList((String)stringJsonArray);
        Assert.assertNotNull((Object)listString);
        Assert.assertEquals((int)listString.size(), (int)3);
        Assert.assertEquals((String)((String)listString.get(0)), (String)"Hello");
        Assert.assertEquals((String)((String)listString.get(1)), (String)"World");
        Assert.assertEquals((String)((String)listString.get(2)), (String)"this is a test");
    }

    @Test
    public void listToJsonArray_null_jsonArrayEmpty() {
        this.showTitle("listToJsonArray_null_jsonArrayEmpty");
        JSONArray arrayResult = Util.listToJsonArray(null);
        Assert.assertNotNull((Object)arrayResult);
        Assert.assertEquals((int)arrayResult.length(), (int)0);
    }

    @Test
    public void listToJsonArray_listString_jsonArray() {
        this.showTitle("listToJsonArray_listString_jsonArray");
        List<String> listString = Arrays.asList("value0", "value1", "value2");
        JSONArray arrayResult = Util.listToJsonArray(listString);
        Assert.assertNotNull((Object)arrayResult);
        Assert.assertEquals((int)arrayResult.length(), (int)3);
        Assert.assertEquals((String)arrayResult.getString(0), (String)"value0");
        Assert.assertEquals((String)arrayResult.getString(1), (String)"value1");
        Assert.assertEquals((String)arrayResult.getString(2), (String)"value2");
    }

    @Test
    public void jsonObjectArrayStringAsMap_stringJson_hashMap() {
        this.showTitle("jsonObjectArrayStringAsMap_stringJson_hashMap");
        String stringJsonArray = "[{\"header1\":\"valueHeader1\",\"header2\":\"valueHeader2\"},{\"header3\":\"valueHeader3\"}]";
        Map hashMap = Util.jsonObjectArrayStringAsMap((String)stringJsonArray);
        Assert.assertNotNull((Object)hashMap);
        Assert.assertEquals((int)hashMap.size(), (int)3);
        Assert.assertTrue((boolean)hashMap.containsKey("header1"));
        Assert.assertTrue((boolean)hashMap.containsKey("header2"));
        Assert.assertTrue((boolean)hashMap.containsKey("header3"));
        Assert.assertEquals((String)((String)hashMap.get("header1")), (String)"valueHeader1");
        Assert.assertEquals((String)((String)hashMap.get("header2")), (String)"valueHeader2");
        Assert.assertEquals((String)((String)hashMap.get("header3")), (String)"valueHeader3");
    }

    @Test
    public void firstItem_null_null() {
        this.showTitle("firstItem_null_null");
        String firstItem = (String)Util.firstItem(null);
        Assert.assertNull((Object)firstItem);
    }

    @Test
    public void firstItem_listEmpty_null() {
        this.showTitle("firstItem_listEmpty_null");
        String firstItem = (String)Util.firstItem(new ArrayList());
        Assert.assertNull((Object)firstItem);
    }

    @Test
    public void firstItem_listString_firstString() {
        this.showTitle("firstItem_listString_firstString");
        List<String> listString = Arrays.asList("value0", "value1", "value2");
        String firstItem = (String)Util.firstItem(listString);
        Assert.assertNotNull((Object)firstItem);
        Assert.assertEquals((String)firstItem, (String)"value0");
    }

    @Test
    public void isNullOrEmpty_null_false() {
        this.showTitle("isNullOrEmpty_null_false");
        Assert.assertTrue((boolean)Util.isNullOrEmpty(null));
    }

    @Test
    public void isNullOrEmpty_emptyString_false() {
        this.showTitle("isNullOrEmpty_emptyString_false");
        Assert.assertTrue((boolean)Util.isNullOrEmpty((String)""));
    }

    @Test
    public void isNullOrEmpty_validString_true() {
        this.showTitle("isNullOrEmpty_validString_true");
        Assert.assertFalse((boolean)Util.isNullOrEmpty((String)"text"));
    }

    @Test
    public void parseIntSilently_null_int1Negative() {
        this.showTitle("parseIntSilently_null_int1Negative");
        Assert.assertEquals((int)Util.parseIntSilently(null), (int)-1);
    }

    @Test
    public void parseIntSilently_invalidString_int1Negative() {
        this.showTitle("parseIntSilently_invalidString_int1Negative");
        Assert.assertEquals((int)Util.parseIntSilently((String)"onetwothree"), (int)-1);
    }

    @Test
    public void parseIntSilently_validString_int() {
        this.showTitle("parseIntSilently_validString_int");
        Assert.assertEquals((int)Util.parseIntSilently((String)"123"), (int)123);
    }

    @Test
    public void parseIntegerSilently_null_null() {
        this.showTitle("parseIntegerSilently_null_null");
        Assert.assertNull((Object)Util.parseIntegerSilently(null));
    }

    @Test
    public void parseIntegerSilently_invalidString_null() {
        this.showTitle("parseIntegerSilently_invalidString_null");
        Assert.assertNull((Object)Util.parseIntegerSilently((String)"onetwothree"));
    }

    @Test
    public void parseIntegerSilently_validString_integerValue() {
        this.showTitle("parseIntegerSilently_validString_integerValue");
        Assert.assertEquals((Integer)Util.parseIntegerSilently((String)"123"), (Integer)123);
    }

    @Test
    public void toSHA1HexString_validString_shaHexString() {
        this.showTitle("toSHA1HexString_validString_shaHexString");
        String result = Util.toSHA1HexString((String)"Hello world");
        Assert.assertEquals((String)result, (String)"7b502c3a1f48c8609ae212cdfb639dee39673f5e");
    }

    @Test
    public void byteArrayToHexString_byteArray_hexString() {
        this.showTitle("byteArrayToHexString_byteArray_hexString");
        String input = "Hello world";
        byte[] byteArray = Util.getBytes((String)input);
        String result = Util.byteArrayToHexString((byte[])byteArray);
        Assert.assertEquals((String)result, (String)"48656c6c6f20776f726c64");
    }

    @Test
    public void createExpirationDate_nullLifeTime_IllegalArgumentException() {
        this.showTitle("createExpirationDate_nullLifeTime_IllegalArgumentException");
        Assert.assertThrows(IllegalArgumentException.class, () -> Util.createExpirationDate(null));
    }

    @Test
    public void createExpirationDate_zeroLifeTime_IllegalArgumentException() {
        this.showTitle("createExpirationDate_zeroLifeTime_IllegalArgumentException");
        Assert.assertThrows(IllegalArgumentException.class, () -> Util.createExpirationDate((Integer)0));
    }

    @Test
    public void createExpirationDate_validLifeTime_dateExpiration() {
        this.showTitle("createExpirationDate_validLifeTime_dateExpiration");
        Date date = Util.createExpirationDate((Integer)60);
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void isPar_emptyUri_false() {
        this.showTitle("isPar_emptyUri_false");
        Assert.assertFalse((boolean)Util.isPar((String)""));
    }

    @Test
    public void isPar_nullUri_false() {
        this.showTitle("isPar_nullUri_false");
        Assert.assertFalse((boolean)Util.isPar(null));
    }

    @Test
    public void isPar_noParUri_false() {
        this.showTitle("isPar_noParUri_false");
        Assert.assertFalse((boolean)Util.isPar((String)"http://uriemaple.com"));
    }

    @Test
    public void isPar_validParUri_true() {
        this.showTitle("isPar_noParUri_false");
        Assert.assertTrue((boolean)Util.isPar((String)"par:uriemaple/test"));
    }

    @Test
    public void toSerializableMap_nullMap_emptyHashMap() {
        this.showTitle("toSerializableMap_nullMap_emptyHashMap");
        Map hashMap = Util.toSerializableMap(null);
        Assert.assertNotNull((Object)hashMap);
        Assert.assertEquals((int)hashMap.size(), (int)0);
    }

    @Test
    public void toSerializableMap_validObjectMap_serializableMap() {
        this.showTitle("toSerializableMap_validObjectMap_serializableMap");
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("key0", new UtilTest());
        inputMap.put("key1", 123);
        inputMap.put("key2", 10.0);
        inputMap.put("key3", "text");
        Map resultMap = Util.toSerializableMap(inputMap);
        Assert.assertNotNull((Object)resultMap);
        Assert.assertEquals((int)resultMap.size(), (int)3);
        Assert.assertEquals(resultMap.get("key1"), inputMap.get("key1"));
        Assert.assertEquals(resultMap.get("key2"), inputMap.get("key2"));
        Assert.assertEquals(resultMap.get("key3"), inputMap.get("key3"));
    }
}

