/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.nimbusds.jose.JWSAlgorithm;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.EllipticEdvardsCurve;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwt.JwtType;
import java.util.ArrayList;
import java.util.List;

public enum SignatureAlgorithm {
    NONE("none", AlgorithmFamily.NONE, null, null),
    HS256("HS256", AlgorithmFamily.HMAC, "HMACSHA256", JWSAlgorithm.HS256),
    HS384("HS384", AlgorithmFamily.HMAC, "HMACSHA384", JWSAlgorithm.HS384),
    HS512("HS512", AlgorithmFamily.HMAC, "HMACSHA512", JWSAlgorithm.HS512),
    RS256("RS256", AlgorithmFamily.RSA, "SHA256WITHRSA", JWSAlgorithm.RS256),
    RS384("RS384", AlgorithmFamily.RSA, "SHA384WITHRSA", JWSAlgorithm.RS384),
    RS512("RS512", AlgorithmFamily.RSA, "SHA512WITHRSA", JWSAlgorithm.RS512),
    ES256("ES256", AlgorithmFamily.EC, "SHA256WITHECDSA", EllipticEdvardsCurve.P_256, JWSAlgorithm.ES256),
    ES256K("ES256K", AlgorithmFamily.EC, "SHA256WITHECDSA", EllipticEdvardsCurve.P_256K, JWSAlgorithm.ES256K),
    ES384("ES384", AlgorithmFamily.EC, "SHA384WITHECDSA", EllipticEdvardsCurve.P_384, JWSAlgorithm.ES384),
    ES512("ES512", AlgorithmFamily.EC, "SHA512WITHECDSA", EllipticEdvardsCurve.P_521, JWSAlgorithm.ES512),
    PS256("PS256", AlgorithmFamily.RSA, "SHA256withRSAandMGF1", JWSAlgorithm.PS256),
    PS384("PS384", AlgorithmFamily.RSA, "SHA384withRSAandMGF1", JWSAlgorithm.PS384),
    PS512("PS512", AlgorithmFamily.RSA, "SHA512withRSAandMGF1", JWSAlgorithm.PS512),
    EDDSA("EdDSA", AlgorithmFamily.ED, "Ed25519", EllipticEdvardsCurve.ED_25519, JWSAlgorithm.EdDSA);

    public static final String DEF_HS256 = "HS256";
    public static final String DEF_HS384 = "HS384";
    public static final String DEF_HS512 = "HS512";
    public static final String DEF_RS256 = "RS256";
    public static final String DEF_RS384 = "RS384";
    public static final String DEF_RS512 = "RS512";
    public static final String DEF_ES256 = "ES256";
    public static final String DEF_ES256K = "ES256K";
    public static final String DEF_ES384 = "ES384";
    public static final String DEF_ES512 = "ES512";
    public static final String DEF_PS256 = "PS256";
    public static final String DEF_PS384 = "PS384";
    public static final String DEF_PS512 = "PS512";
    public static final String DEF_ED25519 = "Ed25519";
    public static final String DEF_EDDDSA = "EdDSA";
    public static final String DEF_HMACSHA256 = "HMACSHA256";
    public static final String DEF_HMACSHA384 = "HMACSHA384";
    public static final String DEF_HMACSHA512 = "HMACSHA512";
    public static final String DEF_SHA256WITHRSA = "SHA256WITHRSA";
    public static final String DEF_SHA384WITHRSA = "SHA384WITHRSA";
    public static final String DEF_SHA512WITHRSA = "SHA512WITHRSA";
    public static final String DEF_SHA256WITHECDSA = "SHA256WITHECDSA";
    public static final String DEF_SHA384WITHECDSA = "SHA384WITHECDSA";
    public static final String DEF_SHA512WITHECDSA = "SHA512WITHECDSA";
    public static final String DEF_SHA256WITHRSAANDMGF1 = "SHA256withRSAandMGF1";
    public static final String DEF_SHA384WITHRSAANDMGF1 = "SHA384withRSAandMGF1";
    public static final String DEF_SHA512WITHRSAANDMGF1 = "SHA512withRSAandMGF1";
    private final String name;
    private final AlgorithmFamily family;
    private final String algorithm;
    private final EllipticEdvardsCurve curve;
    private final JwtType jwtType;
    private final JWSAlgorithm jwsAlgorithm;
    private final Algorithm alg;

    private SignatureAlgorithm(String name, AlgorithmFamily family, String algorithm, EllipticEdvardsCurve curve, JWSAlgorithm jwsAlgorithm) {
        this.name = name;
        this.family = family;
        this.algorithm = algorithm;
        this.curve = curve;
        this.jwtType = JwtType.JWT;
        this.jwsAlgorithm = jwsAlgorithm;
        this.alg = Algorithm.fromString(name);
    }

    private SignatureAlgorithm(String name, AlgorithmFamily family, String algorithm, JWSAlgorithm jwsAlgorithm) {
        this(name, family, algorithm, null, jwsAlgorithm);
    }

    public Algorithm getAlg() {
        return this.alg;
    }

    public String getName() {
        return this.name;
    }

    public AlgorithmFamily getFamily() {
        return this.family;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public EllipticEdvardsCurve getCurve() {
        return this.curve;
    }

    public JwtType getJwtType() {
        return this.jwtType;
    }

    public static List<SignatureAlgorithm> fromString(String[] params) {
        ArrayList<SignatureAlgorithm> signatureAlgorithms = new ArrayList<SignatureAlgorithm>();
        for (String param : params) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString(param);
            if (signatureAlgorithm == null) continue;
            signatureAlgorithms.add(signatureAlgorithm);
        }
        return signatureAlgorithms;
    }

    @JsonCreator
    public static SignatureAlgorithm fromString(String param) {
        if (param != null) {
            for (SignatureAlgorithm sa : SignatureAlgorithm.values()) {
                if (!param.equals(sa.name)) continue;
                return sa;
            }
        }
        return null;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public JWSAlgorithm getJwsAlgorithm() {
        return this.jwsAlgorithm;
    }
}

