/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwt;

import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.AsymmetricSignatureAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.exception.InvalidParameterException;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.util.Base64Util;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.model.util.Util;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPoP
extends Jwt {
    private static final Logger LOG = LoggerFactory.getLogger(DPoP.class);
    private final String keyId;
    private String encodedJwt;
    private transient AbstractCryptoProvider cryptoProvider;

    public DPoP(AsymmetricSignatureAlgorithm asymmetricSignatureAlgorithm, JSONWebKey jwk, String jti, String htm, String htu, String keyId, AbstractCryptoProvider cryptoProvider) {
        this.getHeader().setType(JwtType.DPOP_PLUS_JWT);
        this.keyId = keyId;
        this.setSignatureAlgorithm(asymmetricSignatureAlgorithm);
        this.setJwk(jwk);
        this.setJti(jti);
        this.setHtm(htm);
        this.setHtu(htu);
        this.setIat(new Date().getTime());
        this.cryptoProvider = cryptoProvider;
    }

    public static String generateJti() {
        String guid = UUID.randomUUID().toString();
        byte[] sig = Util.getBytes(guid);
        String jti = Base64Util.base64urlencode(sig);
        return jti;
    }

    public static String generateAccessTokenHash(String accessToken) {
        String accessTokenHash = null;
        try {
            byte[] digest = JwtUtil.getMessageDigestSHA256(accessToken);
            if (digest != null) {
                accessTokenHash = Base64Util.base64urlencode(digest);
            }
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return accessTokenHash;
    }

    public JwtType getType() {
        return this.getHeader().getType();
    }

    public AsymmetricSignatureAlgorithm getSignatureAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getHeader().getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return AsymmetricSignatureAlgorithm.fromString(signatureAlgorithm.getName());
    }

    public void setSignatureAlgorithm(AsymmetricSignatureAlgorithm asymmetricSignatureAlgorithm) {
        this.getHeader().setAlgorithm(SignatureAlgorithm.fromString(asymmetricSignatureAlgorithm.getParamName()));
    }

    public JSONWebKey getJwk() {
        return JSONWebKey.fromJSONObject(this.getHeader().getJwk());
    }

    public void setJwk(JSONWebKey jwk) {
        this.getHeader().setJwk(jwk.toJSONObject());
    }

    public String getJti() {
        return this.getClaims().getClaimAsString("jti");
    }

    public void setJti(String jti) {
        this.getClaims().setClaim("jti", jti);
    }

    public String getHtm() {
        return this.getClaims().getClaimAsString("htm");
    }

    public void setHtm(String htm) {
        this.getClaims().setClaim("htm", htm);
    }

    public String getHtu() {
        return this.getClaims().getClaimAsString("htu");
    }

    public void setHtu(String htu) {
        this.getClaims().setClaim("htu", htu);
    }

    public Long getIat() {
        return this.getClaims().getClaimAsLong("iat");
    }

    public void setIat(Long iat) {
        this.getClaims().setClaim("iat", iat);
    }

    public String getAth() {
        return this.getClaims().getClaimAsString("ath");
    }

    public void setAth(String ath) {
        this.getClaims().setClaim("ath", ath);
    }

    public AbstractCryptoProvider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public String getEncodedJwt() throws InvalidJwtException, InvalidParameterException, CryptoProviderException {
        if (this.getType() != JwtType.DPOP_PLUS_JWT) {
            throw new InvalidJwtException("Type (typ) value must be dpop+jwt");
        }
        if (this.getSignatureAlgorithm() == null) {
            throw new InvalidJwtException("Algorithm (alg) must be an asymmetric algorithm");
        }
        if (this.getJwk() == null) {
            throw new InvalidJwtException("JWK (jwk) is required");
        }
        if (StringUtils.isBlank((CharSequence)this.getJti())) {
            throw new InvalidJwtException("The JWT Unique identifier (jti) is required");
        }
        if (StringUtils.isBlank((CharSequence)this.getHtm())) {
            throw new InvalidJwtException("The HTTP method (htm) is required");
        }
        if (StringUtils.isBlank((CharSequence)this.getHtu())) {
            throw new InvalidJwtException("The HTTP URI (htu) is required");
        }
        if (this.getIat() == null || this.getIat() <= 0L) {
            throw new InvalidJwtException("The issued at (iat) is required");
        }
        if (this.cryptoProvider == null) {
            throw new InvalidParameterException("The Crypto Provider cannot be null.");
        }
        String encodedHeader = this.getHeader().toBase64JsonObject();
        String encodedPayload = this.getClaims().toBase64JsonObject();
        String signingInput = encodedHeader + "." + encodedPayload;
        String encodedSignature = this.cryptoProvider.sign(signingInput, this.keyId, null, this.getHeader().getSignatureAlgorithm());
        this.encodedJwt = encodedHeader + "." + encodedPayload + "." + encodedSignature;
        return this.encodedJwt;
    }

    @Override
    public String toString() {
        return this.encodedJwt;
    }
}

