/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwt;

import com.google.common.collect.Lists;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.JwtClaimSet;
import io.jans.as.model.jwt.JwtType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class JwtClaims
extends JwtClaimSet {
    public JwtClaims() {
    }

    public JwtClaims(JSONObject jsonObject) {
        super(jsonObject);
    }

    public JwtClaims(String base64JsonObject) throws InvalidJwtException {
        super(base64JsonObject);
    }

    public void setExpirationTime(Date expirationTime) {
        this.setClaim("exp", expirationTime);
    }

    public void setNotBefore(Date notBefore) {
        this.setClaim("nbf", notBefore);
    }

    public void setNbf(Date notBefore) {
        this.setNotBefore(notBefore);
    }

    public void setIssuedAt(Date issuedAt) {
        this.setClaim("iat", issuedAt);
    }

    public void setIatNow() {
        this.setIssuedAt(new Date());
    }

    public void setIat(Date issuedAt) {
        this.setIssuedAt(issuedAt);
    }

    public void setIssuer(String issuer) {
        this.setClaim("iss", issuer);
    }

    public void setIssuer(URI issuer) {
        if (issuer == null) {
            this.setNullClaim("iss");
        } else {
            this.setClaim("iss", issuer.toString());
        }
    }

    public void addAudience(String audience) {
        if (StringUtils.isBlank((CharSequence)audience)) {
            return;
        }
        if (!this.hasClaim("aud")) {
            this.setAudience(audience);
            return;
        }
        ArrayList value = Lists.newArrayList();
        Object currentAudience = this.getClaim("aud");
        if (currentAudience instanceof String) {
            value.add((String)currentAudience);
        } else if (currentAudience instanceof Collection) {
            value.addAll((Collection)currentAudience);
        }
        if (!value.contains(audience)) {
            value.add(audience);
        }
        if (value.size() == 1) {
            this.setAudience((String)value.iterator().next());
            return;
        }
        this.setClaim("aud", value);
    }

    public void setAudience(String audience) {
        this.setClaim("aud", audience);
    }

    public void setAudience(URI audience) {
        if (audience == null) {
            this.setNullClaim("aud");
        } else {
            this.setClaim("aud", audience.toString());
        }
    }

    public void setSubjectIdentifier(String subjectIdentifier) {
        this.setClaim("sub", subjectIdentifier);
    }

    public void setSubjectIdentifier(URI subjectIdentifier) {
        if (subjectIdentifier == null) {
            this.setNullClaim("sub");
        } else {
            this.setClaim("sub", subjectIdentifier.toString());
        }
    }

    public void setJwtId(String jwtId) {
        this.setClaim("jti", jwtId);
    }

    public void setJwtId(UUID jwtId) {
        if (jwtId == null) {
            this.setNullClaim("jti");
        } else {
            this.setClaim("jti", jwtId.toString());
        }
    }

    public void setType(JwtType type) {
        if (type == null) {
            this.setNullClaim("typ");
        } else {
            this.setClaim("typ", type.toString());
        }
    }
}

