/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.uma.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.Expiration;
import io.jans.orm.annotation.ObjectClass;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@DataEntry
@ObjectClass(value="jansUmaResource")
public class UmaResource
implements Serializable {
    @DN
    private String dn;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @AttributeName(name="jansId")
    private String id;
    @NotNull(message="Display name should be not empty")
    @AttributeName(name="displayName")
    private @NotNull(message="Display name should be not empty") String name;
    @AttributeName(name="jansFaviconImage")
    private String iconUri;
    @AttributeName(name="jansUmaScope", consistency=true)
    private List<String> scopes;
    @AttributeName(name="jansScopeExpression", consistency=true)
    private String scopeExpression;
    @AttributeName(name="jansAssociatedClnt", consistency=true)
    private List<String> clients;
    @AttributeName(name="jansResource")
    private List<String> resources;
    @AttributeName(name="owner")
    private String creator;
    @AttributeName(name="description")
    private String description;
    @AttributeName(name="jansTyp")
    private String type;
    @AttributeName(name="iat")
    private Date creationDate;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private boolean deletable = true;
    @Expiration
    private Integer ttl;

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void resetTtlFromExpirationDate() {
        Long duration = Duration.between(new Date().toInstant(), this.getExpirationDate().toInstant()).getSeconds();
        Integer calculatedTtl = duration.intValue();
        if (calculatedTtl != null) {
            this.setTtl(calculatedTtl);
        }
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public String getScopeExpression() {
        return this.scopeExpression;
    }

    public void setScopeExpression(String scopeExpression) {
        this.scopeExpression = scopeExpression;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getClients() {
        if (this.clients == null) {
            this.clients = new ArrayList<String>();
        }
        return this.clients;
    }

    public void setClients(List<String> clients) {
        this.clients = clients;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public List<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = Lists.newArrayList();
        }
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.expirationDate != null && new Date().after(this.expirationDate);
    }

    public String toString() {
        return "UmaResource{dn='" + this.dn + "', inum='" + this.inum + "', id='" + this.id + "', name='" + this.name + "', iconUri='" + this.iconUri + "', scopes=" + this.scopes + ", scopeExpression='" + this.scopeExpression + "', clients=" + this.clients + ", resources=" + this.resources + ", creator='" + this.creator + "', description='" + this.description + "', type='" + this.type + "', creationDate=" + this.creationDate + ", expirationDate=" + this.expirationDate + ", deletable=" + this.deletable + "}";
    }
}

