/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import io.jans.as.model.crypto.Certificate;
import io.jans.as.model.crypto.PublicKey;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.ECDSAPublicKey;
import io.jans.as.model.crypto.signature.RSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.InvalidParameterException;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.util.Base64Util;
import io.jans.util.StringHelper;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.openssl.PEMParser;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);

    private JwtUtil() {
    }

    public static void printAlgorithmsAndProviders() {
        JwtUtil.printAlgorithms("Signature");
        JwtUtil.printAlgorithms("MessageDigest");
        JwtUtil.printAlgorithms("Cipher");
        JwtUtil.printAlgorithms("Mac");
        JwtUtil.printAlgorithms("KeyStore");
        for (Provider provider : Security.getProviders()) {
            log.trace("Provider: {}", (Object)provider.getName());
        }
    }

    public static void printAlgorithms(String algorithmType) {
        Set<String> algorithms = Security.getAlgorithms(algorithmType);
        for (String algorithm : algorithms) {
            log.trace("Algorithm ({}}): {}", (Object)algorithmType, (Object)algorithm);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789abcdef".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] getMessageDigestSHA256(String data) throws NoSuchProviderException, NoSuchAlgorithmException {
        return JwtUtil.getMessageDigest(data, "SHA-256");
    }

    public static byte[] getMessageDigestSHA384(String data) throws NoSuchProviderException, NoSuchAlgorithmException {
        return JwtUtil.getMessageDigest(data, "SHA-384");
    }

    public static byte[] getMessageDigestSHA512(String data) throws NoSuchProviderException, NoSuchAlgorithmException {
        return JwtUtil.getMessageDigest(data, "SHA-512");
    }

    public static byte[] getMessageDigest(String data, String algorithm) throws NoSuchProviderException, NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithm, "BC").digest(data.getBytes(StandardCharsets.UTF_8));
    }

    public static PublicKey getPublicKey(String jwksUri, String jwks, SignatureAlgorithm signatureAlgorithm, String keyId) {
        JSONObject jsonKeyValue = JwtUtil.getJsonKey(jwksUri, jwks, keyId);
        if (jsonKeyValue == null) {
            return null;
        }
        PublicKey publicKey = null;
        try {
            AlgorithmFamily algorithmFamily;
            String resultKeyId = jsonKeyValue.getString("kid");
            if (signatureAlgorithm == null && (signatureAlgorithm = SignatureAlgorithm.fromString(jsonKeyValue.getString("alg"))) == null) {
                log.error("Failed to determine key '{}' signature algorithm", (Object)resultKeyId);
                return null;
            }
            JSONObject jsonPublicKey = jsonKeyValue;
            if (jsonKeyValue.has("publicKey")) {
                jsonPublicKey = jsonKeyValue.getJSONObject("publicKey");
            }
            if ((algorithmFamily = signatureAlgorithm.getFamily()) == AlgorithmFamily.RSA) {
                String exp = jsonPublicKey.getString("e");
                String mod = jsonPublicKey.getString("n");
                BigInteger publicExponent = new BigInteger(1, Base64Util.base64urldecode(exp));
                BigInteger modulus = new BigInteger(1, Base64Util.base64urldecode(mod));
                publicKey = new RSAPublicKey(modulus, publicExponent);
            } else if (algorithmFamily == AlgorithmFamily.EC) {
                String xx = jsonPublicKey.getString("x");
                String yy = jsonPublicKey.getString("y");
                BigInteger x = new BigInteger(1, Base64Util.base64urldecode(xx));
                BigInteger y = new BigInteger(1, Base64Util.base64urldecode(yy));
                publicKey = new ECDSAPublicKey(signatureAlgorithm, x, y);
            } else {
                throw new InvalidParameterException("Wrong value of the AlgorithmFamily: algorithmFamily = " + algorithmFamily);
            }
            if (jsonKeyValue.has("x5c")) {
                String BEGIN = "-----BEGIN CERTIFICATE-----";
                String END = "-----END CERTIFICATE-----";
                JSONArray certChain = jsonKeyValue.getJSONArray("x5c");
                String certificateString = "-----BEGIN CERTIFICATE-----\n" + certChain.getString(0) + "\n-----END CERTIFICATE-----";
                StringReader sr = new StringReader(certificateString);
                PEMParser pemReader = new PEMParser((Reader)sr);
                X509CertificateObject cert = (X509CertificateObject)pemReader.readObject();
                Certificate certificate = new Certificate(signatureAlgorithm, (X509Certificate)cert);
                publicKey.setCertificate(certificate);
            }
            publicKey.setKeyId(resultKeyId);
            publicKey.setSignatureAlgorithm(signatureAlgorithm);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJwks(String jwksUri) {
        String jwks = "";
        try (Client clientRequest = ClientBuilder.newClient();){
            Response clientResponse = clientRequest.target(jwksUri).request().buildGet().invoke();
            int status = clientResponse.getStatus();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Status: %s", String.valueOf(status)));
            }
            if (status == 200) {
                jwks = (String)clientResponse.readEntity(String.class);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("JWK: %s", jwks));
                }
            }
        }
        return jwks;
    }

    private static JSONObject buildJsonKey(String jwks, String keyId) {
        JSONObject jsonKey = null;
        JSONObject jsonObject = new JSONObject(jwks);
        JSONArray keys = jsonObject.getJSONArray("keys");
        if (keys.length() > 0) {
            if (StringHelper.isEmpty((String)keyId)) {
                jsonKey = keys.getJSONObject(0);
            } else {
                for (int i = 0; i < keys.length(); ++i) {
                    JSONObject kv = keys.getJSONObject(i);
                    if (!kv.getString("kid").equals(keyId)) continue;
                    jsonKey = kv;
                    break;
                }
            }
        }
        return jsonKey;
    }

    public static JSONObject getJsonKey(String jwksUri, String jwks, String keyId) {
        JSONObject jsonKey = null;
        try {
            if (StringHelper.isEmpty((String)jwks)) {
                jwks = JwtUtil.getJwks(jwksUri);
            }
            if (StringHelper.isNotEmpty((String)jwks)) {
                jsonKey = JwtUtil.buildJsonKey(jwks, keyId);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return jsonKey;
    }

    public static JSONObject getJSONWebKeys(String jwksUri) {
        return JwtUtil.getJSONWebKeys(jwksUri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getJSONWebKeys(String jwksUri, ClientHttpEngine engine) {
        JSONObject jwks;
        block9: {
            log.debug("Retrieving jwks {}...", (Object)jwksUri);
            jwks = null;
            try {
                if (StringHelper.isEmpty((String)jwksUri)) break block9;
                ClientBuilder clientBuilder = ClientBuilder.newBuilder();
                if (engine != null) {
                    ((ResteasyClientBuilder)clientBuilder).httpEngine(engine);
                }
                try (Client clientRequest = clientBuilder.build();){
                    Response clientResponse = clientRequest.target(jwksUri).request().buildGet().invoke();
                    int status = clientResponse.getStatus();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Status: %s", status));
                    }
                    if (status == 200) {
                        jwks = JwtUtil.fromJson((String)clientResponse.readEntity(String.class));
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("JWK: %s", jwks));
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return jwks;
    }

    public static JSONObject fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        return (JSONObject)mapper.readValue(json, JSONObject.class);
    }

    public static void transferIntoJwtClaims(JSONObject jsonObject, Jwt jwt) {
        if (jsonObject == null || jwt == null) {
            return;
        }
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.opt(key);
            jwt.getClaims().setClaimObject(key, value, true);
        }
    }
}

