/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import io.jans.as.model.common.HasParamName;
import io.jans.as.model.util.Base64Util;
import io.jans.as.model.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import org.json.JSONArray;
import org.json.JSONException;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String SPACE = " ";
    public static final String EASY_TO_READ_CHARACTERS = "BCDFGHJKLMNPQRSTVWXZ";

    private StringUtils() {
    }

    public static String nullToEmpty(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        return str;
    }

    @Deprecated
    public static boolean equals(String str1, String str2) {
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)str1, (CharSequence)str2);
    }

    public static boolean equalsIgnoringSpaces(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        return a.replaceAll("\\s+", EMPTY_STRING).equalsIgnoreCase(b.replaceAll("\\s+", EMPTY_STRING));
    }

    public static String implode(String[] inputArray, String glueString) {
        String output = EMPTY_STRING;
        if (inputArray != null && inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(inputArray[0]);
            for (int i = 1; i < inputArray.length; ++i) {
                sb.append(glueString);
                sb.append(inputArray[i]);
            }
            output = sb.toString();
        }
        return output;
    }

    public static String implode(Collection<? extends Object> collection, String glueString) {
        String output = EMPTY_STRING;
        if (collection != null && !collection.isEmpty()) {
            StringJoiner sb = new StringJoiner(glueString);
            for (Object object : collection) {
                sb.add(object.toString());
            }
            output = sb.toString();
        }
        return output;
    }

    public static String implodeEnum(List<? extends HasParamName> inputList, String glueString) {
        String output = EMPTY_STRING;
        if (inputList != null && !inputList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(inputList.get(0));
            for (int i = 1; i < inputList.size(); ++i) {
                sb.append(glueString);
                sb.append(inputList.get(i).getParamName());
            }
            output = sb.toString();
        }
        return output;
    }

    public static List<String> spaceSeparatedToList(String spaceSeparatedString) {
        List<String> list = new ArrayList<String>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)spaceSeparatedString)) {
            list = Arrays.asList(spaceSeparatedString.split(SPACE));
        }
        return list;
    }

    public static JSONArray toJSONArray(List<? extends Object> inputList) {
        JSONArray jsonArray = new JSONArray();
        if (inputList != null && !inputList.isEmpty()) {
            jsonArray = new JSONArray(inputList);
        }
        return jsonArray;
    }

    public static List<String> toList(JSONArray jsonArray) throws JSONException {
        ArrayList<String> list = new ArrayList<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                list.add(jsonArray.getString(i));
            }
        }
        return list;
    }

    public static Date parseSilently(String string) {
        try {
            SimpleDateFormat parser = new SimpleDateFormat("EEE MMM d HH:mm:ss zzz yyyy");
            return parser.parse(string);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void addQueryStringParam(StringBuilder queryStringBuilder, String key, Object value) throws UnsupportedEncodingException {
        if (queryStringBuilder != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)key) && value != null) {
            if (queryStringBuilder.length() > 0) {
                queryStringBuilder.append("&");
            }
            queryStringBuilder.append(key).append("=").append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
    }

    public static void addQueryStringParam(StringBuilder queryStringBuilder, String key, Collection<?> value) throws UnsupportedEncodingException {
        if (queryStringBuilder != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)key) && value != null && !value.isEmpty()) {
            if (queryStringBuilder.length() > 0) {
                queryStringBuilder.append("&");
            }
            queryStringBuilder.append(key).append("=").append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
    }

    public static String generateRandomReadableCode(byte length) {
        StringBuilder sb = new StringBuilder();
        SecureRandom sc = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            if (i % 4 == 0 && i > 0) {
                sb.append('-');
            }
            char item = EASY_TO_READ_CHARACTERS.charAt(sc.nextInt(EASY_TO_READ_CHARACTERS.length()));
            sb.append(item);
        }
        return sb.toString();
    }

    public static String generateRandomCode(byte seedLength) {
        byte[] seed = new byte[seedLength];
        new SecureRandom().nextBytes(seed);
        return Util.byteArrayToHexString(seed);
    }

    public static String base64urlencode(String string) {
        return Base64Util.base64urlencode(string.getBytes(StandardCharsets.UTF_8));
    }
}

