/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.auth;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.i18n.LanguageBean;
import io.jans.as.server.model.exception.InvalidSessionStateException;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.AcrService;
import io.jans.as.server.service.AuthenticationService;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ErrorHandlerService;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.util.ServerUtil;
import io.jans.jsf2.message.FacesMessages;
import io.jans.jsf2.service.FacesService;
import io.jans.model.AuthenticationScriptUsageType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.security.Credentials;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@RequestScoped
@Named
public class Authenticator {
    public static final String INVALID_SESSION_MESSAGE = "login.errorSessionInvalidMessage";
    public static final String AUTHENTICATION_ERROR_MESSAGE = "login.failedToAuthenticate";
    public static final String AUTHENTICATION_SUCCESS_FOR_USER = "Authentication success for User: '{}'";
    @Inject
    private Logger logger;
    @Inject
    private Identity identity;
    @Inject
    private Credentials credentials;
    @Inject
    private ClientService clientService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesMessages facesMessages;
    @Inject
    private LanguageBean languageBean;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private ErrorHandlerService errorHandlerService;
    private String authAcr;
    private Integer authStep;
    private String lastResult;
    private SessionId curentSessionId;

    public boolean authenticate() {
        HttpServletRequest servletRequest = (HttpServletRequest)this.facesContext.getExternalContext().getRequest();
        SessionId sessionId = this.getSessionId(servletRequest);
        if (this.sessionIdService.isSessionIdAuthenticated(sessionId)) {
            this.errorHandlerService.handleError("login.userAlreadyAuthenticated", (IErrorType)AuthorizeErrorResponseType.RETRY, "Session is already authenticated. Please re-send authorization request. If AS errorHandlingMethod=remote then RP can get redirect with error and re-send authorization request automatically.");
            return false;
        }
        this.lastResult = this.authenticateImpl(servletRequest, true, false, false);
        this.logger.debug("authenticate resultCode: {}", (Object)this.lastResult);
        if ("success".equals(this.lastResult)) {
            return true;
        }
        if ("failure".equals(this.lastResult)) {
            this.authenticationFailed(sessionId);
        } else if ("no_permissions".equals(this.lastResult)) {
            this.handlePermissionsError();
        } else if ("expired".equals(this.lastResult)) {
            this.handleSessionInvalid();
        } else if ("authentication_failed".equals(this.lastResult)) {
            this.addSeverityMessages();
        }
        return false;
    }

    private void addSeverityMessages() {
        if (this.facesMessages.getMessages().size() == 0) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, AUTHENTICATION_ERROR_MESSAGE);
        }
    }

    public String authenticateWithOutcome() {
        HttpServletRequest servletRequest = (HttpServletRequest)this.facesContext.getExternalContext().getRequest();
        this.lastResult = this.authenticateImpl(servletRequest, true, false, false);
        if ("success".equals(this.lastResult)) {
            return this.lastResult;
        }
        if ("failure".equals(this.lastResult)) {
            this.authenticationFailed(this.sessionIdService.getSessionId());
        } else if ("no_permissions".equals(this.lastResult)) {
            this.handlePermissionsError();
        } else if ("expired".equals(this.lastResult)) {
            this.handleSessionInvalid();
        } else if ("authentication_failed".equals(this.lastResult)) {
            this.addSeverityMessages();
            this.handleLoginError(null);
        }
        return this.lastResult;
    }

    public boolean authenticateClient(HttpServletRequest servletRequest, boolean skipPassword) {
        String result = this.authenticateImpl(servletRequest, false, skipPassword, true);
        return "success".equals(result);
    }

    public boolean authenticateClient(HttpServletRequest servletRequest) {
        String result = this.authenticateImpl(servletRequest, false, false, true);
        return "success".equals(result);
    }

    public boolean authenticateUser(HttpServletRequest servletRequest) {
        String result = this.authenticateImpl(servletRequest, false, false, false);
        return "success".equals(result);
    }

    public boolean isServiceAuthentication(boolean service, boolean skipPassword, HttpServletRequest servletRequest) {
        if (!service) {
            return false;
        }
        return !(!StringHelper.isNotEmpty((String)this.credentials.getUsername()) || !skipPassword && !StringHelper.isNotEmpty((String)this.credentials.getPassword()) || servletRequest == null || !servletRequest.getRequestURI().endsWith("/token") && !servletRequest.getRequestURI().endsWith("/revoke") && !servletRequest.getRequestURI().endsWith("/revoke_session") && !servletRequest.getRequestURI().endsWith("/global-token-revocation") && !servletRequest.getRequestURI().endsWith("/userinfo") && !servletRequest.getRequestURI().endsWith("/bc-authorize") && !servletRequest.getRequestURI().endsWith("/par") && !servletRequest.getRequestURI().endsWith("/device_authorization"));
    }

    public String authenticateImpl(HttpServletRequest servletRequest, boolean interactive, boolean skipPassword, boolean service) {
        String result = "failure";
        try {
            this.logger.trace("Authenticating ... (interactive: {}, skipPassword: {}, credentials.username: {})", new Object[]{interactive, skipPassword, ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername())});
            if (this.isServiceAuthentication(service, skipPassword, servletRequest)) {
                boolean authenticated = this.clientAuthentication(this.credentials, interactive, skipPassword);
                if (authenticated) {
                    result = "success";
                }
            } else if (interactive) {
                result = this.userAuthenticationInteractive(servletRequest);
            } else {
                boolean authenticated = this.userAuthenticationService();
                if (authenticated) {
                    result = "success";
                }
            }
        }
        catch (InvalidSessionStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        if ("success".equals(result)) {
            this.logger.trace("Authentication successfully for '{}'", (Object)ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername()));
            return result;
        }
        this.logger.debug("Authentication failed for '{}'", (Object)ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername()));
        return result;
    }

    public boolean clientAuthentication(Credentials credentials, boolean interactive, boolean skipPassword) {
        boolean loggedIn;
        boolean isServiceUsesExternalAuthenticator;
        boolean bl = isServiceUsesExternalAuthenticator = !interactive && this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.SERVICE);
        if (isServiceUsesExternalAuthenticator) {
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.determineCustomScriptConfiguration(AuthenticationScriptUsageType.SERVICE, 1, this.authAcr);
            if (customScriptConfiguration == null) {
                this.logger.error("Failed to get CustomScriptConfiguration. acr: '{}'", (Object)this.authAcr);
            } else {
                this.authAcr = customScriptConfiguration.getCustomScript().getName();
                boolean result = this.externalAuthenticationService.executeExternalAuthenticate(customScriptConfiguration, null, 1);
                this.logger.info("Authentication result for user '{}', result: '{}'", (Object)ServerUtil.sanitizeUsernameForLog(credentials.getUsername()), (Object)result);
                if (result) {
                    Client client = this.authenticationService.configureSessionClient();
                    this.showClientAuthenticationLog(client);
                    return true;
                }
            }
        }
        if (!(loggedIn = skipPassword)) {
            loggedIn = this.clientService.authenticate(credentials.getUsername(), credentials.getPassword());
        }
        if (loggedIn) {
            Client client = this.authenticationService.configureSessionClient();
            this.showClientAuthenticationLog(client);
            return true;
        }
        return false;
    }

    private void showClientAuthenticationLog(Client client) {
        StringBuilder sb = new StringBuilder("Authentication success for Client");
        if (StringHelper.toBoolean((Boolean)this.appConfiguration.getLogClientIdOnClientAuthentication(), (boolean)false) || StringHelper.toBoolean((Boolean)this.appConfiguration.getLogClientNameOnClientAuthentication(), (boolean)false)) {
            sb.append(":");
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getLogClientIdOnClientAuthentication())) {
                sb.append(" ").append("'").append(client.getClientId()).append("'");
            }
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getLogClientNameOnClientAuthentication())) {
                sb.append(" ").append("('").append(client.getClientName()).append("')");
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(sb.toString());
        }
    }

    private String userAuthenticationInteractive(HttpServletRequest servletRequest) {
        SessionId sessionId = this.getSessionId(servletRequest);
        Map<String, String> sessionIdAttributes = this.sessionIdService.getSessionAttributes(sessionId);
        if (sessionIdAttributes == null) {
            this.logger.debug("Unable to get session attributes. SessionId: {}", (Object)(sessionId != null ? sessionId.getId() : null));
            return "expired";
        }
        this.identity.setSessionId(sessionId);
        this.initCustomAuthenticatorVariables(sessionIdAttributes);
        boolean useExternalAuthenticator = this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE);
        String sanitizedUsername = ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername());
        if (useExternalAuthenticator && !StringHelper.isEmpty((String)this.authAcr) && !"simple_password_auth".equalsIgnoreCase(this.authAcr)) {
            String userId;
            this.initCustomAuthenticatorVariables(sessionIdAttributes);
            if (this.authStep == null || StringHelper.isEmpty((String)this.authAcr)) {
                this.logger.error("Failed to determine authentication mode");
                return "expired";
            }
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, this.authAcr);
            if (customScriptConfiguration == null) {
                this.logger.error("Failed to get CustomScriptConfiguration for acr: '{}', auth_step: '{}'", (Object)this.authAcr, (Object)this.authStep);
                return "failure";
            }
            boolean passedPreviousSteps = this.isPassedPreviousAuthSteps(sessionIdAttributes, this.authStep);
            if (!passedPreviousSteps) {
                this.logger.error("There are authentication steps not marked as passed. acr: '{}', auth_step: '{}'", (Object)this.authAcr, (Object)this.authStep);
                return "failure";
            }
            this.setIdentityWorkingParameters(sessionIdAttributes);
            boolean result = this.externalAuthenticationService.executeExternalAuthenticate(customScriptConfiguration, this.externalContext.getRequestParameterValuesMap(), this.authStep);
            if (this.logger.isDebugEnabled() && StringHelper.isEmpty((String)(userId = this.credentials.getUsername()))) {
                User user = this.identity.getUser();
                if (user != null) {
                    userId = user.getUserId();
                }
                this.logger.debug("Authentication result for user '{}'. auth_step: '{}', result: '{}', credentials: '{}'", new Object[]{userId, this.authStep, result, System.identityHashCode(this.credentials)});
            }
            int overridenNextStep = -1;
            this.logger.trace("################## acr: {}, step: {}", (Object)this.authAcr, (Object)this.authStep);
            int apiVersion = this.externalAuthenticationService.executeExternalGetApiVersion(customScriptConfiguration);
            if (apiVersion > 1) {
                this.logger.trace("According to API version script supports steps overriding");
                overridenNextStep = this.externalAuthenticationService.getNextStep(customScriptConfiguration, this.externalContext.getRequestParameterValuesMap(), this.authStep);
                this.logger.debug("Get next step from script: '{}'", (Object)overridenNextStep);
            }
            if (!result && overridenNextStep == -1) {
                this.sessionIdService.updateSessionId(sessionId);
                return "authentication_failed";
            }
            boolean overrideCurrentStep = false;
            if (overridenNextStep > -1) {
                overrideCurrentStep = true;
                if ((sessionId = this.sessionIdService.resetToStep(sessionId, overridenNextStep)) == null) {
                    return "authentication_failed";
                }
                this.authStep = overridenNextStep;
                this.logger.info("Authentication reset to step : '{}'", (Object)this.authStep);
            }
            this.updateExtraParameters(customScriptConfiguration, this.authStep + 1, sessionIdAttributes);
            int countAuthenticationSteps = this.externalAuthenticationService.executeExternalGetCountAuthenticationSteps(customScriptConfiguration);
            sessionIdAttributes = this.sessionIdService.getSessionAttributes(sessionId);
            if (this.authStep < countAuthenticationSteps || overrideCurrentStep) {
                boolean updateResult;
                int nextStep = overrideCurrentStep ? overridenNextStep : this.authStep + 1;
                String redirectTo = this.externalAuthenticationService.executeExternalGetPageForStep(customScriptConfiguration, nextStep);
                if (redirectTo == null) {
                    return "failure";
                }
                if (StringHelper.isEmpty((String)redirectTo)) {
                    redirectTo = "/login.xhtml";
                }
                this.updateExtraParameters(customScriptConfiguration, nextStep, sessionIdAttributes);
                if (!overrideCurrentStep) {
                    sessionIdAttributes.put("auth_step", Integer.toString(nextStep));
                    this.markAuthStepAsPassed(sessionIdAttributes, this.authStep);
                }
                if (sessionId != null && !(updateResult = this.updateSession(sessionId, sessionIdAttributes))) {
                    return "expired";
                }
                this.logger.trace("Redirect to page: '{}'", (Object)redirectTo);
                this.facesService.redirectWithExternal(redirectTo, null);
                return "success";
            }
            if (this.authStep == countAuthenticationSteps) {
                this.updateExtraParameters(customScriptConfiguration, this.authStep + 1, sessionIdAttributes);
                SessionId eventSessionId = this.authenticationService.configureSessionUser(sessionId, sessionIdAttributes);
                this.authenticationService.quietLogin(this.credentials.getUsername());
                this.logger.debug("Sending event to trigger user redirection: '{}'", (Object)sanitizedUsername);
                this.authenticationService.onSuccessfulLogin(eventSessionId);
                this.logger.info(AUTHENTICATION_SUCCESS_FOR_USER, (Object)sanitizedUsername);
                return "success";
            }
        } else if (StringHelper.isNotEmpty((String)this.credentials.getUsername())) {
            boolean authenticated = this.authenticationService.authenticate(this.credentials.getUsername(), this.credentials.getPassword());
            if (authenticated) {
                SessionId eventSessionId = this.authenticationService.configureSessionUser(sessionId, sessionIdAttributes);
                this.logger.info("Sending event to trigger user redirection: '{}'", (Object)sanitizedUsername);
                this.authenticationService.onSuccessfulLogin(eventSessionId);
                this.logger.info(AUTHENTICATION_SUCCESS_FOR_USER, (Object)sanitizedUsername);
                return "success";
            }
            this.sessionIdService.updateSessionId(sessionId);
            this.logger.info("Authentication failed for user: {}", (Object)sanitizedUsername);
        }
        return "failure";
    }

    protected void handleSessionInvalid() {
        this.errorHandlerService.handleError(INVALID_SESSION_MESSAGE, (IErrorType)AuthorizeErrorResponseType.AUTHENTICATION_SESSION_INVALID, "Create authorization request to start new authentication session.");
    }

    protected void handleScriptError(SessionId sessionId) {
        this.handleScriptError(sessionId, AUTHENTICATION_ERROR_MESSAGE);
    }

    protected void handleScriptError(SessionId sessionId, String facesMessageId) {
        AuthorizeErrorResponseType errorType = sessionId == null ? AuthorizeErrorResponseType.AUTHENTICATION_SESSION_INVALID : AuthorizeErrorResponseType.INVALID_AUTHENTICATION_METHOD;
        this.errorHandlerService.handleError(facesMessageId, (IErrorType)errorType, "Contact administrator to fix specific ACR method issue.");
    }

    protected void handlePermissionsError() {
        this.errorHandlerService.handleError("login.youDontHavePermission", (IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Contact administrator to grant access to resource.");
    }

    protected void handleLoginError(String facesMessageId) {
        this.errorHandlerService.handleError(facesMessageId, (IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED, "User should log into into system.");
    }

    private boolean updateSession(SessionId sessionId, Map<String, String> sessionIdAttributes) {
        sessionId.setSessionAttributes(sessionIdAttributes);
        boolean updateResult = this.sessionIdService.updateSessionId(sessionId, true, true, true);
        if (!updateResult) {
            this.logger.debug("Failed to update session entry: '{}'", (Object)sessionId.getId());
            return false;
        }
        return true;
    }

    private boolean userAuthenticationService() {
        if (this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.SERVICE)) {
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.determineCustomScriptConfiguration(AuthenticationScriptUsageType.SERVICE, 1, this.authAcr);
            if (customScriptConfiguration == null) {
                this.logger.error("Failed to get CustomScriptConfiguration. auth_step: '{}', acr: '{}'", (Object)this.authStep, (Object)this.authAcr);
            } else {
                this.authAcr = customScriptConfiguration.getName();
                boolean result = this.externalAuthenticationService.executeExternalAuthenticate(customScriptConfiguration, null, 1);
                this.logger.info("Authentication result for '{}'. auth_step: '{}', result: '{}'", new Object[]{ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername()), this.authStep, result});
                if (result) {
                    this.authenticationService.configureEventUser();
                    this.logger.info(AUTHENTICATION_SUCCESS_FOR_USER, (Object)ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername()));
                    return true;
                }
                this.logger.info("Authentication failed for User: '{}'", (Object)ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername()));
            }
        }
        if (StringHelper.isNotEmpty((String)this.credentials.getUsername())) {
            boolean authenticated = this.authenticationService.authenticate(this.credentials.getUsername(), this.credentials.getPassword());
            if (authenticated) {
                this.authenticationService.configureEventUser();
                this.logger.info(AUTHENTICATION_SUCCESS_FOR_USER, (Object)ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername()));
                return true;
            }
            this.logger.info("Authentication failed for User: '{}'", (Object)ServerUtil.sanitizeUsernameForLog(this.credentials.getUsername()));
        }
        return false;
    }

    private void setIdentityWorkingParameters(Map<String, String> sessionIdAttributes) {
        Map<String, String> authExternalAttributes = this.authenticationService.getExternalScriptExtraParameters(sessionIdAttributes);
        HashMap workingParameters = this.identity.getWorkingParameters();
        for (Map.Entry<String, String> authExternalAttributeEntry : authExternalAttributes.entrySet()) {
            String authExternalAttributeName = authExternalAttributeEntry.getKey();
            String authExternalAttributeType = authExternalAttributeEntry.getValue();
            if (!sessionIdAttributes.containsKey(authExternalAttributeName)) continue;
            String authExternalAttributeValue = sessionIdAttributes.get(authExternalAttributeName);
            Object typedValue = this.requestParameterService.getTypedValue(authExternalAttributeValue, authExternalAttributeType);
            workingParameters.put(authExternalAttributeName, typedValue);
        }
    }

    public String prepareAuthenticationForStep() {
        SessionId sessionId = this.sessionIdService.getSessionId();
        this.lastResult = this.prepareAuthenticationForStep(sessionId);
        if ("success".equals(this.lastResult)) {
            return this.lastResult;
        }
        if ("failure".equals(this.lastResult)) {
            this.handleScriptError(sessionId);
        } else if ("no_permissions".equals(this.lastResult)) {
            this.handlePermissionsError();
        } else if ("expired".equals(this.lastResult)) {
            this.handleSessionInvalid();
        }
        return this.lastResult;
    }

    public String prepareAuthenticationForStep(SessionId sessionId) {
        Map<String, String> sessionIdAttributes = this.sessionIdService.getSessionAttributes(sessionId);
        if (sessionIdAttributes == null) {
            this.logger.debug("Unable to get attributes from session");
            return "expired";
        }
        this.identity.setSessionId(sessionId);
        if (!this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE)) {
            return "success";
        }
        this.initCustomAuthenticatorVariables(sessionIdAttributes);
        if (StringHelper.isEmpty((String)this.authAcr) || "simple_password_auth".equalsIgnoreCase(this.authAcr)) {
            return "success";
        }
        if (this.authStep == null || this.authStep < 1) {
            return "no_permissions";
        }
        CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, this.authAcr);
        if (customScriptConfiguration == null) {
            this.logger.error("Failed to get CustomScriptConfiguration. auth_step: '{}', acr: '{}'", (Object)this.authStep, (Object)this.authAcr);
            return "failure";
        }
        boolean passedPreviousSteps = this.isPassedPreviousAuthSteps(sessionIdAttributes, this.authStep);
        if (!passedPreviousSteps) {
            this.logger.error("There are authentication steps not marked as passed. acr: '{}', auth_step: '{}'", (Object)this.authAcr, (Object)this.authStep);
            return "failure";
        }
        this.setIdentityWorkingParameters(sessionIdAttributes);
        String currentauthAcr = customScriptConfiguration.getName();
        customScriptConfiguration = this.externalAuthenticationService.determineExternalAuthenticatorForWorkflow(AuthenticationScriptUsageType.INTERACTIVE, customScriptConfiguration);
        if (customScriptConfiguration == null) {
            return "failure";
        }
        String determinedauthAcr = customScriptConfiguration.getName();
        if (!StringHelper.equalsIgnoreCase((String)currentauthAcr, (String)determinedauthAcr)) {
            boolean updateResult;
            CustomScriptConfiguration determinedCustomScriptConfiguration;
            String redirectTo = this.externalAuthenticationService.executeExternalGetPageForStep(customScriptConfiguration, this.authStep);
            if (StringHelper.isEmpty((String)redirectTo)) {
                redirectTo = "/login.xhtml";
            }
            if ((determinedCustomScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, determinedauthAcr)) == null) {
                this.logger.error("Failed to get determined CustomScriptConfiguration. auth_step: '{}', acr: '{}'", (Object)this.authStep, (Object)this.authAcr);
                return "failure";
            }
            this.logger.debug("Redirect to page: '{}'. Force to use acr: '{}'", (Object)redirectTo, (Object)determinedauthAcr);
            determinedauthAcr = determinedCustomScriptConfiguration.getName();
            String determinedAuthLevel = Integer.toString(determinedCustomScriptConfiguration.getLevel());
            sessionIdAttributes.put("acr", determinedauthAcr);
            sessionIdAttributes.put("auth_level", determinedAuthLevel);
            sessionIdAttributes.put("auth_step", Integer.toString(1));
            if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getKeepAuthenticatorAttributesOnAcrChange())) {
                this.authenticationService.clearExternalScriptExtraParameters(sessionIdAttributes);
            }
            if (sessionId != null && !(updateResult = this.updateSession(sessionId, sessionIdAttributes))) {
                return "expired";
            }
            this.facesService.redirectWithExternal(redirectTo, null);
            return "success";
        }
        return this.executeExternalPrepareForStep(sessionId, sessionIdAttributes, customScriptConfiguration);
    }

    @NotNull
    private String executeExternalPrepareForStep(SessionId sessionId, Map<String, String> sessionIdAttributes, CustomScriptConfiguration customScriptConfiguration) {
        boolean result = this.externalAuthenticationService.executeExternalPrepareForStep(customScriptConfiguration, this.externalContext.getRequestParameterValuesMap(), this.authStep);
        if (result) {
            boolean updateResult;
            this.updateExtraParameters(customScriptConfiguration, this.authStep, sessionIdAttributes);
            if (sessionId != null && !(updateResult = this.updateSession(sessionId, sessionIdAttributes))) {
                return "failure";
            }
            return "success";
        }
        return "failure";
    }

    public boolean authenticateBySessionId(String sessionIdentifier) {
        if (StringUtils.isNotBlank((CharSequence)sessionIdentifier)) {
            try {
                SessionId sessionId = this.sessionIdService.getSessionId(sessionIdentifier);
                return this.authenticateBySessionId(sessionId);
            }
            catch (Exception e) {
                this.logger.trace(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean authenticateBySessionId(SessionId sessionId) {
        User user;
        if (sessionId == null) {
            return false;
        }
        String sessionIdentifier = sessionId.getId();
        this.logger.trace("authenticateBySessionId, sessionId = '{}', session = '{}', state= '{}'", new Object[]{sessionIdentifier, sessionId, sessionId.getState()});
        if (SessionIdState.AUTHENTICATED == sessionId.getState() && (user = this.authenticationService.getUserOrRemoveSession(sessionId)) != null) {
            try {
                this.authenticationService.quietLogin(user.getUserId());
                this.authenticationService.configureEventUser(sessionId);
            }
            catch (Exception e) {
                this.logger.trace(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private void initCustomAuthenticatorVariables(Map<String, String> sessionIdAttributes) {
        if (sessionIdAttributes == null) {
            this.logger.error("Failed to restore attributes from session attributes");
            return;
        }
        this.authStep = StringHelper.toInteger((String)sessionIdAttributes.get("auth_step"), null);
        this.authAcr = sessionIdAttributes.get("acr");
        if (AcrService.isAgama(this.authAcr)) {
            this.authAcr = "agama";
        }
    }

    private boolean authenticationFailed(SessionId sessionId) {
        this.addMessage(FacesMessage.SEVERITY_ERROR, "login.errorMessage");
        this.handleScriptError(sessionId);
        return false;
    }

    private void markAuthStepAsPassed(Map<String, String> sessionIdAttributes, Integer authStep) {
        String key = String.format("auth_step_passed_%d", authStep);
        sessionIdAttributes.put(key, Boolean.TRUE.toString());
    }

    private boolean isAuthStepPassed(Map<String, String> sessionIdAttributes, Integer authStep) {
        String key = String.format("auth_step_passed_%d", authStep);
        return sessionIdAttributes.containsKey(key) && Boolean.parseBoolean(sessionIdAttributes.get(key));
    }

    private boolean isPassedPreviousAuthSteps(Map<String, String> sessionIdAttributes, Integer authStep) {
        for (int i = 1; i < authStep; ++i) {
            boolean isAuthStepPassed = this.isAuthStepPassed(sessionIdAttributes, i);
            if (isAuthStepPassed) continue;
            return false;
        }
        return true;
    }

    private void updateExtraParameters(CustomScriptConfiguration customScriptConfiguration, int step, Map<String, String> sessionIdAttributes) {
        List<String> extraParameters = this.externalAuthenticationService.executeExternalGetExtraParametersForStep(customScriptConfiguration, step);
        this.authenticationService.updateExtraParameters(sessionIdAttributes, extraParameters);
    }

    public void configureSessionClient(Client client) {
        this.authenticationService.configureSessionClient(client);
    }

    public void addMessage(FacesMessage.Severity severity, String summary) {
        String message = this.languageBean.getMessage(summary);
        this.facesMessages.add(severity, message);
    }

    private SessionId getSessionId(HttpServletRequest servletRequest) {
        if (this.curentSessionId == null && this.identity.getSessionId() != null) {
            this.curentSessionId = this.identity.getSessionId();
            return this.curentSessionId;
        }
        if (this.curentSessionId == null) {
            this.curentSessionId = this.sessionIdService.getSessionId(servletRequest);
        }
        return this.curentSessionId;
    }

    public String getMaskedNumber() {
        String result = this.getFullNumber();
        if (result.length() > 7) {
            String sub = result.substring(4, 6);
            result = result.replace(sub, "XX");
        }
        return result;
    }

    @NotNull
    private String getFullNumber() {
        String phone = null;
        SessionId sessionId = this.sessionIdService.getSessionId();
        if (sessionId != null && StringUtils.isBlank((CharSequence)(phone = (String)sessionId.getSessionAttributes().get("mobile_number")))) {
            phone = (String)sessionId.getSessionAttributes().get("mobile");
        }
        return StringUtils.isBlank(phone) ? "UNKNOWN USER PHONE." : phone;
    }
}

