/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import io.jans.as.model.util.QueryStringDecoder;
import io.jans.as.server.authorize.ws.rs.AuthorizationChallengeService;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.service.RequestParameterService;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/authorize-challenge")
public class AuthorizationChallengeEndpoint {
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private AuthorizationChallengeService authorizationChallengeService;

    @POST
    @Produces(value={"application/json"})
    public Response requestAuthorizationPost(@FormParam(value="client_id") String clientId, @FormParam(value="scope") String scope, @FormParam(value="acr_values") String acrValues, @FormParam(value="auth_session") String authorizationChallengeSession, @FormParam(value="use_auth_session") String useAuthorizationChallengeSession, @FormParam(value="device_session") String deviceSession, @FormParam(value="use_device_session") String useDeviceSession, @FormParam(value="prompt") String prompt, @FormParam(value="state") String state, @FormParam(value="nonce") String nonce, @FormParam(value="code_challenge") String codeChallenge, @FormParam(value="code_challenge_method") String codeChallengeMethod, @FormParam(value="authorization_details") String authorizationDetails, @FormParam(value="logout_status_jwt") String shouldReturnLogoutStatusJwt, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        AuthzRequest authzRequest = new AuthzRequest();
        authzRequest.setHttpMethod("POST");
        authzRequest.setClientId(clientId);
        authzRequest.setScope(scope);
        authzRequest.setAcrValues(acrValues);
        authzRequest.setAuthorizationChallengeSession(authorizationChallengeSession);
        authzRequest.setUseAuthorizationChallengeSession(Boolean.parseBoolean(useAuthorizationChallengeSession));
        authzRequest.setState(state);
        authzRequest.setNonce(nonce);
        authzRequest.setPrompt(prompt);
        authzRequest.setCustomParameters(this.requestParameterService.getCustomParameters(QueryStringDecoder.decode((String)httpRequest.getQueryString())));
        authzRequest.setHttpRequest(httpRequest);
        authzRequest.setHttpResponse(httpResponse);
        authzRequest.setCodeChallenge(codeChallenge);
        authzRequest.setCodeChallengeMethod(codeChallengeMethod);
        authzRequest.setAuthzDetailsString(authorizationDetails);
        authzRequest.setDpop(httpRequest.getHeader("DPoP"));
        authzRequest.setShouldReturnLogoutStatusJwt(Boolean.parseBoolean(shouldReturnLogoutStatusJwt));
        if (authorizationChallengeSession == null && deviceSession != null) {
            authzRequest.setAuthorizationChallengeSession(deviceSession);
        }
        if (useAuthorizationChallengeSession == null && useDeviceSession != null) {
            authzRequest.setUseAuthorizationChallengeSession(Boolean.parseBoolean(useDeviceSession));
        }
        return this.authorizationChallengeService.requestAuthorization(authzRequest);
    }
}

