/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.AuthorizationChallengeSession;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.server.auth.DpopService;
import io.jans.as.server.service.ScopeService;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@RequestScoped
public class AuthorizationChallengeValidator {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ScopeService scopeService;

    public void validateDpopJkt(AuthorizationChallengeSession session, String dpop) {
        String jkt = session.getAttributes().getJkt();
        if (StringUtils.isBlank((CharSequence)jkt)) {
            return;
        }
        try {
            String dpopJwkThumbprint = DpopService.getDpopJwkThumbprint(dpop);
            if (jkt.equals(dpopJwkThumbprint)) {
                return;
            }
            this.log.debug("Unable to match dpopJkt: {} with sessionJkt: {}", (Object)dpopJwkThumbprint, (Object)jkt);
        }
        catch (Exception e) {
            String msg = String.format("Failed to validate dpop jtk. jkt: %s, dpop: %s", jkt, dpop);
            this.log.debug(msg, (Throwable)e);
        }
        throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)TokenErrorResponseType.INVALID_DPOP_PROOF, "", "Invalid DPoP.")).build());
    }

    public void validateGrantType(Client client, String state) {
        if (client == null) {
            String msg = "Unable to find client.";
            this.log.debug("Unable to find client.");
            throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "Unable to find client.")).build());
        }
        if (client.getGrantTypes() == null || !Arrays.asList(client.getGrantTypes()).contains(GrantType.AUTHORIZATION_CODE)) {
            String msg = String.format("Client %s does not support grant_type=authorization_code", client.getClientId());
            this.log.debug(msg);
            throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, msg)).build());
        }
        Set grantTypesSupported = this.appConfiguration.getGrantTypesSupported();
        if (grantTypesSupported == null || !grantTypesSupported.contains(GrantType.AUTHORIZATION_CODE)) {
            String msg = "AS configuration does not allow grant_type=authorization_code";
            this.log.debug(msg);
            throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, msg)).build());
        }
    }

    public void validateAccess(Client client) {
        if (client == null || ArrayUtils.isEmpty((Object[])client.getScopes())) {
            this.log.debug("Client is null or have no scopes defined. Rejected request.");
            throw new WebApplicationException(Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST)).build());
        }
        List<String> scopesAllowedIds = this.scopeService.getScopeIdsByDns(Arrays.asList(client.getScopes()));
        if (!scopesAllowedIds.contains("authorization_challenge")) {
            this.log.debug("Client does not have required 'authorization_challenge' scope.");
            throw new WebApplicationException(Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST)).build());
        }
    }
}

