/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.Util;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.SessionIdService;
import io.jans.orm.exception.EntryPersistenceException;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class ConsentGatheringSessionService {
    @Inject
    private Logger log;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;

    public SessionId getConnectSession(HttpServletRequest httpRequest) {
        String cookieId = this.cookieService.getSessionIdFromCookie(httpRequest);
        this.log.trace("Cookie - session_id: {}", (Object)cookieId);
        if (StringUtils.isNotBlank((CharSequence)cookieId)) {
            return this.sessionIdService.getSessionId(cookieId);
        }
        return null;
    }

    public boolean hasCookie(HttpServletRequest httpRequest) {
        String cookieId = this.cookieService.getConsentSessionIdFromCookie(httpRequest);
        return StringUtils.isNotBlank((CharSequence)cookieId);
    }

    public SessionId getConsentSession(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String userDn, boolean create) {
        String cookieId = this.cookieService.getConsentSessionIdFromCookie(httpRequest);
        this.log.trace("Cookie - consent_session_id: {}", (Object)cookieId);
        if (StringUtils.isNotBlank((CharSequence)cookieId)) {
            SessionId sessionId = this.sessionIdService.getSessionId(cookieId);
            if (sessionId != null) {
                this.log.trace("Loaded consent_session_id from cookie, session: {}", (Object)sessionId);
                return sessionId;
            }
            this.log.error("Failed to load consent_session_id from cookie: {}", (Object)cookieId);
        } else if (!create) {
            this.log.error("consent_session_id cookie is not set.");
        }
        if (!create) {
            return null;
        }
        this.log.trace("Generating new consent_session_id ...");
        SessionId session = this.sessionIdService.generateUnauthenticatedSessionId(userDn);
        this.cookieService.createCookieWithState(session.getId(), session.getSessionState(), session.getOPBrowserState(), httpRequest, httpResponse, "consent_session_id");
        this.log.trace("consent_session_id cookie created.");
        return session;
    }

    public void setAuthenticatedSessionState(HttpServletRequest httpRequest, HttpServletResponse httpResponse, SessionId sessionId) {
        SessionId connectSession = this.getConnectSession(httpRequest);
        this.sessionIdService.setSessionIdStateAuthenticated(httpRequest, httpResponse, sessionId, connectSession.getUserDn());
    }

    public boolean isSessionStateAuthenticated(HttpServletRequest httpRequest) {
        boolean hasSession = this.hasCookie(httpRequest);
        if (hasSession) {
            SessionId session = this.getConsentSession(httpRequest, null, null, false);
            return this.sessionIdService.isSessionIdAuthenticated(session);
        }
        return false;
    }

    public boolean persist(SessionId session) {
        try {
            if (this.sessionIdService.updateSessionId(session, true)) {
                this.log.trace("Session updated successfully. Session: " + session);
                return true;
            }
        }
        catch (EntryPersistenceException e) {
            try {
                if (this.sessionIdService.persistSessionId(session, true)) {
                    this.log.trace("Session persisted successfully. Session: " + session);
                    return true;
                }
            }
            catch (Exception ex) {
                this.log.error("Failed to persist session, id: " + session.getId(), (Throwable)ex);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to persist session, id: " + session.getId(), (Throwable)e);
        }
        return false;
    }

    public int getStep(SessionId session) {
        String stepString = (String)session.getSessionAttributes().get("step");
        int step = Util.parseIntSilently((String)stepString);
        if (step == -1) {
            step = 1;
            this.setStep(step, session);
        }
        return step;
    }

    public void setStep(int step, SessionId session) {
        session.getSessionAttributes().put("step", Integer.toString(step));
    }

    public String getAcr(SessionId session) {
        return (String)session.getSessionAttributes().get("acr");
    }

    public void setAcr(List<String> acrValues, SessionId session) {
        session.getSessionAttributes().put("acr", Util.listAsString(acrValues));
    }

    public String getConsentFlow(SessionId session) {
        return (String)session.getSessionAttributes().get("consent_flow");
    }

    public void setConsentFlow(String consentFlow, SessionId session) {
        session.getSessionAttributes().put("consent_flow", consentFlow);
    }

    public void configure(SessionId session, String scriptName, String clientId, String state, List<String> acrValues) {
        this.setStep(1, session);
        this.setScriptName(session, scriptName);
        this.setAcr(acrValues, session);
        this.setConsentFlow(this.determineConsentFlow(acrValues), session);
        this.setClientId(session, clientId);
        this.persist(session);
    }

    private String determineConsentFlow(List<String> acrValues) {
        if (acrValues == null || acrValues.isEmpty()) {
            this.log.debug("determineConsentFlow - 'acrValues' is empty, return null for 'consent_flow'");
            return null;
        }
        Map acrToConsent = this.appConfiguration.getAcrToAgamaConsentFlowMapping();
        if (acrToConsent == null || acrToConsent.isEmpty()) {
            this.log.debug("determineConsentFlow - 'acrToAgamaConsentFlowMapping' configuration property is empty, return null for 'consent_flow'");
            return null;
        }
        for (String acr : acrValues) {
            String consentFlow = (String)acrToConsent.get(acr);
            if (!StringUtils.isNotBlank((CharSequence)consentFlow)) continue;
            this.log.debug("determineConsentFlow - found consent_flow: {} for acr: {}", (Object)consentFlow, (Object)acr);
            return consentFlow;
        }
        this.log.debug("determineConsentFlow - unable to find any match for acr: {}, acrToConsentScriptNameMapping: {}", acrValues, (Object)acrToConsent);
        return null;
    }

    public boolean isStepPassed(SessionId session, Integer step) {
        return Boolean.parseBoolean((String)session.getSessionAttributes().get(String.format("consent_step_passed_%d", step)));
    }

    public boolean isPassedPreviousSteps(SessionId session, Integer step) {
        for (int i = 1; i < step; ++i) {
            if (this.isStepPassed(session, i)) continue;
            return false;
        }
        return true;
    }

    public void markStep(SessionId session, Integer step, boolean value) {
        String key = String.format("consent_step_passed_%d", step);
        if (value) {
            session.getSessionAttributes().put(key, Boolean.TRUE.toString());
        } else {
            session.getSessionAttributes().remove(key);
        }
    }

    public String getScriptName(SessionId session) {
        return (String)session.getSessionAttributes().get("gather_script_name");
    }

    public void setScriptName(SessionId session, String scriptName) {
        session.getSessionAttributes().put("gather_script_name", scriptName);
    }

    public String getClientId(SessionId session) {
        return (String)session.getSessionAttributes().get("client_id");
    }

    public void setClientId(SessionId session, String clientId) {
        session.getSessionAttributes().put("client_id", clientId);
    }

    public void resetToStep(SessionId session, int overridenNextStep, int step) {
        for (int i = overridenNextStep; i <= step; ++i) {
            this.markStep(session, i, false);
        }
        this.setStep(overridenNextStep, session);
    }

    public User getUser(HttpServletRequest httpRequest, String ... returnAttributes) {
        return this.sessionIdService.getUser(this.getConnectSession(httpRequest));
    }

    public String getUserDn(HttpServletRequest httpRequest) {
        SessionId connectSession = this.getConnectSession(httpRequest);
        if (connectSession != null) {
            return connectSession.getUserDn();
        }
        this.log.trace("No logged in user.");
        return null;
    }

    public Client getClient(SessionId session) {
        String clientId = this.getClientId(session);
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            return this.clientService.getClient(clientId);
        }
        this.log.trace("client_id is not in session.");
        return null;
    }
}

