/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ciba;

import io.jans.as.model.ciba.BackchannelAuthenticationErrorResponseType;
import io.jans.as.model.error.DefaultErrorResponse;
import io.jans.as.model.error.IErrorType;
import jakarta.ejb.Stateless;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Response;
import org.apache.logging.log4j.util.Strings;

@Stateless
@Named
public class CIBADeviceRegistrationValidatorService {
    public DefaultErrorResponse validateParams(String idTokenHint, String deviceRegistrationToken) {
        if (Strings.isBlank((String)deviceRegistrationToken)) {
            DefaultErrorResponse errorResponse = new DefaultErrorResponse();
            errorResponse.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            errorResponse.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST);
            errorResponse.setReason("The device registration token cannot be blank.");
            return errorResponse;
        }
        if (Strings.isBlank((String)idTokenHint)) {
            DefaultErrorResponse errorResponse = new DefaultErrorResponse();
            errorResponse.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            errorResponse.setType((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID);
            errorResponse.setReason("The id token hint cannot be blank.");
            return errorResponse;
        }
        return null;
    }
}

