/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ciba;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.util.Util;
import io.jans.orm.annotation.AttributeEnum;
import jakarta.ejb.Stateless;
import jakarta.inject.Named;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBARegisterClientResponseService {
    private static final Logger log = LoggerFactory.getLogger(CIBARegisterClientResponseService.class);

    public void updateResponse(JSONObject responseJsonObject, Client client) {
        try {
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.BACKCHANNEL_TOKEN_DELIVERY_MODE.toString(), (AttributeEnum)client.getBackchannelTokenDeliveryMode());
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT.toString(), (Object)client.getBackchannelClientNotificationEndpoint());
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG.toString(), (AttributeEnum)client.getBackchannelAuthenticationRequestSigningAlg());
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.BACKCHANNEL_USER_CODE_PARAMETER.toString(), (Object)client.getBackchannelUserCodeParameter());
        }
        catch (JSONException e) {
            log.error("Failed to update response.", (Throwable)e);
        }
    }
}

