/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.filter;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.model.config.ConfigurationFactory;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebFilter(filterName="HeadersFilter", asyncSupported=true, urlPatterns={"/*"})
public class HeadersFilter
implements Filter {
    @Inject
    private ConfigurationFactory configurationFactory;

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HeadersFilter.addXFrameOptionsResponseHeader(httpRequest, httpResponse, this.configurationFactory.getAppConfiguration());
        chain.doFilter(request, response);
    }

    public static void addXFrameOptionsResponseHeader(HttpServletRequest httpRequest, HttpServletResponse httpResponse, AppConfiguration appConfiguration) {
        String requestURI = httpRequest.getRequestURI();
        boolean hasAny = appConfiguration.getApplyXFrameOptionsHeaderIfUriContainsAny().stream().anyMatch(requestURI::contains);
        if (requestURI.contains(".htm") || hasAny) {
            httpResponse.addHeader("X-Frame-Options", appConfiguration.getXframeOptionsHeaderValue().getValue());
        }
    }

    public void destroy() {
    }
}

