/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.idgen.ws.rs;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.IdType;
import io.jans.as.model.config.BaseDnConfiguration;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.config.GluuConfiguration;
import io.jans.model.JansAttribute;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.DummyEntry;
import io.jans.orm.search.filter.Filter;
import io.jans.util.INumGenerator;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named(value="inumGenerator")
public class InumGenerator {
    public static final String SEPARATOR = "!";
    private static final int MAX = 100;
    private final Pattern baseRdnPattern = Pattern.compile(".+o=([\\w\\!\\@\\.]+)$");
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public String generateId(String idTypeStr, String idPrefix) {
        IdType idType = IdType.fromString((String)idTypeStr);
        if (idType != null) {
            return this.generateId(idType, idPrefix);
        }
        this.log.error("Unable to identify id type: {}", (Object)idTypeStr);
        return "";
    }

    public String generateId(IdType idType, String idPrefix) {
        String inum;
        int counter = 0;
        try {
            while (true) {
                StringBuilder sb = new StringBuilder();
                sb.append(idPrefix).append(SEPARATOR).append(idType.getInum()).append(SEPARATOR);
                if (IdType.CLIENTS == idType || IdType.PEOPLE == idType) {
                    sb.append(INumGenerator.generate((int)4));
                } else {
                    sb.append(INumGenerator.generate((int)2));
                }
                inum = sb.toString();
                if (StringUtils.isBlank((CharSequence)inum)) {
                    this.log.error("Unable to generate inum: {}", (Object)inum);
                } else if (this.contains(inum, idType)) {
                    if (counter > 100) {
                        this.log.error("Infinite loop problem while generating new inum");
                        return "";
                    }
                    ++counter;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            inum = e.getMessage();
        }
        this.log.trace("Generated inum: {}", (Object)inum);
        return inum;
    }

    public boolean contains(String inum, IdType type) {
        String baseDn = this.baseDn(type);
        Filter filter = Filter.createEqualityFilter((String)"inum", (Object)inum);
        Class<?> entryClass = this.getEntryClass(type);
        List entries = this.ldapEntryManager.findEntries(baseDn, entryClass, filter);
        return entries != null && !entries.isEmpty();
    }

    private Class<?> getEntryClass(IdType type) {
        switch (type) {
            case CLIENTS: {
                return Client.class;
            }
            case CONFIGURATION: {
                return GluuConfiguration.class;
            }
            case ATTRIBUTE: {
                return JansAttribute.class;
            }
            case PEOPLE: {
                return User.class;
            }
        }
        return DummyEntry.class;
    }

    public String baseDn(IdType type) {
        BaseDnConfiguration baseDn = this.staticConfiguration.getBaseDn();
        switch (type) {
            case CLIENTS: {
                return baseDn.getClients();
            }
            case CONFIGURATION: {
                return baseDn.getConfiguration();
            }
            case ATTRIBUTE: {
                return baseDn.getAttributes();
            }
            case PEOPLE: {
                return baseDn.getPeople();
            }
        }
        Matcher m = this.baseRdnPattern.matcher(baseDn.getClients());
        if (m.matches()) {
            return m.group(1);
        }
        this.log.error("Use fallback DN: o=jans, for ID generator, please check Jans Auth configuration, clientDn must be valid DN");
        return "o=jans";
    }
}

