/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.introspection.ws.rs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.IntrospectionResponse;
import io.jans.as.model.common.TokenType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.UmaScopeType;
import io.jans.as.model.util.JsonUtil;
import io.jans.as.model.util.Util;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.IntrospectionService;
import io.jans.as.server.service.external.ExternalIntrospectionService;
import io.jans.as.server.service.external.context.ExternalIntrospectionContext;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.util.ServerUtil;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.util.Pair;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/introspection")
public class IntrospectionWebService {
    private static final Pair<AuthorizationGrant, Boolean> EMPTY = new Pair(null, (Object)false);
    private static final ObjectMapper OBJECT_MAPPER = ServerUtil.createJsonMapper();
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private TokenService tokenService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalIntrospectionService externalIntrospectionService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private IntrospectionService introspectionService;

    @GET
    @Produces(value={"application/json"})
    public Response introspectGet(@HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Accept") String accept, @QueryParam(value="token") String token, @QueryParam(value="token_type_hint") String tokenTypeHint, @QueryParam(value="response_as_jwt") String responseAsJwt, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(authorization, accept, token, tokenTypeHint, responseAsJwt, httpRequest, httpResponse);
    }

    @POST
    @Produces(value={"application/json"})
    public Response introspectPost(@HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Accept") String accept, @FormParam(value="token") String token, @FormParam(value="token_type_hint") String tokenTypeHint, @FormParam(value="response_as_jwt") String responseAsJwt, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(authorization, accept, token, tokenTypeHint, responseAsJwt, httpRequest, httpResponse);
    }

    private AuthorizationGrant validateAuthorization(String authorization, String token) throws UnsupportedEncodingException {
        try {
            boolean skipAuthorization = BooleanUtils.isTrue((Boolean)this.appConfiguration.getIntrospectionSkipAuthorization());
            this.log.trace("skipAuthorization: {}", (Object)skipAuthorization);
            if (skipAuthorization) {
                return null;
            }
            if (StringUtils.isBlank((CharSequence)authorization)) {
                this.log.trace("Bad request: Authorization header or token is blank.");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "")).build());
            }
            Pair<AuthorizationGrant, Boolean> pair = this.getAuthorizationGrant(authorization, token);
            AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getFirst();
            if (authorizationGrant == null) {
                this.log.debug("Authorization grant is null.");
                if (BooleanUtils.isTrue((Boolean)((Boolean)pair.getSecond()))) {
                    this.log.debug("Returned {\"active\":false}.");
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.OK).entity((Object)"{\"active\":false}").type(MediaType.APPLICATION_JSON_TYPE).build());
                }
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Authorization grant is null.")).build());
            }
            AbstractToken authorizationAccessToken = authorizationGrant.getAccessToken(this.tokenService.getToken(authorization));
            if ((authorizationAccessToken == null || !authorizationAccessToken.isValid()) && BooleanUtils.isFalse((Boolean)((Boolean)pair.getSecond()))) {
                this.log.error("Access token is not valid. Valid: {}, basicClientAuthentication: {}", (Object)(authorizationAccessToken != null && authorizationAccessToken.isValid() ? 1 : 0), pair.getSecond());
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Access token is not valid")).build());
            }
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getIntrospectionAccessTokenMustHaveUmaProtectionScope()) && !authorizationGrant.getScopesAsString().contains(UmaScopeType.PROTECTION.getValue())) {
                String reason = "access_token used to access introspection endpoint does not have uma_protection scope, however in AS configuration `checkUmaProtectionScopePresenceDuringIntrospection` is true";
                this.log.trace("access_token used to access introspection endpoint does not have uma_protection scope, however in AS configuration `checkUmaProtectionScopePresenceDuringIntrospection` is true");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "access_token used to access introspection endpoint does not have uma_protection scope, however in AS configuration `checkUmaProtectionScopePresenceDuringIntrospection` is true")).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
            this.introspectionService.validateIntrospectionScopePresence(authorizationGrant);
            return authorizationGrant;
        }
        catch (EntryPersistenceException e) {
            this.log.trace("Failed to find entry.", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Authorization is not valid")).build());
        }
    }

    private Response introspect(String authorization, String accept, String token, String tokenTypeHint, String responseAsJwt, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Introspect token, authorization: {}, token to introspect: {}, tokenTypeHint: {}, accept: {}", new Object[]{Util.escapeLog((Object)authorization), Util.escapeLog((Object)token), Util.escapeLog((Object)tokenTypeHint), Util.escapeLog((Object)accept)});
            }
            AuthorizationGrant authorizationGrant = this.validateAuthorization(authorization, token);
            if (StringUtils.isBlank((CharSequence)token)) {
                this.log.trace("Bad request: Token is blank.");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "")).build();
            }
            IntrospectionResponse response = new IntrospectionResponse(false);
            AuthorizationGrant grantOfIntrospectionToken = this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
            this.fillResponse(token, response, grantOfIntrospectionToken);
            JSONObject responseAsJsonObject = this.createResponseAsJsonObject(response, grantOfIntrospectionToken);
            ExternalIntrospectionContext context = new ExternalIntrospectionContext(authorizationGrant, httpRequest, httpResponse, this.appConfiguration, this.attributeService);
            context.setGrantOfIntrospectionToken(grantOfIntrospectionToken);
            if (this.externalIntrospectionService.executeExternalModifyResponse(responseAsJsonObject, context)) {
                this.log.trace("Successfully run external introspection scripts.");
            } else {
                responseAsJsonObject = this.createResponseAsJsonObject(response, grantOfIntrospectionToken);
                this.log.trace("Canceled changes made by external introspection script since method returned `false`.");
            }
            if (response.getScope() != null && !this.appConfiguration.getIntrospectionResponseScopesBackwardCompatibility().booleanValue()) {
                String scopes = StringUtils.join((Object[])response.getScope().toArray(), (String)" ");
                responseAsJsonObject.put("scope", (Object)scopes);
            }
            responseAsJsonObject = JsonUtil.filterOutNulls((JSONObject)responseAsJsonObject);
            if (this.introspectionService.isJwtResponse(responseAsJwt, accept)) {
                String responseAsJwtEntity = this.introspectionService.createResponseAsJwt(responseAsJsonObject, grantOfIntrospectionToken);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Response jwt entity: {}", (Object)responseAsJwtEntity);
                }
                return Response.status((Response.Status)Response.Status.OK).entity((Object)responseAsJwtEntity).type("application/token-introspection+jwt").build();
            }
            String entity = responseAsJsonObject.toString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Response entity: {}", (Object)entity);
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    @Nullable
    private AbstractToken fillResponse(String token, IntrospectionResponse response, AuthorizationGrant grantOfIntrospectionToken) {
        AbstractToken tokenToIntrospect = null;
        if (grantOfIntrospectionToken != null) {
            tokenToIntrospect = grantOfIntrospectionToken.getAccessToken(token);
            response.setActive(tokenToIntrospect.isValid());
            response.setExpiresAt(ServerUtil.dateToSeconds(tokenToIntrospect.getExpirationDate()));
            response.setIssuedAt(ServerUtil.dateToSeconds(tokenToIntrospect.getCreationDate()));
            response.setAcr(grantOfIntrospectionToken.getAcrValues());
            response.setScope((Collection)(grantOfIntrospectionToken.getScopes() != null ? grantOfIntrospectionToken.getScopes() : Lists.newArrayList()));
            response.setClientId(grantOfIntrospectionToken.getClientId());
            response.setSub(grantOfIntrospectionToken.getSub());
            response.setUsername(grantOfIntrospectionToken.getUserId());
            response.setIssuer(this.appConfiguration.getIssuer());
            response.setAudience(grantOfIntrospectionToken.getClientId());
            response.setAuthTime(ServerUtil.dateToSeconds(grantOfIntrospectionToken.getAuthenticationTime()));
            AuthzDetails authzDetails = grantOfIntrospectionToken.getAuthzDetails();
            if (!AuthzDetails.isEmpty((AuthzDetails)authzDetails)) {
                try {
                    JsonNode authorizationDetailsNode = OBJECT_MAPPER.readTree(authzDetails.asJsonString());
                    response.setAuthorizationDetails(authorizationDetailsNode);
                }
                catch (JsonProcessingException e) {
                    this.log.error(String.format("Failed to convert authorization_details %s", authzDetails.asJsonString()), (Throwable)e);
                }
            }
            if (tokenToIntrospect instanceof AccessToken) {
                AccessToken accessToken = (AccessToken)tokenToIntrospect;
                response.setTokenType(accessToken.getTokenType() != null ? accessToken.getTokenType().getName() : TokenType.BEARER.getName());
                if (StringUtils.isNotBlank((CharSequence)accessToken.getDpop())) {
                    response.setNotBefore(Long.valueOf(accessToken.getCreationDate().getTime()));
                    HashMap<String, String> cnf = new HashMap<String, String>();
                    cnf.put("jkt", accessToken.getDpop());
                    response.setCnf(cnf);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to find grant for access_token: {}. Return 200 with active=false.", (Object)Util.escapeLog((Object)token));
        }
        return tokenToIntrospect;
    }

    private JSONObject createResponseAsJsonObject(IntrospectionResponse response, AuthorizationGrant grantOfIntrospectionToken) throws JSONException, IOException {
        JSONObject result = new JSONObject(ServerUtil.asJson(response));
        if (this.log.isTraceEnabled()) {
            this.log.trace("grantOfIntrospectionToken: {}, x5ts256: {}", (Object)(grantOfIntrospectionToken != null ? 1 : 0), (Object)(grantOfIntrospectionToken != null ? grantOfIntrospectionToken.getX5ts256() : ""));
        }
        if (grantOfIntrospectionToken != null && StringUtils.isNotBlank((CharSequence)grantOfIntrospectionToken.getX5ts256())) {
            JSONObject cnf = result.optJSONObject("cnf");
            if (cnf == null) {
                cnf = new JSONObject();
                result.put("cnf", (Object)cnf);
            }
            cnf.put("x5t#S256", (Object)grantOfIntrospectionToken.getX5ts256());
        }
        return result;
    }

    private Pair<AuthorizationGrant, Boolean> getAuthorizationGrant(String authorization, String accessToken) throws UnsupportedEncodingException {
        AuthorizationGrant grant = this.tokenService.getBearerAuthorizationGrant(authorization);
        if (grant != null) {
            String authorizationAccessToken = this.tokenService.getBearerToken(authorization);
            AbstractToken accessTokenObject = grant.getAccessToken(authorizationAccessToken);
            if (accessTokenObject != null && accessTokenObject.isValid()) {
                return new Pair((Object)grant, (Object)false);
            }
            this.log.error("Access token is not valid: {}", (Object)authorizationAccessToken);
            return EMPTY;
        }
        grant = this.tokenService.getBasicAuthorizationGrant(authorization);
        if (grant != null) {
            return new Pair((Object)grant, (Object)false);
        }
        if (this.tokenService.isBasicAuthToken(authorization)) {
            return this.isBasicTokenValid(authorization, accessToken);
        }
        return EMPTY;
    }

    private Pair<AuthorizationGrant, Boolean> isBasicTokenValid(String authorization, String accessToken) throws UnsupportedEncodingException {
        String password;
        String encodedCredentials = this.tokenService.getBasicToken(authorization);
        String token = new String(Base64.decodeBase64((String)encodedCredentials), StandardCharsets.UTF_8);
        int delim = token.indexOf(":");
        if (delim == -1) {
            return EMPTY;
        }
        String clientId = URLDecoder.decode(token.substring(0, delim), "UTF-8");
        if (this.clientService.authenticate(clientId, password = URLDecoder.decode(token.substring(delim + 1), "UTF-8"))) {
            AuthorizationGrant grant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getIntrospectionRestrictBasicAuthnToOwnTokens()) && grant != null && !grant.getClientId().equals(clientId)) {
                this.log.trace("Failed to match grant object clientId and client id provided during authentication.");
                return EMPTY;
            }
            return new Pair((Object)grant, (Object)true);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Failed to perform basic authentication for client: {}", (Object)clientId);
        }
        return EMPTY;
    }
}

