/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.authorize;

import io.jans.as.model.util.Util;
import io.jans.as.server.model.authorize.Claim;
import io.jans.as.server.model.authorize.ClaimValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IdTokenMember {
    private final List<Claim> claims = new ArrayList<Claim>();
    private Integer maxAge;

    public IdTokenMember(JSONObject jsonObject) throws JSONException {
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String claimName = (String)iterator.next();
            ClaimValue claimValue = null;
            if (claimName != null && claimName.equals("max_age") && jsonObject.has("max_age")) {
                this.maxAge = jsonObject.getInt("max_age");
            } else if (jsonObject.isNull(claimName)) {
                claimValue = ClaimValue.createNull();
            } else {
                JSONObject claimValueJsonObject = jsonObject.getJSONObject(claimName);
                if (claimValueJsonObject.has("values")) {
                    JSONArray claimValueJsonArray = claimValueJsonObject.getJSONArray("values");
                    List claimValueArr = Util.asList((JSONArray)claimValueJsonArray);
                    claimValue = ClaimValue.createValueList(claimValueArr);
                } else if (claimValueJsonObject.has("value")) {
                    String value = claimValueJsonObject.getString("value");
                    claimValue = ClaimValue.createSingleValue(value);
                }
                if (claimValueJsonObject.has("essential")) {
                    boolean essential = claimValueJsonObject.getBoolean("essential");
                    if (claimValue != null) {
                        claimValue.setEssential(essential);
                    } else {
                        claimValue = ClaimValue.createEssential(essential);
                    }
                }
            }
            Claim claim = new Claim(claimName, claimValue);
            this.claims.add(claim);
        }
    }

    public List<Claim> getClaims() {
        return this.claims;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public Claim getClaim(String claimName) {
        if (StringUtils.isNotBlank((CharSequence)claimName)) {
            for (Claim claim : this.claims) {
                if (!claimName.equals(claim.getName())) continue;
                return claim;
            }
        }
        return null;
    }
}

