/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.authorize;

import com.google.common.collect.Lists;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.common.Display;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwe.JweDecrypterImpl;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtHeader;
import io.jans.as.model.util.Base64Util;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.model.util.URLPatternList;
import io.jans.as.model.util.Util;
import io.jans.as.server.model.authorize.IdTokenMember;
import io.jans.as.server.model.authorize.UserInfoMember;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.RedirectUriResponse;
import io.jans.as.server.service.RedirectionUriService;
import io.jans.service.cdi.util.CdiUtil;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthorizationRequest {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthorizationRequest.class);
    private static final int SIXTY_MINUTES_AS_SECONDS = 3600;
    private String type;
    private String algorithm;
    private String encryptionAlgorithm;
    private String keyId;
    private final List<ResponseType> responseTypes;
    private String clientId;
    private final List<String> scopes;
    private String redirectUri;
    private String nonce;
    private String state;
    private List<String> aud;
    private Display display;
    private final List<Prompt> prompts;
    private UserInfoMember userInfoMember;
    private IdTokenMember idTokenMember;
    private Integer exp;
    private String iss;
    private Integer iat;
    private Integer nbf;
    private String jti;
    private String clientNotificationToken;
    private String acrValues;
    private String loginHintToken;
    private String idTokenHint;
    private String loginHint;
    private String bindingMessage;
    private String userCode;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String dpopJkt;
    private Integer requestedExpiry;
    private ResponseMode responseMode;
    private final String encodedJwt;
    private String payload;
    private JSONObject jsonPayload;
    private Jwt nestedJwt;
    private final AppConfiguration appConfiguration;

    public JwtAuthorizationRequest(AppConfiguration appConfiguration, AbstractCryptoProvider cryptoProvider, String encodedJwt, Client client) throws InvalidJwtException {
        block14: {
            this.aud = Lists.newArrayList();
            try {
                this.appConfiguration = appConfiguration;
                this.responseTypes = new ArrayList<ResponseType>();
                this.scopes = new ArrayList<String>();
                this.prompts = new ArrayList<Prompt>();
                this.encodedJwt = encodedJwt;
                if (StringUtils.isEmpty((CharSequence)encodedJwt)) {
                    throw new InvalidJwtException("The JWT is null or empty");
                }
                String[] parts = encodedJwt.split("\\.");
                if (appConfiguration.getRequireRequestObjectEncryption().booleanValue() && parts.length != 5) {
                    throw new InvalidJwtException("Request object is not encrypted.");
                }
                if (parts.length == 5) {
                    String encodedHeader = parts[0];
                    JwtHeader jwtHeader = new JwtHeader(encodedHeader);
                    this.keyId = jwtHeader.getKeyId();
                    KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("alg"));
                    BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("enc"));
                    JweDecrypterImpl jweDecrypter = null;
                    if (AlgorithmFamily.RSA.equals((Object)keyEncryptionAlgorithm.getFamily())) {
                        PrivateKey privateKey = cryptoProvider.getPrivateKey(this.keyId);
                        if (privateKey == null && StringUtils.isNotBlank((CharSequence)appConfiguration.getStaticDecryptionKid())) {
                            privateKey = cryptoProvider.getPrivateKey(appConfiguration.getStaticDecryptionKid());
                        }
                        jweDecrypter = new JweDecrypterImpl(privateKey);
                    } else {
                        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
                        jweDecrypter = new JweDecrypterImpl(clientService.decryptSecret(client.getClientSecret()).getBytes(StandardCharsets.UTF_8));
                    }
                    jweDecrypter.setFapi(appConfiguration.getFapiCompatibility().booleanValue());
                    jweDecrypter.setKeyEncryptionAlgorithm(keyEncryptionAlgorithm);
                    jweDecrypter.setBlockEncryptionAlgorithm(blockEncryptionAlgorithm);
                    Jwe jwe = jweDecrypter.decrypt(encodedJwt);
                    this.nestedJwt = jwe.getSignedJWTPayload();
                    if (this.nestedJwt != null) {
                        this.keyId = this.nestedJwt.getHeader().getKeyId();
                        if (!this.validateSignature(cryptoProvider, this.nestedJwt.getHeader().getSignatureAlgorithm(), client, this.nestedJwt.getSigningInput(), this.nestedJwt.getEncodedSignature())) {
                            throw new InvalidJwtException("The Nested JWT signature is not valid");
                        }
                    }
                    this.loadHeader(jwe.getHeader().toJsonString());
                    this.loadPayload(jwe.getClaims().toJsonString());
                    break block14;
                }
                if (parts.length == 2 || parts.length == 3) {
                    String encodedHeader = parts[0];
                    String encodedClaim = parts[1];
                    String encodedSignature = "";
                    if (parts.length == 3) {
                        encodedSignature = parts[2];
                    }
                    String signingInput = encodedHeader + "." + encodedClaim;
                    String header = new String(Base64Util.base64urldecode((String)encodedHeader), StandardCharsets.UTF_8);
                    String payloadString = new String(Base64Util.base64urldecode((String)encodedClaim), StandardCharsets.UTF_8);
                    payloadString = payloadString.replace("\\", "");
                    this.loadHeader(header);
                    SignatureAlgorithm sigAlg = SignatureAlgorithm.fromString((String)this.algorithm);
                    if (sigAlg == null) {
                        throw new InvalidJwtException("The JWT algorithm is not supported");
                    }
                    if (!this.validateSignature(cryptoProvider, sigAlg, client, signingInput, encodedSignature)) {
                        throw new InvalidJwtException("The JWT signature is not valid");
                    }
                    this.loadPayload(payloadString);
                    break block14;
                }
                throw new InvalidJwtException("The JWT is not well formed");
            }
            catch (Exception e) {
                throw new InvalidJwtException((Throwable)e);
            }
        }
    }

    public String getEncodedJwt() {
        return this.encodedJwt;
    }

    private void loadHeader(String header) throws JSONException {
        JSONObject jsonHeader = new JSONObject(header);
        if (jsonHeader.has("typ")) {
            this.type = jsonHeader.getString("typ");
        }
        if (jsonHeader.has("alg")) {
            this.algorithm = jsonHeader.getString("alg");
        }
        if (jsonHeader.has("enc")) {
            this.encryptionAlgorithm = jsonHeader.getString("enc");
        }
        if (jsonHeader.has("kid")) {
            this.keyId = jsonHeader.getString("kid");
        }
    }

    private void loadPayload(String payload) throws JSONException, UnsupportedEncodingException {
        int i;
        this.payload = payload;
        this.jsonPayload = new JSONObject(payload);
        if (this.jsonPayload.has("response_type")) {
            JSONArray responseTypeJsonArray = this.jsonPayload.optJSONArray("response_type");
            if (responseTypeJsonArray != null) {
                for (i = 0; i < responseTypeJsonArray.length(); ++i) {
                    ResponseType responseType = ResponseType.fromString((String)responseTypeJsonArray.getString(i));
                    this.responseTypes.add(responseType);
                }
            } else {
                this.responseTypes.addAll(ResponseType.fromString((String)this.jsonPayload.getString("response_type"), (String)" "));
            }
        }
        if (this.jsonPayload.has("exp")) {
            this.exp = this.jsonPayload.getInt("exp");
        }
        if (this.jsonPayload.has("aud")) {
            JSONArray audArray;
            String audStr = this.jsonPayload.optString("aud");
            if (StringUtils.isNotBlank((CharSequence)audStr)) {
                this.aud.add(audStr);
            }
            if ((audArray = this.jsonPayload.optJSONArray("aud")) != null && audArray.length() > 0) {
                this.aud.addAll(Util.asList((JSONArray)audArray));
            }
        }
        this.clientId = this.jsonPayload.optString("client_id", null);
        if (this.jsonPayload.has("scope")) {
            JSONArray scopesJsonArray = this.jsonPayload.optJSONArray("scope");
            if (scopesJsonArray != null) {
                for (i = 0; i < scopesJsonArray.length(); ++i) {
                    String scope = scopesJsonArray.getString(i);
                    this.scopes.add(scope);
                }
            } else {
                String scopeStringList = this.jsonPayload.getString("scope");
                this.scopes.addAll(Util.splittedStringAsList((String)scopeStringList, (String)" "));
            }
        }
        if (this.jsonPayload.has("redirect_uri")) {
            this.redirectUri = URLDecoder.decode(this.jsonPayload.getString("redirect_uri"), "UTF-8");
        }
        this.nonce = this.jsonPayload.optString("nonce", null);
        this.state = this.jsonPayload.optString("state", null);
        if (this.jsonPayload.has("display")) {
            this.display = Display.fromString((String)this.jsonPayload.getString("display"));
        }
        if (this.jsonPayload.has("prompt")) {
            JSONArray promptJsonArray = this.jsonPayload.optJSONArray("prompt");
            if (promptJsonArray != null) {
                for (int i2 = 0; i2 < promptJsonArray.length(); ++i2) {
                    Prompt prompt = Prompt.fromString((String)promptJsonArray.getString(i2));
                    this.prompts.add(prompt);
                }
            } else {
                this.prompts.addAll(Prompt.fromString((String)this.jsonPayload.getString("prompt"), (String)" "));
            }
        }
        if (this.jsonPayload.has("claims")) {
            JSONObject claimsJsonObject = this.jsonPayload.getJSONObject("claims");
            if (claimsJsonObject.has("userinfo")) {
                this.userInfoMember = new UserInfoMember(claimsJsonObject.getJSONObject("userinfo"));
            }
            if (claimsJsonObject.has("id_token")) {
                this.idTokenMember = new IdTokenMember(claimsJsonObject.getJSONObject("id_token"));
            }
        }
        this.iss = this.jsonPayload.optString("iss", null);
        if (this.jsonPayload.has("exp")) {
            this.exp = this.jsonPayload.getInt("exp");
        }
        if (this.jsonPayload.has("iat")) {
            this.iat = this.jsonPayload.getInt("iat");
        }
        if (this.jsonPayload.has("nbf")) {
            this.nbf = this.jsonPayload.getInt("nbf");
        }
        this.jti = this.jsonPayload.optString("jti", null);
        this.clientNotificationToken = this.jsonPayload.optString("client_notification_token", null);
        this.acrValues = this.jsonPayload.optString("acr_values", null);
        this.loginHintToken = this.jsonPayload.optString("login_hint_token", null);
        this.idTokenHint = this.jsonPayload.optString("id_token_hint", null);
        this.loginHint = this.jsonPayload.optString("login_hint", null);
        this.bindingMessage = this.jsonPayload.optString("binding_message", null);
        this.userCode = this.jsonPayload.optString("user_code", null);
        this.codeChallenge = this.jsonPayload.optString("code_challenge", null);
        this.codeChallengeMethod = this.jsonPayload.optString("code_challenge_method", null);
        this.dpopJkt = this.jsonPayload.optString("dpop_jkt", null);
        if (this.jsonPayload.has("requested_expiry")) {
            this.requestedExpiry = this.jsonPayload.get("requested_expiry") instanceof Number ? Integer.valueOf(this.jsonPayload.getInt("requested_expiry")) : Integer.valueOf(Integer.parseInt(this.jsonPayload.getString("requested_expiry")));
        }
        if (this.jsonPayload.has("response_mode")) {
            this.responseMode = ResponseMode.getByValue((String)this.jsonPayload.optString("response_mode"));
        }
    }

    private boolean validateSignature(@NotNull AbstractCryptoProvider cryptoProvider, SignatureAlgorithm signatureAlgorithm, Client client, String signingInput, String signature) throws Exception {
        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
        String sharedSecret = clientService.decryptSecret(client.getClientSecret());
        JSONObject jwks = CommonUtils.getJwks((Client)client);
        return cryptoProvider.verifySignature(signingInput, signature, this.keyId, jwks, sharedSecret, signatureAlgorithm);
    }

    public JSONObject getJsonPayload() {
        return this.jsonPayload;
    }

    public Jwt getNestedJwt() {
        return this.nestedJwt;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getType() {
        return this.type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getState() {
        return this.state;
    }

    public Display getDisplay() {
        return this.display;
    }

    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public UserInfoMember getUserInfoMember() {
        return this.userInfoMember;
    }

    public IdTokenMember getIdTokenMember() {
        return this.idTokenMember;
    }

    public Integer getExp() {
        return this.exp;
    }

    public List<String> getAud() {
        if (this.aud == null) {
            this.aud = Lists.newArrayList();
        }
        return this.aud;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getIss() {
        return this.iss;
    }

    public Integer getIat() {
        return this.iat;
    }

    public Integer getNbf() {
        return this.nbf;
    }

    public String getJti() {
        return this.jti;
    }

    public String getClientNotificationToken() {
        return this.clientNotificationToken;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public String getLoginHintToken() {
        return this.loginHintToken;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public Integer getRequestedExpiry() {
        return this.requestedExpiry;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public String getDpopJkt() {
        return this.dpopJkt;
    }

    public void setDpopJkt(String dpopJkt) {
        this.dpopJkt = dpopJkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String queryRequest(@Nullable String requestUri, @Nullable RedirectUriResponse redirectUriResponse, AppConfiguration appConfiguration) {
        if (StringUtils.isBlank((CharSequence)requestUri)) {
            return null;
        }
        boolean validRequestUri = false;
        try {
            URI reqUri = new URI(requestUri);
            String reqUriHash = reqUri.getFragment();
            String reqUriWithoutFragment = reqUri.getScheme() + ":" + reqUri.getSchemeSpecificPart();
            String request = null;
            try (jakarta.ws.rs.client.Client clientRequest = ClientBuilder.newClient();){
                Response clientResponse = clientRequest.target(reqUriWithoutFragment).request().buildGet().invoke();
                int status = clientResponse.getStatus();
                if (status == 200) {
                    request = (String)clientResponse.readEntity(String.class);
                    if (StringUtils.isBlank((CharSequence)reqUriHash) || !appConfiguration.getRequestUriHashVerificationEnabled().booleanValue()) {
                        validRequestUri = true;
                    } else {
                        String hash = Base64Util.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)request));
                        validRequestUri = StringUtils.equals((CharSequence)reqUriHash, (CharSequence)hash);
                    }
                }
            }
            if (!validRequestUri && redirectUriResponse != null) {
                throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_URI, "Invalid request uri.");
            }
            return request;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static JwtAuthorizationRequest createJwtRequest(String request, String requestUri, Client client, RedirectUriResponse redirectUriResponse, AbstractCryptoProvider cryptoProvider, AppConfiguration appConfiguration) {
        JwtAuthorizationRequest.validateRequestUri(requestUri, client, appConfiguration, redirectUriResponse != null ? redirectUriResponse.getState() : null);
        String requestFromClient = JwtAuthorizationRequest.queryRequest(requestUri, redirectUriResponse, appConfiguration);
        if (StringUtils.isNotBlank((CharSequence)requestFromClient)) {
            request = requestFromClient;
        }
        if (StringUtils.isBlank((CharSequence)request)) {
            return null;
        }
        try {
            return new JwtAuthorizationRequest(appConfiguration, cryptoProvider, request, client);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Invalid JWT authorization request. " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void validate() throws InvalidJwtException {
        if (this.appConfiguration.isFapi()) {
            this.validateFapi();
        }
    }

    private void validateFapi() throws InvalidJwtException {
        if (SignatureAlgorithm.fromString((String)this.algorithm) == SignatureAlgorithm.RS256) {
            throw new InvalidJwtException("RS256 algorithm is not allowed for FAPI");
        }
        if (SignatureAlgorithm.fromString((String)this.algorithm) == SignatureAlgorithm.NONE && this.appConfiguration.isFapi()) {
            throw new InvalidJwtException("None algorithm is not allowed for FAPI");
        }
        JwtAuthorizationRequest.validateNbf(this.nbf);
        JwtAuthorizationRequest.validateExp(this.exp);
    }

    public static void validateExp(Integer exp) throws InvalidJwtException {
        if (exp == null) {
            log.error("The exp claim is not set");
            throw new InvalidJwtException("exp claim is not set");
        }
        long nowSecondsExp = System.currentTimeMillis() / 1000L;
        long expDiff = (long)exp.intValue() - nowSecondsExp;
        if (expDiff > 3600L) {
            log.error("exp claim is more then 60 minutes in the future, exp: {}, nowSecondsExp: {}", (Object)exp, (Object)nowSecondsExp);
            throw new InvalidJwtException("exp claim is more then 60 in the future");
        }
    }

    public static void validateNbf(Integer nbf) throws InvalidJwtException {
        if (nbf == null || nbf <= 0) {
            log.error("nbf claim is not set, nbf: {}", (Object)nbf);
            throw new InvalidJwtException("nbf claim is not set");
        }
        long nowSeconds = System.currentTimeMillis() / 1000L;
        long nbfDiff = nowSeconds - (long)nbf.intValue();
        if (nbfDiff > 3600L) {
            log.error("nbf claim is more then 60 Minutes in the past, nbf: {}, nowSeconds: {}", (Object)nbf, (Object)nowSeconds);
            throw new InvalidJwtException("nbf claim is more then 60 in the past");
        }
    }

    public static void validateRequestUri(String requestUri, Client client, AppConfiguration appConfiguration, String state) {
        JwtAuthorizationRequest.validateRequestUri(requestUri, client, appConfiguration, state, (ErrorResponseFactory)CdiUtil.bean(ErrorResponseFactory.class));
    }

    public static void validateRequestUri(String requestUri, Client client, AppConfiguration appConfiguration, String state, ErrorResponseFactory errorResponseFactory) {
        URLPatternList urlPatternList;
        if (StringUtils.isBlank((CharSequence)requestUri)) {
            return;
        }
        if (ArrayUtils.isNotEmpty((Object[])client.getRequestUris()) && !RedirectionUriService.isUriEqual(requestUri, client.getRequestUris())) {
            log.debug("request_uri is forbidden by client request uris.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_URI, state, "")).build());
        }
        List blockList = appConfiguration.getRequestUriBlockList();
        if (!blockList.isEmpty() && (urlPatternList = new URLPatternList(blockList)).isUrlListed(requestUri)) {
            log.debug("request_uri is forbidden by requestUriBlackList configuration.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_URI, state, "")).build());
        }
    }
}

