/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.common;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.TokenType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.CertUtils;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.authorize.ScopeChecker;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationCode;
import io.jans.as.server.model.common.AuthorizationGrantType;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.IAuthorizationGrant;
import io.jans.as.server.model.common.IdToken;
import io.jans.as.server.model.common.LogoutStatusJwt;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.model.common.TxToken;
import io.jans.as.server.service.KeyGeneratorTimer;
import io.jans.as.server.service.external.ExternalUpdateTokenService;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.as.server.util.TokenHashUtil;
import io.jans.model.token.TokenEntity;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizationGrant
implements IAuthorizationGrant {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthorizationGrant.class);
    @Inject
    protected AppConfiguration appConfiguration;
    @Inject
    private ExternalUpdateTokenService externalUpdateTokenService;
    @Inject
    protected ScopeChecker scopeChecker;
    @Inject
    private KeyGeneratorTimer keyGeneratorTimer;
    private User user;
    private AuthorizationGrantType authorizationGrantType;
    private Client client;
    private Set<String> scopes;
    private AuthzDetails authzDetails;
    private String grantId;
    private JwtAuthorizationRequest jwtAuthorizationRequest;
    private Date authenticationTime;
    private TokenEntity tokenEntity;
    private AccessToken longLivedAccessToken;
    private IdToken idToken;
    private AuthorizationCode authorizationCode;
    private String tokenBindingHash;
    private String x5ts256;
    private String nonce;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String claims;
    private String dpopJkt;
    private String referenceId;
    private Integer statusListIndex;
    private String acrValues;
    private String sessionDn;
    private boolean isAuthorizationChallenge;
    protected final ConcurrentMap<String, TxToken> txTokens = new ConcurrentHashMap<String, TxToken>();
    protected final ConcurrentMap<String, AccessToken> accessTokens = new ConcurrentHashMap<String, AccessToken>();
    protected final ConcurrentMap<String, RefreshToken> refreshTokens = new ConcurrentHashMap<String, RefreshToken>();
    protected final ConcurrentMap<String, LogoutStatusJwt> logoutStatusJwts = new ConcurrentHashMap<String, LogoutStatusJwt>();

    protected AbstractAuthorizationGrant() {
    }

    protected AbstractAuthorizationGrant(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        this.init(user, authorizationGrantType, client, authenticationTime);
    }

    protected void init(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        this.authenticationTime = authenticationTime != null ? new Date(authenticationTime.getTime()) : null;
        this.user = user;
        this.authorizationGrantType = authorizationGrantType;
        this.client = client;
        this.scopes = new CopyOnWriteArraySet<String>();
        this.grantId = UUID.randomUUID().toString();
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public boolean isAuthorizationChallenge() {
        return this.isAuthorizationChallenge;
    }

    public AbstractAuthorizationGrant setAuthorizationChallenge(boolean authorizationChallenge) {
        this.isAuthorizationChallenge = authorizationChallenge;
        return this;
    }

    public Integer getStatusListIndex() {
        return this.statusListIndex;
    }

    public void setStatusListIndex(Integer statusListIndex) {
        this.statusListIndex = statusListIndex;
    }

    public String getDpopJkt() {
        return this.dpopJkt;
    }

    public void setDpopJkt(String dpopJkt) {
        this.dpopJkt = dpopJkt;
    }

    @Override
    public synchronized String getGrantId() {
        return this.grantId;
    }

    @Override
    public synchronized void setGrantId(String grantId) {
        this.grantId = grantId;
    }

    @Override
    public AuthorizationCode getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Override
    public void setAuthorizationCode(AuthorizationCode authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public String getTokenBindingHash() {
        return this.tokenBindingHash;
    }

    public void setTokenBindingHash(String tokenBindingHash) {
        this.tokenBindingHash = tokenBindingHash;
    }

    public String getX5ts256() {
        return this.x5ts256;
    }

    public void setX5ts256(String x5ts256) {
        this.x5ts256 = x5ts256;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    @Override
    public Set<String> getRefreshTokensCodes() {
        return this.refreshTokens.keySet();
    }

    @Override
    public Set<String> getLogoutStatusJwtsCodes() {
        return this.logoutStatusJwts.keySet();
    }

    @Override
    public Set<String> getAccessTokensCodes() {
        return this.accessTokens.keySet();
    }

    @Override
    public List<AccessToken> getAccessTokens() {
        return new ArrayList<AccessToken>(this.accessTokens.values());
    }

    public List<TxToken> getTxTokens() {
        return new ArrayList<TxToken>(this.txTokens.values());
    }

    public TxToken getTxToken(String txTokenCode) {
        return (TxToken)this.txTokens.get(txTokenCode);
    }

    @Override
    public void setScopes(Collection<String> scopes) {
        this.scopes.clear();
        this.scopes.addAll(scopes);
    }

    @Override
    public AccessToken getLongLivedAccessToken() {
        return this.longLivedAccessToken;
    }

    @Override
    public void setLongLivedAccessToken(AccessToken longLivedAccessToken) {
        this.longLivedAccessToken = longLivedAccessToken;
    }

    @Override
    public IdToken getIdToken() {
        return this.idToken;
    }

    @Override
    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    @Override
    public TokenEntity getTokenEntity() {
        return this.tokenEntity;
    }

    @Override
    public void setTokenEntity(TokenEntity tokenEntity) {
        this.tokenEntity = tokenEntity;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getAcrValues() {
        return this.acrValues;
    }

    @Override
    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    @Override
    public String getSessionDn() {
        return this.sessionDn;
    }

    @Override
    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    @Override
    public String checkScopesPolicy(String requestedScopes) {
        this.scopes.clear();
        Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(this.client, requestedScopes);
        this.scopes.addAll(grantedScopes);
        StringBuilder grantedScopesSb = new StringBuilder();
        for (String scope : this.scopes) {
            grantedScopesSb.append(" ").append(scope);
        }
        return grantedScopesSb.toString().trim();
    }

    public int getAccessTokenLifetimeInSeconds(ExecutionContext executionContext) {
        int lifetimeFromScript;
        int timePassedInSeconds;
        int intervalInSeconds;
        int recalculcatedLifetime;
        int lifetime = this.appConfiguration.getAccessTokenLifetime();
        if (this.client != null && this.client.getAccessTokenLifetime() != null && this.client.getAccessTokenLifetime() > 0) {
            lifetime = this.client.getAccessTokenLifetime();
        }
        if (this.client != null && this.client.isAccessTokenAsJwt() && BooleanUtils.isTrue((Boolean)this.appConfiguration.getKeyRegenerationEnabled()) && (recalculcatedLifetime = (intervalInSeconds = this.appConfiguration.getKeyRegenerationInterval() * 3600) - (timePassedInSeconds = (int)((System.currentTimeMillis() - this.keyGeneratorTimer.getLastFinishedTime()) / 1000L))) > 0 && recalculcatedLifetime < lifetime) {
            log.trace("Override access token lifetime based on key lifetime: {}", (Object)recalculcatedLifetime);
            lifetime = recalculcatedLifetime;
        }
        if ((lifetimeFromScript = this.externalUpdateTokenService.getAccessTokenLifetimeInSeconds(ExternalUpdateTokenContext.of(executionContext))) > 0) {
            lifetime = lifetimeFromScript;
            log.trace("Override access token lifetime with value from script: {}", (Object)lifetimeFromScript);
        }
        return lifetime;
    }

    @Override
    public AccessToken createAccessToken(ExecutionContext executionContext) {
        AccessToken accessToken = new AccessToken(this.getAccessTokenLifetimeInSeconds(executionContext));
        accessToken.setSessionDn(this.getSessionDn());
        accessToken.setX5ts256(CertUtils.confirmationMethodHashS256((String)executionContext.getCertAsPem()));
        accessToken.setReferenceId(executionContext.getTokenReferenceId());
        String dpop = executionContext.getDpop();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dpop})) {
            accessToken.setDpop(dpop);
            accessToken.setTokenType(TokenType.DPOP);
        }
        return accessToken;
    }

    @Override
    public RefreshToken createRefreshToken(ExecutionContext context) {
        context.generateRandomTokenReferenceId();
        int lifetime = this.appConfiguration.getRefreshTokenLifetime();
        if (this.client.getRefreshTokenLifetime() != null && this.client.getRefreshTokenLifetime() > 0) {
            lifetime = this.client.getRefreshTokenLifetime();
        }
        RefreshToken refreshToken = new RefreshToken(lifetime);
        refreshToken.setSessionDn(this.getSessionDn());
        refreshToken.setDpop(context.getDpop());
        refreshToken.setReferenceId(context.getTokenReferenceId());
        return refreshToken;
    }

    @Override
    public RefreshToken createRefreshToken(ExecutionContext context, int lifetime) {
        context.generateRandomTokenReferenceId();
        RefreshToken refreshToken = new RefreshToken(lifetime);
        refreshToken.setSessionDn(this.getSessionDn());
        refreshToken.setDpop(context.getDpop());
        refreshToken.setReferenceId(context.getTokenReferenceId());
        return refreshToken;
    }

    @Override
    public String getUserId() {
        if (this.user == null) {
            return null;
        }
        return this.user.getUserId();
    }

    @Override
    public String getUserDn() {
        if (this.user == null) {
            return null;
        }
        return this.user.getDn();
    }

    @Override
    public AuthorizationGrantType getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public String getClientId() {
        if (this.client == null) {
            return null;
        }
        return this.client.getClientId();
    }

    @Override
    public String getClientDn() {
        if (this.client == null) {
            return null;
        }
        return this.client.getDn();
    }

    @Override
    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    @Override
    public Set<String> getScopes() {
        return this.scopes;
    }

    public String getAuthzDetailsAsString() {
        return this.authzDetails != null ? this.authzDetails.asJsonArray().toString() : null;
    }

    public AuthzDetails getAuthzDetails() {
        return this.authzDetails;
    }

    public void setAuthzDetails(AuthzDetails authzDetails) {
        this.authzDetails = authzDetails;
    }

    @Override
    public JwtAuthorizationRequest getJwtAuthorizationRequest() {
        return this.jwtAuthorizationRequest;
    }

    @Override
    public void setJwtAuthorizationRequest(JwtAuthorizationRequest jwtAuthorizationRequest) {
        this.jwtAuthorizationRequest = jwtAuthorizationRequest;
    }

    @Override
    public void setAccessTokens(List<AccessToken> accessTokens) {
        AbstractAuthorizationGrant.put(this.accessTokens, accessTokens);
    }

    @Override
    public void setTxTokens(List<TxToken> txTokens) {
        AbstractAuthorizationGrant.put(this.txTokens, txTokens);
    }

    private static <T extends AbstractToken> void put(ConcurrentMap<String, T> map, List<T> list) {
        map.clear();
        if (list != null && !list.isEmpty()) {
            for (AbstractToken t : list) {
                map.put(t.getCode(), t);
            }
        }
    }

    @Override
    public List<LogoutStatusJwt> getLogoutStatusJwts() {
        return new ArrayList<LogoutStatusJwt>(this.logoutStatusJwts.values());
    }

    @Override
    public void setLogoutStatusJwts(List<LogoutStatusJwt> tokens) {
        AbstractAuthorizationGrant.put(this.logoutStatusJwts, tokens);
    }

    @Override
    public LogoutStatusJwt getLogoutStatusJwt(String logoutStatusJwtCode) {
        if (log.isTraceEnabled()) {
            log.trace("Looking for the logout status jwt: {} for an authorization grant of type: {}", (Object)logoutStatusJwtCode, (Object)this.getAuthorizationGrantType());
        }
        return (LogoutStatusJwt)this.logoutStatusJwts.get(TokenHashUtil.hash(logoutStatusJwtCode));
    }

    @Override
    public List<RefreshToken> getRefreshTokens() {
        return new ArrayList<RefreshToken>(this.refreshTokens.values());
    }

    @Override
    public void setRefreshTokens(List<RefreshToken> refreshTokens) {
        AbstractAuthorizationGrant.put(this.refreshTokens, refreshTokens);
    }

    @Override
    public RefreshToken getRefreshToken(String refreshTokenCode) {
        if (log.isTraceEnabled()) {
            log.trace("Looking for the refresh token: {} for an authorization grant of type: {}", (Object)refreshTokenCode, (Object)this.getAuthorizationGrantType());
        }
        return (RefreshToken)this.refreshTokens.get(TokenHashUtil.hash(refreshTokenCode));
    }

    @Override
    public AbstractToken getAccessToken(String tokenCode) {
        String hashedTokenCode = TokenHashUtil.hash(tokenCode);
        if (this.idToken != null && this.idToken.getCode().equals(hashedTokenCode)) {
            return this.idToken;
        }
        if (this.longLivedAccessToken != null && this.longLivedAccessToken.getCode().equals(hashedTokenCode)) {
            return this.longLivedAccessToken;
        }
        TxToken txToken = (TxToken)this.txTokens.get(hashedTokenCode);
        if (txToken != null) {
            return txToken;
        }
        return (AbstractToken)this.accessTokens.get(hashedTokenCode);
    }

    public String toString() {
        return "AbstractAuthorizationGrant{user=" + this.user + ", authorizationCode=" + this.authorizationCode + ", client=" + this.client + ", grantId='" + this.grantId + "', nonce='" + this.nonce + "', acrValues='" + this.acrValues + "', sessionDn='" + this.sessionDn + "', codeChallenge='" + this.codeChallenge + "', codeChallengeMethod='" + this.codeChallengeMethod + "', authenticationTime=" + this.authenticationTime + ", scopes=" + this.scopes + ", authorizationGrantType=" + this.authorizationGrantType + ", tokenBindingHash=" + this.tokenBindingHash + ", x5ts256=" + this.x5ts256 + ", claims=" + this.claims + ", authzDetails=" + this.authzDetails + "}";
    }
}

