/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.common;

import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.util.HashUtil;
import io.jans.as.server.model.token.HandleTokenFactory;
import io.jans.as.server.util.ServerUtil;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.Expiration;
import io.jans.orm.model.base.Deletable;
import java.io.Serializable;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public abstract class AbstractToken
implements Serializable,
Deletable {
    @AttributeName(name="tknCde", consistency=true)
    private String code;
    @AttributeName(name="iat")
    private Date creationDate;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private boolean deletable = true;
    private boolean revoked;
    private boolean expired;
    @AttributeName(name="ssnId")
    private String sessionDn;
    private String x5ts256;
    @AttributeName(name="dpop")
    private String dpop;
    @AttributeName(name="jansId")
    private String referenceId;
    @AttributeName(name="jti")
    private String jti;
    private Integer statusListIndex;
    @Expiration
    private int ttl;

    protected AbstractToken(int lifeTime) {
        if (lifeTime <= 0) {
            throw new IllegalArgumentException("Lifetime of the token is less or equal to zero.");
        }
        this.ttl = lifeTime;
        Calendar calendar = Calendar.getInstance();
        this.creationDate = calendar.getTime();
        calendar.add(13, lifeTime);
        this.expirationDate = calendar.getTime();
        this.code = HandleTokenFactory.generateHandleToken();
        this.revoked = false;
        this.expired = false;
    }

    protected AbstractToken(String code, Date creationDate, Date expirationDate) {
        this.code = code;
        this.creationDate = creationDate;
        this.expirationDate = expirationDate;
        this.checkExpired();
    }

    public int getTtl() {
        this.initTtl();
        return this.ttl;
    }

    private void initTtl() {
        if (this.ttl > 0) {
            return;
        }
        this.ttl = ServerUtil.calculateTtl(this.creationDate, this.expirationDate);
        if (this.ttl > 0) {
            return;
        }
        this.ttl = (int)TimeUnit.DAYS.toSeconds(1L);
    }

    public void resetTtlFromExpirationDate() {
        Long duration = Duration.between(new Date().toInstant(), this.getExpirationDate().toInstant()).getSeconds();
        Integer seconds = duration.intValue();
        if (seconds != null) {
            this.ttl = seconds;
        }
    }

    public void checkExpired() {
        this.checkExpired(new Date());
    }

    public void checkExpired(Date now) {
        if (now.after(this.expirationDate)) {
            this.expired = true;
        }
    }

    public boolean isValid() {
        return !this.revoked && !this.expired;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getCreationDate() {
        return this.creationDate != null ? new Date(this.creationDate.getTime()) : null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
    }

    public Date getExpirationDate() {
        return this.expirationDate != null ? new Date(this.expirationDate.getTime()) : null;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate != null ? new Date(expirationDate.getTime()) : null;
    }

    public synchronized boolean isRevoked() {
        return this.revoked;
    }

    public synchronized void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getJti() {
        return this.jti;
    }

    public AbstractToken setJti(String jti) {
        this.jti = jti;
        return this;
    }

    public Integer getStatusListIndex() {
        return this.statusListIndex;
    }

    public void setStatusListIndex(Integer statusListIndex) {
        this.statusListIndex = statusListIndex;
    }

    public synchronized boolean isExpired() {
        return this.expired;
    }

    public synchronized void setExpired(boolean expired) {
        this.expired = expired;
    }

    public String getX5ts256() {
        return this.x5ts256;
    }

    public void setX5ts256(String x5ts256) {
        this.x5ts256 = x5ts256;
    }

    public String getDpop() {
        return this.dpop;
    }

    public void setDpop(String dpop) {
        this.dpop = dpop;
    }

    public String getSessionDn() {
        return this.sessionDn;
    }

    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    public Boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public int getExpiresIn() {
        int expiresIn = 0;
        this.checkExpired();
        if (this.isValid()) {
            Date start = this.creationDate != null ? this.creationDate : new Date();
            long diff = this.expirationDate.getTime() - start.getTime();
            expiresIn = diff != 0L ? (int)(diff / 1000L) : 0;
        }
        return expiresIn;
    }

    public static String getHash(String input, SignatureAlgorithm signatureAlgorithm) {
        return HashUtil.getHash((String)input, (SignatureAlgorithm)signatureAlgorithm);
    }
}

