/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.token;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.token.ClientAssertionType;
import io.jans.as.server.service.ClientService;
import io.jans.service.cdi.util.CdiUtil;
import io.jans.util.Pair;
import io.jans.util.security.StringEncrypter;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class ClientAssertion {
    private final AppConfiguration appConfiguration;
    private final AbstractCryptoProvider cryptoProvider;
    private final String clientId;
    private final ClientAssertionType clientAssertionType;
    private final String encodedAssertion;
    private boolean verified;
    private Jwt jwt;
    private String clientSecret;

    public ClientAssertion(AppConfiguration appConfiguration, AbstractCryptoProvider cryptoProvider, String clientId, ClientAssertionType clientAssertionType, String encodedAssertion) {
        this.appConfiguration = appConfiguration;
        this.cryptoProvider = cryptoProvider;
        this.clientId = clientId;
        this.clientAssertionType = clientAssertionType;
        this.encodedAssertion = encodedAssertion;
        this.verified = false;
    }

    public String getSubjectIdentifier() throws InvalidJwtException {
        this.assertVerified();
        return this.jwt.getClaims().getClaimAsString("sub");
    }

    public String getJti() throws InvalidJwtException {
        this.assertVerified();
        return this.jwt.getClaims().getClaimAsString("jti");
    }

    public String getClientSecret() throws InvalidJwtException {
        this.assertVerified();
        return this.clientSecret;
    }

    public void assertVerified() throws InvalidJwtException {
        if (!this.verified) {
            throw new InvalidJwtException("Client Assertion is not verified");
        }
    }

    public void verifyClientAssertionType() throws InvalidJwtException {
        if (this.clientAssertionType != ClientAssertionType.JWT_BEARER) {
            throw new InvalidJwtException("Invalid Client Assertion Type");
        }
    }

    public void initAndVerify() throws InvalidJwtException {
        try {
            this.initAndVerifyInternally();
            this.verified = true;
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJwtException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJwtException("Cannot verify the JWT", (Throwable)e);
        }
    }

    public void verifyEncodedAssertion() throws InvalidJwtException {
        if (StringUtils.isBlank((CharSequence)this.encodedAssertion)) {
            throw new InvalidJwtException("The Client Assertion is null or empty");
        }
    }

    public void verifyAudience(List<String> audience) throws InvalidJwtException {
        if (audience == null || audience.isEmpty()) {
            throw new InvalidJwtException("Audience is null or blank.");
        }
        if (this.appConfiguration.getAllowClientAssertionAudWithoutStrictIssuerMatch().booleanValue()) {
            return;
        }
        String serverIssuer = this.appConfiguration.getIssuer();
        if (audience.stream().anyMatch(aud -> aud.equals(serverIssuer) || aud.startsWith(serverIssuer))) {
            return;
        }
        throw new InvalidJwtException("Invalid Audience. It must contain server issuer or server. Aud: " + audience);
    }

    public void verifyExpiration(Date expirationTime) throws InvalidJwtException {
        if (expirationTime != null && expirationTime.after(new Date())) {
            return;
        }
        throw new InvalidJwtException("JWT has expired");
    }

    public Pair<Client, ClientService> verifyClient(String subject) throws InvalidJwtException {
        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
        Client client = clientService.getClient(subject);
        if (client != null) {
            return new Pair((Object)client, (Object)clientService);
        }
        throw new InvalidJwtException("Invalid client");
    }

    public void verifyAuthenticationMethod(Client client) throws InvalidJwtException {
        JwtType jwtType = JwtType.fromString((String)this.jwt.getHeader().getClaimAsString("typ"));
        Set authenticationMethods = client.getAllAuthenticationMethods();
        SignatureAlgorithm signatureAlgorithm = this.jwt.getHeader().getSignatureAlgorithm();
        if (jwtType == null && signatureAlgorithm != null) {
            jwtType = signatureAlgorithm.getJwtType();
        }
        if (jwtType != null && signatureAlgorithm != null && signatureAlgorithm.getFamily() != null && (authenticationMethods.contains(AuthenticationMethod.CLIENT_SECRET_JWT) && AlgorithmFamily.HMAC.equals((Object)signatureAlgorithm.getFamily()) || authenticationMethods.contains(AuthenticationMethod.PRIVATE_KEY_JWT) && (AlgorithmFamily.RSA.equals((Object)signatureAlgorithm.getFamily()) || AlgorithmFamily.EC.equals((Object)signatureAlgorithm.getFamily())))) {
            return;
        }
        throw new InvalidJwtException("Invalid authentication method");
    }

    private void initAndVerifyInternally() throws InvalidJwtException, StringEncrypter.EncryptionException, CryptoProviderException {
        boolean clientEqualsToSubjectAndToIssuer;
        this.verifyClientAssertionType();
        this.verifyEncodedAssertion();
        this.jwt = Jwt.parse((String)this.encodedAssertion);
        String issuer = this.jwt.getClaims().getClaimAsString("iss");
        String subject = this.jwt.getClaims().getClaimAsString("sub");
        List audience = this.jwt.getClaims().getClaimAsStringList("aud");
        Date expirationTime = this.jwt.getClaims().getClaimAsDate("exp");
        boolean issuerEqualsToSubject = StringUtils.isNotBlank((CharSequence)issuer) && StringUtils.isNotBlank((CharSequence)subject) && issuer.equals(subject);
        boolean noClientAndIssuerEqualsToSubject = this.clientId == null && issuerEqualsToSubject;
        boolean bl = clientEqualsToSubjectAndToIssuer = StringUtils.isNotBlank((CharSequence)this.clientId) && this.clientId.equals(issuer) && issuerEqualsToSubject;
        if (!noClientAndIssuerEqualsToSubject && !clientEqualsToSubjectAndToIssuer) {
            throw new InvalidJwtException("Invalid clientId");
        }
        this.verifyAudience(audience);
        this.verifyExpiration(expirationTime);
        Pair<Client, ClientService> verifiedClientPair = this.verifyClient(subject);
        Client client = (Client)verifiedClientPair.getFirst();
        this.verifyAuthenticationMethod(client);
        this.verifySignatureAlgorithm(client);
        this.verifySignature((ClientService)verifiedClientPair.getSecond(), (Client)verifiedClientPair.getFirst());
    }

    public void verifySignature(ClientService clientService, Client client) throws StringEncrypter.EncryptionException, InvalidJwtException, CryptoProviderException {
        SignatureAlgorithm signatureAlgorithm = this.jwt.getHeader().getSignatureAlgorithm();
        this.clientSecret = clientService.decryptSecret(client.getClientSecret());
        String keyId = this.jwt.getHeader().getKeyId();
        JSONObject jwks = CommonUtils.getJwks((Client)client);
        boolean validSignature = this.cryptoProvider.verifySignature(this.jwt.getSigningInput(), this.jwt.getEncodedSignature(), keyId, jwks, this.clientSecret, signatureAlgorithm);
        if (!validSignature) {
            throw new InvalidJwtException("Invalid cryptographic segment");
        }
    }

    public void verifySignatureAlgorithm(Client client) throws InvalidJwtException {
        SignatureAlgorithm signatureAlgorithm = this.jwt.getHeader().getSignatureAlgorithm();
        if (client.getTokenEndpointAuthSigningAlg() == null || SignatureAlgorithm.fromString((String)client.getTokenEndpointAuthSigningAlg()).equals((Object)signatureAlgorithm)) {
            return;
        }
        throw new InvalidJwtException("Invalid signing algorithm");
    }
}

