/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.par.ws.rs;

import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.persistence.model.Par;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.orm.PersistenceEntryManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ParService {
    @Inject
    private Logger log;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    public static String toPersistenceId(String id) {
        return StringUtils.replace((String)id, (String)"urn:ietf:params:oauth:request_uri:", (String)"par:");
    }

    public static String toOutsideId(String id) {
        return StringUtils.replace((String)id, (String)"par:", (String)"urn:ietf:params:oauth:request_uri:");
    }

    public void persist(Par par) {
        this.setIdAndDnIfNeeded(par);
        this.entryManager.persist((Object)par);
    }

    public Par getPar(String id) {
        return this.getParByDn(this.dn(id));
    }

    public Par getParByDn(String dn) {
        try {
            return (Par)this.entryManager.find(Par.class, (Object)dn);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void setIdAndDnIfNeeded(Par par) {
        if (StringUtils.isBlank((CharSequence)par.getId())) {
            par.setId("par:" + UUID.randomUUID().toString());
        }
        if (StringUtils.isBlank((CharSequence)par.getDn())) {
            par.setDn(this.dn(par.getId()));
        }
    }

    public String dn(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("PAR id is null or blank.");
        }
        return String.format("jansId=%s,%s", ParService.toPersistenceId(id), this.branchBaseDn());
    }

    public String branchBaseDn() {
        return this.staticConfiguration.getBaseDn().getPar();
    }

    public Par getParAndValidateForAuthorizationRequest(String id, String state, String clientIdInRequest) {
        Par par = this.getPar(id);
        if (par == null) {
            this.log.debug("Failed to find PAR by request_uri (id): {}", (Object)id);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "Failed to find par by request_uri")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (StringUtils.isBlank((CharSequence)clientIdInRequest) || !clientIdInRequest.equals(par.getAttributes().getClientId())) {
            this.log.debug("client_id does not match to PAR's client_id (used during PAR registration). Reject request. PAR clientId: {}, request's clientId: {}", (Object)par.getAttributes().getClientId(), (Object)clientIdInRequest);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "client_id does not match to PAR's client_id")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        this.validate(par, state);
        return par;
    }

    private void validate(Par par, String state) {
        Date now = new Date();
        if (par.isExpired(now)) {
            this.log.debug("PAR is expired, id: {}, exp: {}, now: {}", new Object[]{par.getId(), par.getExpirationDate(), now});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_URI, state, "PAR is expired")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        try {
            JwtAuthorizationRequest.validateExp((int)(par.getExpirationDate().getTime() / 1000L));
            JwtAuthorizationRequest.validateNbf(par.getAttributes().getNbf());
        }
        catch (InvalidJwtException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "Failed to validate exp or nbf")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

