/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.json.JsonApplier;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.register.RegisterResponseParam;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.ciba.CIBARegisterClientResponseService;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ScopeService;
import io.jans.model.JansAttribute;
import io.jans.orm.annotation.AttributeEnum;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.model.base.LocalizedString;
import io.jans.util.security.StringEncrypter;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@Named
public class RegisterJsonService {
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private CIBARegisterClientResponseService cibaRegisterClientResponseService;

    public String jsonObjectToString(JSONObject jsonObject) throws JSONException {
        return jsonObject.toString(4).replace("\\/", "/");
    }

    public JSONObject getJSONObject(Client client) throws JSONException, StringEncrypter.EncryptionException {
        JSONObject responseJsonObject = new JSONObject();
        JsonApplier.getInstance().apply((Object)client, responseJsonObject);
        JsonApplier.getInstance().apply((Object)client.getAttributes(), responseJsonObject);
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.CLIENT_ID.toString(), (Object)client.getClientId());
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getReturnClientSecretOnRead())) {
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.CLIENT_SECRET.toString(), (Object)this.clientService.decryptSecret(client.getClientSecret()));
        }
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString(), (Object)client.getRegistrationAccessToken());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.REGISTRATION_CLIENT_URI.toString(), (Object)(this.appConfiguration.getRegistrationEndpoint() + "?" + RegisterResponseParam.CLIENT_ID.toString() + "=" + client.getClientId()));
        responseJsonObject.put(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString(), client.getClientIdIssuedAt().getTime() / 1000L);
        responseJsonObject.put(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString(), client.getClientSecretExpiresAt() != null && client.getClientSecretExpiresAt().getTime() > 0L ? client.getClientSecretExpiresAt().getTime() / 1000L : 0L);
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLIENT_NAME.toString(), (Object)client.getClientName());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.LOGO_URI.toString(), (Object)client.getLogoUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLIENT_URI.toString(), (Object)client.getClientUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.POLICY_URI.toString(), (Object)client.getPolicyUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOS_URI.toString(), (Object)client.getTosUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ORG_ID.toString(), (Object)client.getOrganization());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLIENT_NAME.toString(), (LocalizedString)client.getClientNameLocalized());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.LOGO_URI.toString(), (LocalizedString)client.getLogoUriLocalized());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLIENT_URI.toString(), (LocalizedString)client.getClientUriLocalized());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.POLICY_URI.toString(), (LocalizedString)client.getPolicyUriLocalized());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOS_URI.toString(), (LocalizedString)client.getTosUriLocalized());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REDIRECT_URIS.toString(), (String[])client.getRedirectUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString(), (String[])client.getClaimRedirectUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.RESPONSE_TYPES.toString(), (String[])ResponseType.toStringArray((ResponseType[])client.getResponseTypes()));
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.GRANT_TYPES.toString(), (String[])GrantType.toStringArray((GrantType[])client.getGrantTypes()));
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.APPLICATION_TYPE.toString(), (AttributeEnum)client.getApplicationType());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CONTACTS.toString(), (String[])client.getContacts());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.AUTHORIZATION_DETAILS_TYPES.toString(), (Object)client.getAttributes().getAuthorizationDetailsTypes());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.JWKS_URI.toString(), (Object)client.getJwksUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)client.getSectorIdentifierUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SUBJECT_TYPE.toString(), (AttributeEnum)client.getSubjectType());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.AUTHORIZATION_SIGNED_RESPONSE_ALG.toString(), (Object)client.getAttributes().getAuthorizationSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.AUTHORIZATION_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getAttributes().getAuthorizationEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.AUTHORIZATION_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getAttributes().getAuthorizationEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)client.getIdTokenSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getIdTokenEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getIdTokenEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)client.getUserInfoSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getUserInfoEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getUserInfoEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.INTROSPECTION_SIGNED_RESPONSE_ALG.toString(), (Object)client.getAttributes().getIntrospectionSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.INTROSPECTION_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getAttributes().getIntrospectionEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.INTROSPECTION_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getAttributes().getIntrospectionEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TX_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)client.getAttributes().getTxTokenSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TX_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getAttributes().getTxTokenEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TX_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getAttributes().getTxTokenEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.LOGOUT_STATUS_JWT_SIGNED_RESPONSE_ALG.toString(), (Object)client.getAttributes().getLogoutStatusJwtSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)client.getRequestObjectSigningAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString(), (Object)client.getRequestObjectEncryptionAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString(), (Object)client.getRequestObjectEncryptionEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)client.getTokenEndpointAuthMethod());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ADDITIONAL_TOKEN_ENDPOINT_AUTH_METHODS.toString(), (String[])client.getAttributes().getAdditionalTokenEndpointAuthMethods().toArray(new String[0]));
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString(), (Object)client.getTokenEndpointAuthSigningAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)client.getDefaultMaxAge());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), (String[])client.getDefaultAcrValues());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)client.getInitiateLoginUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), (String[])client.getPostLogoutRedirectUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.GROUPS.toString(), (String[])client.getGroups());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_URIS.toString(), (String[])client.getRequestUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.AUTHORIZED_ORIGINS.toString(), (String[])client.getAuthorizedOrigins());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.RPT_AS_JWT.toString(), (Object)client.isRptAsJwt());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TLS_CLIENT_AUTH_SUBJECT_DN.toString(), (Object)client.getAttributes().getTlsClientAuthSubjectDn());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ALLOW_SPONTANEOUS_SCOPES.toString(), (Object)client.getAttributes().getAllowSpontaneousScopes());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SPONTANEOUS_SCOPES.toString(), (Object)client.getAttributes().getSpontaneousScopes());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.RUN_INTROSPECTION_SCRIPT_BEFORE_JWT_CREATION.toString(), (Object)client.getAttributes().getRunIntrospectionScriptBeforeJwtCreation());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.KEEP_CLIENT_AUTHORIZATION_AFTER_EXPIRATION.toString(), (Object)client.getAttributes().getKeepClientAuthorizationAfterExpiration());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUIRE_PKCE.toString(), (Object)client.getAttributes().getRequirePkce());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ACCESS_TOKEN_AS_JWT.toString(), (Object)client.isAccessTokenAsJwt());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ACCESS_TOKEN_SIGNING_ALG.toString(), (Object)client.getAccessTokenSigningAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ACCESS_TOKEN_LIFETIME.toString(), (Object)client.getAccessTokenLifetime());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_LIFETIME.toString(), (Object)client.getAttributes().getIdTokenLifetime());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TX_TOKEN_LIFETIME.toString(), (Object)client.getAttributes().getTxTokenLifetime());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.PAR_LIFETIME.toString(), (Object)client.getAttributes().getParLifetime());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUIRE_PAR.toString(), (Object)client.getAttributes().getRequirePar());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SOFTWARE_ID.toString(), (Object)client.getSoftwareId());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SOFTWARE_VERSION.toString(), (Object)client.getSoftwareVersion());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SOFTWARE_STATEMENT.toString(), (Object)client.getSoftwareStatement());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.PUBLIC_SUBJECT_IDENTIFIER_ATTRIBUTE.getName(), (Object)client.getAttributes().getPublicSubjectIdentifierAttribute());
        if (!Util.isNullOrEmpty((String)client.getJwks())) {
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.JWKS.toString(), (Object)new JSONObject(client.getJwks()));
        }
        List backchannelLogoutUris = client.getAttributes().getBackchannelLogoutUri();
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString(), (Object)client.getFrontChannelLogoutUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString(), (Object)client.getFrontChannelLogoutSessionRequired());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.BACKCHANNEL_LOGOUT_URI.toString(), CollectionUtils.isNotEmpty((Collection)backchannelLogoutUris) ? backchannelLogoutUris.iterator().next() : null);
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.BACKCHANNEL_LOGOUT_SESSION_REQUIRED.toString(), (Object)client.getAttributes().getBackchannelLogoutSessionRequired());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REDIRECT_URIS_REGEX.toString(), (Object)client.getAttributes().getRedirectUrisRegex());
        String[] scopeNames = null;
        String[] scopeDns = client.getScopes();
        if (scopeDns != null) {
            scopeNames = new String[scopeDns.length];
            for (int i = 0; i < scopeDns.length; ++i) {
                Scope scope = this.scopeService.getScopeByDn(scopeDns[i]);
                scopeNames[i] = scope.getId();
            }
        }
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SCOPE.toString(), (Object)StringUtils.implode((String[])scopeNames, (String)" "));
        String[] claimNames = null;
        String[] claimDns = client.getClaims();
        if (claimDns != null) {
            claimNames = new String[claimDns.length];
            for (int i = 0; i < claimDns.length; ++i) {
                JansAttribute jansAttribute = this.attributeService.getAttributeByDn(claimDns[i]);
                claimNames[i] = jansAttribute.getClaimName();
            }
        }
        this.putCustomAttributesInResponse(client, responseJsonObject);
        if (claimNames != null && claimNames.length > 0) {
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLAIMS.toString(), (Object)StringUtils.implode((String[])claimNames, (String)" "));
        }
        this.cibaRegisterClientResponseService.updateResponse(responseJsonObject, client);
        return responseJsonObject;
    }

    private void putCustomAttributesInResponse(Client client, JSONObject responseJsonObject) {
        List allowedCustomAttributeNames = this.appConfiguration.getDynamicRegistrationCustomAttributes();
        List customAttributes = client.getCustomAttributes();
        if (allowedCustomAttributeNames == null || allowedCustomAttributeNames.isEmpty() || customAttributes == null) {
            return;
        }
        for (CustomObjectAttribute attribute : customAttributes) {
            if (!allowedCustomAttributeNames.contains(attribute.getName())) continue;
            if (attribute.isMultiValued()) {
                Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)attribute.getName(), (Object)attribute.getValues());
                continue;
            }
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)attribute.getName(), (Object)attribute.getValue());
        }
    }
}

