/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import io.jans.as.client.RegisterRequest;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.json.JsonApplier;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.register.ApplicationType;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.util.StringUtils;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.ciba.CIBARegisterClientMetadataService;
import io.jans.as.server.service.ScopeService;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.util.StringHelper;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class RegisterService {
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Logger log;
    @Inject
    private ScopeService scopeService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AttributeService attributeService;
    @Inject
    private CIBARegisterClientMetadataService cibaRegisterClientMetadataService;

    public String clientScopesToString(Client client) {
        String[] scopeDns = client.getScopes();
        if (scopeDns != null) {
            Object[] scopeNames = new String[scopeDns.length];
            for (int i = 0; i < scopeDns.length; ++i) {
                Scope scope = this.scopeService.getScopeByDn(scopeDns[i]);
                scopeNames[i] = scope.getId();
            }
            return org.apache.commons.lang3.StringUtils.join((Object[])scopeNames, (String)" ");
        }
        return null;
    }

    public Set<ResponseType> identifyResponseTypes(Collection<ResponseType> requestResponseTypes, Collection<GrantType> requestGrantTypes) {
        HashSet<ResponseType> result = new HashSet<ResponseType>(requestResponseTypes);
        if (result.isEmpty()) {
            result.add(ResponseType.CODE);
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getGrantTypesAndResponseTypesAutofixEnabled())) {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getClientRegDefaultToCodeFlowWithRefresh())) {
                if (result.isEmpty()) {
                    result.add(ResponseType.CODE);
                }
                if (requestGrantTypes.contains(GrantType.AUTHORIZATION_CODE)) {
                    result.add(ResponseType.CODE);
                }
            }
            if (requestGrantTypes.contains(GrantType.IMPLICIT)) {
                result.add(ResponseType.TOKEN);
            }
        }
        result.retainAll(this.appConfiguration.getAllResponseTypesSupported());
        return result;
    }

    public Set<GrantType> identifyGrantTypes(Collection<ResponseType> identifiedResponseTypes, Collection<GrantType> requestGrantTypes) {
        HashSet<GrantType> result = new HashSet<GrantType>(requestGrantTypes);
        if (result.isEmpty()) {
            result.add(GrantType.AUTHORIZATION_CODE);
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getGrantTypesAndResponseTypesAutofixEnabled())) {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getClientRegDefaultToCodeFlowWithRefresh())) {
                if (identifiedResponseTypes.contains(ResponseType.CODE)) {
                    result.add(GrantType.AUTHORIZATION_CODE);
                    result.add(GrantType.REFRESH_TOKEN);
                }
                if (result.contains(GrantType.AUTHORIZATION_CODE)) {
                    identifiedResponseTypes.add(ResponseType.CODE);
                    result.add(GrantType.REFRESH_TOKEN);
                }
            }
            if (identifiedResponseTypes.contains(ResponseType.TOKEN) || identifiedResponseTypes.contains(ResponseType.ID_TOKEN)) {
                result.add(GrantType.IMPLICIT);
            }
            if (result.contains(GrantType.IMPLICIT)) {
                identifiedResponseTypes.add(ResponseType.TOKEN);
            }
        }
        result.retainAll(this.appConfiguration.getGrantTypesSupported());
        result.retainAll(this.appConfiguration.getGrantTypesSupportedByDynamicRegistration());
        return result;
    }

    private void assignResponseTypesAndGrantTypes(Client client, RegisterRequest requestObject, boolean update) {
        boolean isNewClient;
        Set<ResponseType> identifiedResponseTypes = this.identifyResponseTypes(requestObject.getResponseTypes(), requestObject.getGrantTypes());
        Set<GrantType> identifiedGrantTypes = this.identifyGrantTypes(identifiedResponseTypes, requestObject.getGrantTypes());
        boolean bl = isNewClient = !update;
        if (isNewClient || !requestObject.getResponseTypes().isEmpty()) {
            client.setResponseTypes(identifiedResponseTypes.toArray(new ResponseType[0]));
        }
        if (isNewClient || BooleanUtils.isTrue((Boolean)this.appConfiguration.getEnableClientGrantTypeUpdate()) && !requestObject.getGrantTypes().isEmpty()) {
            client.setGrantTypes(identifiedGrantTypes.toArray(new GrantType[0]));
        }
        this.log.trace("Updating client with responseTypes: {}, grantTypes: {}, isNewClient: {}", new Object[]{identifiedResponseTypes, identifiedGrantTypes, isNewClient});
    }

    public static String[] listAsArrayWithoutDuplicates(List<String> list) {
        ArrayList<String> result = new ArrayList<String>(new HashSet<String>(list));
        return result.toArray(new String[0]);
    }

    public void updateClientFromRequestObject(Client client, RegisterRequest requestObject, boolean update) throws JSONException {
        ArrayList authorizedAcrValues;
        List authorizedOrigins;
        List postLogoutRedirectUris;
        List groups;
        List minimumAcrPriorityList;
        Boolean minimumAcrLevelAutoresolve;
        Integer minimumAcrLevel;
        List defaultAcrValues;
        List authorizationDetailsTypes;
        List claimsRedirectUris;
        JsonApplier.getInstance().transfer((Object)requestObject, (Object)client);
        JsonApplier.getInstance().transfer((Object)requestObject, (Object)client.getAttributes());
        List redirectUris = requestObject.getRedirectUris();
        if (redirectUris != null && !redirectUris.isEmpty()) {
            client.setRedirectUris(RegisterService.listAsArrayWithoutDuplicates(redirectUris));
        }
        if ((claimsRedirectUris = requestObject.getClaimsRedirectUris()) != null && !claimsRedirectUris.isEmpty()) {
            client.setClaimRedirectUris(RegisterService.listAsArrayWithoutDuplicates(claimsRedirectUris));
        }
        client.setApplicationType(requestObject.getApplicationType() != null ? requestObject.getApplicationType() : ApplicationType.WEB);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getSectorIdentifierUri())) {
            client.setSectorIdentifierUri(requestObject.getSectorIdentifierUri());
        }
        this.assignResponseTypesAndGrantTypes(client, requestObject, update);
        List contacts = requestObject.getContacts();
        if (contacts != null && !contacts.isEmpty()) {
            client.setContacts(RegisterService.listAsArrayWithoutDuplicates(contacts));
        }
        if ((authorizationDetailsTypes = requestObject.getAuthorizationDetailsTypes()) != null && !authorizationDetailsTypes.isEmpty()) {
            client.getAttributes().setAuthorizationDetailsTypes(authorizationDetailsTypes);
        }
        for (String key : requestObject.getClientNameLanguageTags()) {
            client.setClientNameLocalized(requestObject.getClientName(key), Locale.forLanguageTag(key));
        }
        for (String key : requestObject.getLogoUriLanguageTags()) {
            client.setLogoUriLocalized(requestObject.getLogoUri(key), Locale.forLanguageTag(key));
        }
        for (String key : requestObject.getClientUriLanguageTags()) {
            client.setClientUriLocalized(requestObject.getClientUri(key), Locale.forLanguageTag(key));
        }
        for (String key : requestObject.getPolicyUriLanguageTags()) {
            client.setPolicyUriLocalized(requestObject.getPolicyUri(key), Locale.forLanguageTag(key));
        }
        for (String key : requestObject.getTosUriLanguageTags()) {
            client.setTosUriLocalized(requestObject.getTosUri(key), Locale.forLanguageTag(key));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getJwksUri())) {
            client.setJwksUri(requestObject.getJwksUri());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getJwks())) {
            client.setJwks(requestObject.getJwks());
        }
        if (requestObject.getSubjectType() != null) {
            client.setSubjectType(requestObject.getSubjectType());
        }
        if (requestObject.getRptAsJwt() != null) {
            client.setRptAsJwt(requestObject.getRptAsJwt().booleanValue());
        }
        if (requestObject.getAccessTokenAsJwt() != null) {
            client.setAccessTokenAsJwt(requestObject.getAccessTokenAsJwt().booleanValue());
        }
        if (requestObject.getRequirePkce() != null) {
            client.getAttributes().setRequirePkce(requestObject.getRequirePkce());
        }
        if (requestObject.getTlsClientAuthSubjectDn() != null) {
            client.getAttributes().setTlsClientAuthSubjectDn(requestObject.getTlsClientAuthSubjectDn());
        }
        if (requestObject.getRedirectUrisRegex() != null) {
            client.getAttributes().setRedirectUrisRegex(requestObject.getRedirectUrisRegex());
        }
        if (requestObject.getAllowSpontaneousScopes() != null) {
            client.getAttributes().setAllowSpontaneousScopes(requestObject.getAllowSpontaneousScopes());
        }
        if (requestObject.getSpontaneousScopes() != null) {
            client.getAttributes().setSpontaneousScopes(requestObject.getSpontaneousScopes());
        }
        if (requestObject.getAdditionalAudience() != null) {
            client.getAttributes().setAdditionalAudience(requestObject.getAdditionalAudience());
        }
        if (requestObject.getSpontaneousScopeScriptDns() != null) {
            client.getAttributes().setSpontaneousScopeScriptDns(requestObject.getSpontaneousScopeScriptDns());
        }
        if (requestObject.getUpdateTokenScriptDns() != null) {
            client.getAttributes().setUpdateTokenScriptDns(requestObject.getUpdateTokenScriptDns());
        }
        if (requestObject.getLogoutStatusJwtScriptDns() != null) {
            client.getAttributes().setLogoutStatusJwtScriptDns(requestObject.getLogoutStatusJwtScriptDns());
        }
        if (requestObject.getPostAuthnScriptDns() != null) {
            client.getAttributes().setPostAuthnScripts(requestObject.getPostAuthnScriptDns());
        }
        if (requestObject.getTokenExchangeScriptDns() != null) {
            client.getAttributes().setTokenExchangeScripts(requestObject.getTokenExchangeScriptDns());
        }
        if (requestObject.getConsentGatheringScriptDns() != null) {
            client.getAttributes().setConsentGatheringScripts(requestObject.getConsentGatheringScriptDns());
        }
        if (requestObject.getIntrospectionScriptDns() != null) {
            client.getAttributes().setIntrospectionScripts(requestObject.getIntrospectionScriptDns());
        }
        if (requestObject.getRptClaimsScriptDns() != null) {
            client.getAttributes().setRptClaimsScripts(requestObject.getRptClaimsScriptDns());
        }
        if (requestObject.getRopcScriptDns() != null) {
            client.getAttributes().setRopcScripts(requestObject.getRopcScriptDns());
        }
        if (requestObject.getRunIntrospectionScriptBeforeJwtCreation() != null) {
            client.getAttributes().setRunIntrospectionScriptBeforeJwtCreation(requestObject.getRunIntrospectionScriptBeforeJwtCreation());
        }
        if (requestObject.getKeepClientAuthorizationAfterExpiration() != null) {
            client.getAttributes().setKeepClientAuthorizationAfterExpiration(requestObject.getKeepClientAuthorizationAfterExpiration());
        }
        if (requestObject.getAccessTokenSigningAlg() != null) {
            client.setAccessTokenSigningAlg(requestObject.getAccessTokenSigningAlg().toString());
        }
        if (requestObject.getAuthorizationSignedResponseAlg() != null) {
            client.getAttributes().setAuthorizationSignedResponseAlg(requestObject.getAuthorizationSignedResponseAlg().toString());
        }
        if (requestObject.getAuthorizationEncryptedResponseAlg() != null) {
            client.getAttributes().setAuthorizationEncryptedResponseAlg(requestObject.getAuthorizationEncryptedResponseAlg().toString());
        }
        if (requestObject.getAuthorizationEncryptedResponseEnc() != null) {
            client.getAttributes().setAuthorizationEncryptedResponseEnc(requestObject.getAuthorizationEncryptedResponseEnc().toString());
        }
        if (requestObject.getIdTokenSignedResponseAlg() != null) {
            client.setIdTokenSignedResponseAlg(requestObject.getIdTokenSignedResponseAlg().toString());
        }
        if (requestObject.getIdTokenEncryptedResponseAlg() != null) {
            client.setIdTokenEncryptedResponseAlg(requestObject.getIdTokenEncryptedResponseAlg().toString());
        }
        if (requestObject.getIdTokenEncryptedResponseEnc() != null) {
            client.setIdTokenEncryptedResponseEnc(requestObject.getIdTokenEncryptedResponseEnc().toString());
        }
        if (requestObject.getUserInfoSignedResponseAlg() != null) {
            client.setUserInfoSignedResponseAlg(requestObject.getUserInfoSignedResponseAlg().toString());
        }
        if (requestObject.getUserInfoEncryptedResponseAlg() != null) {
            client.setUserInfoEncryptedResponseAlg(requestObject.getUserInfoEncryptedResponseAlg().toString());
        }
        if (requestObject.getUserInfoEncryptedResponseEnc() != null) {
            client.setUserInfoEncryptedResponseEnc(requestObject.getUserInfoEncryptedResponseEnc().toString());
        }
        if (requestObject.getIntrospectionSignedResponseAlg() != null) {
            client.getAttributes().setIntrospectionSignedResponseAlg(requestObject.getIntrospectionSignedResponseAlg().toString());
        }
        if (requestObject.getIntrospectionEncryptedResponseAlg() != null) {
            client.getAttributes().setIntrospectionEncryptedResponseAlg(requestObject.getIntrospectionEncryptedResponseAlg().toString());
        }
        if (requestObject.getIntrospectionEncryptedResponseEnc() != null) {
            client.getAttributes().setIntrospectionEncryptedResponseEnc(requestObject.getIntrospectionEncryptedResponseEnc().toString());
        }
        if (requestObject.getTxTokenSignedResponseAlg() != null) {
            client.getAttributes().setTxTokenSignedResponseAlg(requestObject.getTxTokenSignedResponseAlg().toString());
        }
        if (requestObject.getTxTokenEncryptedResponseAlg() != null) {
            client.getAttributes().setTxTokenEncryptedResponseAlg(requestObject.getTxTokenEncryptedResponseAlg().toString());
        }
        if (requestObject.getTxTokenEncryptedResponseEnc() != null) {
            client.getAttributes().setTxTokenEncryptedResponseEnc(requestObject.getTxTokenEncryptedResponseEnc().toString());
        }
        if (requestObject.getLogoutStatusJwtSignedResponseAlg() != null) {
            client.getAttributes().setLogoutStatusJwtSignedResponseAlg(requestObject.getLogoutStatusJwtSignedResponseAlg().toString());
        }
        if (requestObject.getRequestObjectSigningAlg() != null) {
            client.setRequestObjectSigningAlg(requestObject.getRequestObjectSigningAlg().toString());
        }
        if (requestObject.getRequestObjectEncryptionAlg() != null) {
            client.setRequestObjectEncryptionAlg(requestObject.getRequestObjectEncryptionAlg().toString());
        }
        if (requestObject.getRequestObjectEncryptionEnc() != null) {
            client.setRequestObjectEncryptionEnc(requestObject.getRequestObjectEncryptionEnc().toString());
        }
        if (requestObject.getTokenEndpointAuthMethod() != null) {
            client.setTokenEndpointAuthMethod(requestObject.getTokenEndpointAuthMethod().toString());
        } else if (requestObject.getAdditionalTokenEndpointAuthMethods() != null && !requestObject.getAdditionalTokenEndpointAuthMethods().isEmpty()) {
            client.setTokenEndpointAuthMethod(((AuthenticationMethod)requestObject.getAdditionalTokenEndpointAuthMethods().iterator().next()).toString());
        } else {
            client.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        }
        if (requestObject.getAdditionalTokenEndpointAuthMethods() != null) {
            client.getAttributes().setAdditionalTokenEndpointAuthMethods(requestObject.getAdditionalTokenEndpointAuthMethods().stream().map(AuthenticationMethod::toString).collect(Collectors.toList()));
        }
        if (requestObject.getTokenEndpointAuthSigningAlg() != null) {
            client.setTokenEndpointAuthSigningAlg(requestObject.getTokenEndpointAuthSigningAlg().toString());
        }
        if (requestObject.getDefaultMaxAge() != null) {
            client.setDefaultMaxAge(requestObject.getDefaultMaxAge());
        }
        if (!update) {
            client.getAttributes().setRequestedLifetime(requestObject.getLifetime());
        }
        if ((defaultAcrValues = requestObject.getDefaultAcrValues()) != null && !defaultAcrValues.isEmpty()) {
            client.setDefaultAcrValues(RegisterService.listAsArrayWithoutDuplicates(defaultAcrValues));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getInitiateLoginUri())) {
            client.setInitiateLoginUri(requestObject.getInitiateLoginUri());
        }
        if ((minimumAcrLevel = requestObject.getMinimumAcrLevel()) != null) {
            client.getAttributes().setMinimumAcrLevel(minimumAcrLevel);
        }
        if ((minimumAcrLevelAutoresolve = requestObject.getMinimumAcrLevelAutoresolve()) != null) {
            client.getAttributes().setMinimumAcrLevelAutoresolve(minimumAcrLevelAutoresolve);
        }
        if ((minimumAcrPriorityList = requestObject.getMinimumAcrPriorityList()) != null) {
            client.getAttributes().setMinimumAcrPriorityList(new ArrayList(new HashSet(minimumAcrPriorityList)));
        }
        if ((groups = requestObject.getGroups()) != null && !groups.isEmpty()) {
            client.setGroups(RegisterService.listAsArrayWithoutDuplicates(groups));
        }
        if ((postLogoutRedirectUris = requestObject.getPostLogoutRedirectUris()) != null && !postLogoutRedirectUris.isEmpty()) {
            client.setPostLogoutRedirectUris(RegisterService.listAsArrayWithoutDuplicates(postLogoutRedirectUris));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getFrontChannelLogoutUri())) {
            client.setFrontChannelLogoutUri(requestObject.getFrontChannelLogoutUri());
        }
        client.setFrontChannelLogoutSessionRequired(requestObject.getFrontChannelLogoutSessionRequired());
        if (requestObject.getBackchannelLogoutUri() != null && !requestObject.getBackchannelLogoutUri().isEmpty()) {
            client.getAttributes().setBackchannelLogoutUri((List)Lists.newArrayList((Object[])new String[]{requestObject.getBackchannelLogoutUri()}));
        }
        client.getAttributes().setBackchannelLogoutSessionRequired(requestObject.getBackchannelLogoutSessionRequired());
        List requestUris = requestObject.getRequestUris();
        if (requestUris != null && !requestUris.isEmpty()) {
            client.setRequestUris(RegisterService.listAsArrayWithoutDuplicates(requestUris));
        }
        if ((authorizedOrigins = requestObject.getAuthorizedOrigins()) != null && !authorizedOrigins.isEmpty()) {
            client.setAuthorizedOrigins(RegisterService.listAsArrayWithoutDuplicates(authorizedOrigins));
        }
        this.assignScopes(client, requestObject);
        List claims = requestObject.getClaims();
        if (claims != null && !claims.isEmpty()) {
            List claimsDn = this.attributeService.getAttributesDn(claims);
            client.setClaims(claimsDn.toArray(new String[claimsDn.size()]));
        }
        if (requestObject.getJsonObject() != null) {
            String orgId = requestObject.getJsonObject().optString(RegisterRequestParam.ORG_ID.getName());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orgId)) {
                client.setOrganization(orgId);
            }
            this.putCustomStuffIntoObject(client, requestObject.getJsonObject());
        }
        if (requestObject.getAccessTokenLifetime() != null) {
            client.setAccessTokenLifetime(requestObject.getAccessTokenLifetime());
        }
        if (requestObject.getParLifetime() != null) {
            client.getAttributes().setParLifetime(requestObject.getParLifetime());
        }
        if (requestObject.getRequirePar() != null) {
            client.getAttributes().setRequirePar(requestObject.getRequirePar());
        }
        if (requestObject.getDpopBoundAccessToken() != null) {
            client.getAttributes().setDpopBoundAccessToken(requestObject.getDpopBoundAccessToken());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getSoftwareId())) {
            client.setSoftwareId(requestObject.getSoftwareId());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getSoftwareVersion())) {
            client.setSoftwareVersion(requestObject.getSoftwareVersion());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getSoftwareStatement())) {
            client.setSoftwareStatement(requestObject.getSoftwareStatement());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getEvidence())) {
            client.getAttributes().setEvidence(requestObject.getEvidence());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestObject.getSubjectIdentifierAttribute())) {
            client.getAttributes().setPublicSubjectIdentifierAttribute(requestObject.getSubjectIdentifierAttribute());
        }
        if (requestObject.getDefaultPromptLogin() != null) {
            client.getAttributes().setDefaultPromptLogin(requestObject.getDefaultPromptLogin());
        }
        if ((authorizedAcrValues = requestObject.getAuthorizedAcrValues()) != null && !authorizedAcrValues.isEmpty()) {
            authorizedAcrValues = new ArrayList(new HashSet(authorizedAcrValues));
            client.getAttributes().setAuthorizedAcrValues(authorizedAcrValues);
        }
        this.cibaRegisterClientMetadataService.updateClient(client, requestObject.getBackchannelTokenDeliveryMode(), requestObject.getBackchannelClientNotificationEndpoint(), requestObject.getBackchannelAuthenticationRequestSigningAlg(), requestObject.getBackchannelUserCodeParameter());
    }

    public void assignScopes(Client client, RegisterRequest requestObject) {
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getDynamicRegistrationScopesParamEnabled())) {
            this.log.debug("Skip scopes update. Reason - configuration dynamicRegistrationScopesParamEnabled=false");
            return;
        }
        List requestScopes = requestObject.getScope();
        if (requestScopes == null || requestScopes.isEmpty()) {
            this.log.trace("No scopes in request");
            return;
        }
        if (Arrays.asList(client.getGrantTypes()).contains(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) && !this.appConfiguration.getDynamicRegistrationAllowedPasswordGrantScopes().isEmpty()) {
            requestScopes = Lists.newArrayList((Iterable)requestScopes);
            requestScopes.retainAll(this.appConfiguration.getDynamicRegistrationAllowedPasswordGrantScopes());
        }
        List<String> defaultScopes = this.scopeService.getDefaultScopesDn();
        List<String> requestedScopes = this.scopeService.getScopesDn(requestScopes);
        HashSet<String> allowedScopes = new HashSet<String>();
        for (String requestedScope : requestedScopes) {
            if (!defaultScopes.contains(requestedScope)) continue;
            allowedScopes.add(requestedScope);
        }
        this.log.trace("Allowed scopes: {}, requested scopes: {}, default scopes: {}", new Object[]{allowedScopes, requestedScopes, defaultScopes});
        client.setScopes(allowedScopes.toArray(new String[0]));
    }

    private void putCustomStuffIntoObject(Client client, JSONObject requestObject) throws JSONException {
        List attrList;
        String customOC = this.appConfiguration.getDynamicRegistrationCustomObjectClass();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)customOC)) {
            client.setCustomObjectClasses(new String[]{customOC});
        }
        if ((attrList = this.appConfiguration.getDynamicRegistrationCustomAttributes()) == null || attrList.isEmpty()) {
            return;
        }
        this.addDefaultCustomAttributes(requestObject);
        for (String attr : attrList) {
            if (!requestObject.has(attr)) continue;
            this.addCustomAttribute(client, requestObject, attr);
        }
    }

    public void addDefaultCustomAttributes(JSONObject requestObject) {
        JsonNode node = this.appConfiguration.getDynamicRegistrationDefaultCustomAttributes();
        List allowed = this.appConfiguration.getDynamicRegistrationCustomAttributes();
        if (allowed == null || allowed.isEmpty() || node == null || node.isEmpty()) {
            return;
        }
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String key = (String)fieldNames.next();
            if (!allowed.contains(key)) continue;
            JsonNode value = node.get(key);
            if (value.isBoolean()) {
                requestObject.put(key, value.booleanValue());
                continue;
            }
            if (value.isTextual()) {
                requestObject.put(key, (Object)value.textValue());
                continue;
            }
            if (value.isNumber()) {
                requestObject.put(key, (Object)value.numberValue());
                continue;
            }
            if (!value.isDouble()) continue;
            requestObject.put(key, value.asDouble());
        }
    }

    private void addCustomAttribute(Client client, JSONObject requestObject, String attr) {
        List parameterValues;
        JSONArray parameterValuesJsonArray = requestObject.optJSONArray(attr);
        List list = parameterValues = parameterValuesJsonArray != null ? StringUtils.toList((JSONArray)parameterValuesJsonArray) : Lists.newArrayList((Object[])new String[]{requestObject.getString(attr)});
        if (!parameterValues.isEmpty()) {
            try {
                boolean processed = this.processApplicationAttributes(client, attr, parameterValues);
                if (!processed) {
                    CustomObjectAttribute customAttribute = new CustomObjectAttribute();
                    customAttribute.setName(attr);
                    customAttribute.setValues(new ArrayList(parameterValues));
                    client.getCustomAttributes().add(customAttribute);
                }
            }
            catch (Exception e) {
                this.log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean processApplicationAttributes(Client client, String attr, List<String> parameterValues) {
        if (StringHelper.equalsIgnoreCase((String)"jansTrustedClnt", (String)attr)) {
            boolean trustedClient = StringHelper.toBoolean((String)parameterValues.get(0), (boolean)false);
            client.setTrustedClient(trustedClient);
            return true;
        }
        if (StringHelper.equalsIgnoreCase((String)"jansInclClaimsInIdTkn", (String)attr)) {
            boolean includeClaimsInIdToken = StringHelper.toBoolean((String)parameterValues.get(0), (boolean)false);
            client.setIncludeClaimsInIdToken(includeClaimsInIdToken);
            return true;
        }
        return false;
    }

    public Response.ResponseBuilder createInternalErrorResponse(String reason) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, reason));
    }

    @NotNull
    public JSONObject parseRequestObjectWithoutValidation(String requestParams) throws JSONException {
        try {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDcrSignatureValidationEnabled())) {
                return Jwt.parseOrThrow((String)requestParams).getClaims().toJsonObject();
            }
            return new JSONObject(requestParams);
        }
        catch (InvalidJwtException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Invalid JWT, trying to parse it as plain unencoded json", (Throwable)e);
            }
            return new JSONObject(requestParams);
        }
        catch (Exception e) {
            String msg = "Unable to parse request object.";
            this.log.error("Unable to parse request object.", (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Unable to parse request object.");
        }
    }
}

