/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs.action;

import io.jans.as.client.RegisterRequest;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.ciba.CIBARegisterParamsValidatorService;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.registration.RegisterParamsValidator;
import io.jans.as.server.register.ws.rs.RegisterJsonService;
import io.jans.as.server.register.ws.rs.RegisterService;
import io.jans.as.server.register.ws.rs.RegisterValidator;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.external.ExternalDynamicClientRegistrationService;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.util.ServerUtil;
import io.jans.util.security.StringEncrypter;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.BooleanUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class RegisterUpdateAction {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private TokenService tokenService;
    @Inject
    private RegisterValidator registerValidator;
    @Inject
    private RegisterService registerService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private RegisterParamsValidator registerParamsValidator;
    @Inject
    private CIBARegisterParamsValidatorService cibaRegisterParamsValidatorService;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalDynamicClientRegistrationService externalDynamicClientRegistrationService;
    @Inject
    private RegisterJsonService registerJsonService;

    private String validateAccessToken(String authorization, String clientId) {
        String accessToken = this.tokenService.getToken(authorization);
        this.registerValidator.validateNotBlank(accessToken, "access token is blank");
        this.registerValidator.validateAuthorizationAccessToken(accessToken, clientId);
        return accessToken;
    }

    public Response updateClient(String requestParams, String clientId, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.REGISTRATION);
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.CLIENT_UPDATE);
        oAuth2AuditLog.setClientId(clientId);
        try {
            this.log.debug("Attempting to UPDATE client, client_id: {}, requestParams = {}, isSecure = {}", new Object[]{clientId, requestParams, securityContext.isSecure()});
            this.registerValidator.validateNotBlank(authorization, "Authorization header is blank");
            this.registerValidator.validateNotBlank(clientId, "clientId is blank");
            this.registerValidator.validateNotBlank(requestParams, "requestParams is blank");
            String accessToken = this.validateAccessToken(authorization, clientId);
            this.registerValidator.validateAuthorizationAccessToken(accessToken, clientId);
            JSONObject requestObject = this.registerService.parseRequestObjectWithoutValidation(requestParams);
            JSONObject softwareStatement = this.registerValidator.validateSoftwareStatement(httpRequest, requestObject);
            if (softwareStatement != null) {
                this.log.trace("Override request parameters by software_statement");
                for (String key : softwareStatement.keySet()) {
                    requestObject.putOpt(key, softwareStatement.get(key));
                }
            }
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDcrSignatureValidationEnabled())) {
                this.registerValidator.validateRequestObject(requestParams, softwareStatement, httpRequest);
            }
            RegisterRequest request = RegisterRequest.fromJson((String)requestParams);
            this.validateRedirectUris(request);
            this.validateCiba(request);
            this.validateSubjectType(request);
            Client client = this.clientService.getClient(clientId, accessToken);
            this.validateClientNotNull(client);
            this.registerService.updateClientFromRequestObject(client, request, true);
            boolean updateClient = true;
            if (this.externalDynamicClientRegistrationService.isEnabled()) {
                updateClient = this.externalDynamicClientRegistrationService.executeExternalUpdateClientMethods(httpRequest, request, client);
            }
            if (updateClient) {
                this.clientService.merge(client);
                JSONObject jsonObject = this.registerJsonService.getJSONObject(client);
                jsonObject = this.modifyPutScript(jsonObject, new ExecutionContext(httpRequest, null).setClient(client));
                Response response = Response.ok().entity((Object)this.registerJsonService.jsonObjectToString(jsonObject)).build();
                oAuth2AuditLog.setScope(this.registerService.clientScopesToString(client));
                oAuth2AuditLog.setSuccess(true);
                this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                return response;
            }
            this.clientService.removeFromCache(client);
            this.log.trace("The Access Token is not valid for the Client ID, returns invalid_token error, client_id: {}", (Object)clientId);
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN, "External registration script returned false.")).build();
        }
        catch (WebApplicationException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            return this.registerService.createInternalErrorResponse("Unknown.").build();
        }
    }

    private void validateClientNotNull(Client client) {
        if (client != null) {
            return;
        }
        this.log.trace("The Access Token is not valid for the Client ID, returns invalid_token error.");
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)RegisterErrorResponseType.INVALID_TOKEN, "The Access Token is not valid for the Client ID.");
    }

    private void validateSubjectType(RegisterRequest request) {
        if (request.getSubjectType() != null && !this.appConfiguration.getSubjectTypesSupported().contains(request.getSubjectType().toString())) {
            this.log.debug("Failed to perform client action, reason: subject_type is invalid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "subject_type is invalid");
        }
    }

    private void validateCiba(RegisterRequest request) {
        if (!this.cibaRegisterParamsValidatorService.validateParams(request.getBackchannelTokenDeliveryMode(), request.getBackchannelClientNotificationEndpoint(), request.getBackchannelAuthenticationRequestSigningAlg(), request.getGrantTypes(), request.getSubjectType(), request.getSectorIdentifierUri(), request.getJwks(), request.getJwksUri())) {
            this.log.debug("Failed to perform client action, reason: unable to validate CIBA parameters");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Invalid Client Metadata registering to use CIBA.");
        }
    }

    private void validateRedirectUris(RegisterRequest request) {
        boolean redirectUrisValidated = true;
        if (request.getRedirectUris() != null && !request.getRedirectUris().isEmpty()) {
            redirectUrisValidated = this.registerParamsValidator.validateRedirectUris(request.getGrantTypes(), request.getResponseTypes(), request.getApplicationType(), request.getSubjectType(), request.getRedirectUris(), request.getSectorIdentifierUri());
        }
        if (!redirectUrisValidated) {
            this.log.debug("Failed to perform client action, reason: unable to validate redirectUris");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "");
        }
    }

    private JSONObject modifyPutScript(JSONObject jsonObject, ExecutionContext executionContext) throws StringEncrypter.EncryptionException {
        if (!this.externalDynamicClientRegistrationService.modifyPutResponse(jsonObject, executionContext)) {
            return this.registerJsonService.getJSONObject(executionContext.getClient());
        }
        return jsonObject;
    }
}

