/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.model.common.User;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.BaseAuthFilterService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.AuthenticationException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class AuthenticationFilterService
extends BaseAuthFilterService {
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;

    @PostConstruct
    public void init() {
        super.init(this.appConfiguration.getAuthenticationFilters(), Boolean.TRUE.equals(this.appConfiguration.getAuthenticationFiltersEnabled()), true);
    }

    @Override
    public String processAuthenticationFilter(BaseAuthFilterService.AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<?, ?> attributeValues) throws SearchException {
        if (attributeValues == null) {
            return null;
        }
        Map<String, String> normalizedAttributeValues = AuthenticationFilterService.normalizeAttributeMap(attributeValues);
        String resultDn = this.loadEntryDN(this.ldapEntryManager, User.class, authenticationFilterWithParameters, normalizedAttributeValues);
        if (StringUtils.isBlank((CharSequence)resultDn)) {
            return null;
        }
        if (!Boolean.TRUE.equals(authenticationFilterWithParameters.getAuthenticationFilter().getBind())) {
            return resultDn;
        }
        String bindPasswordAttribute = authenticationFilterWithParameters.getAuthenticationFilter().getBindPasswordAttribute();
        if (StringHelper.isEmpty((String)bindPasswordAttribute)) {
            this.log.error("Skipping authentication filter:\n '{}'\n. It should contains not empty bind-password-attribute attribute. ", (Object)authenticationFilterWithParameters.getAuthenticationFilter());
            return null;
        }
        bindPasswordAttribute = StringHelper.toLowerCase((String)bindPasswordAttribute);
        try {
            boolean authenticated = this.ldapEntryManager.authenticate(resultDn, User.class, normalizedAttributeValues.get(bindPasswordAttribute));
            if (authenticated) {
                return resultDn;
            }
        }
        catch (AuthenticationException ex) {
            this.log.error("Invalid password", (Throwable)ex);
        }
        return null;
    }
}

