/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.model.configuration.BaseFilter;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.ldap.impl.LdapFilterConverter;
import io.jans.orm.model.base.BaseEntry;
import io.jans.orm.search.filter.Filter;
import io.jans.util.ArrayHelper;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public abstract class BaseAuthFilterService {
    @Inject
    protected Logger log;
    @Inject
    protected LdapFilterConverter ldapFilterConverter;
    public static final Pattern PARAM_VALUE_PATTERN = Pattern.compile("([\\w]+)[\\s]*\\=[\\*\\s]*(\\{[\\s]*[\\d]+[\\s]*\\})[\\*\\s]*");
    private boolean enabled;
    private boolean filterAttributes = true;
    private List<AuthenticationFilterWithParameters> filterWithParameters;

    public void init(List<? extends BaseFilter> filterList, boolean enabled, boolean filterAttributes) {
        this.enabled = enabled;
        this.filterWithParameters = this.prepareAuthenticationFilterWithParameters(filterList);
        this.filterAttributes = filterAttributes;
    }

    private List<AuthenticationFilterWithParameters> prepareAuthenticationFilterWithParameters(List<? extends BaseFilter> filterList) {
        ArrayList<AuthenticationFilterWithParameters> tmpAuthenticationFilterWithParameters = new ArrayList<AuthenticationFilterWithParameters>();
        if (!this.enabled || filterList == null) {
            return tmpAuthenticationFilterWithParameters;
        }
        for (BaseFilter baseFilter : filterList) {
            if (Boolean.TRUE.equals(baseFilter.getBind()) && StringHelper.isEmpty((String)baseFilter.getBindPasswordAttribute())) {
                this.log.error("Skipping authentication filter:\n '{}'\n. It should contains not empty bind-password-attribute attribute. ", (Object)baseFilter);
                continue;
            }
            ArrayList<String> variableNames = new ArrayList<String>();
            ArrayList<IndexedParameter> indexedParameters = new ArrayList<IndexedParameter>();
            Matcher matcher = PARAM_VALUE_PATTERN.matcher(baseFilter.getFilter());
            while (matcher.find()) {
                String paramName = BaseAuthFilterService.normalizeAttributeName(matcher.group(1));
                String paramIndex = matcher.group(2);
                variableNames.add(paramName);
                indexedParameters.add(new IndexedParameter(paramName, paramIndex));
            }
            AuthenticationFilterWithParameters tmpAutheticationFilterWithParameter = new AuthenticationFilterWithParameters(baseFilter, variableNames, indexedParameters);
            tmpAuthenticationFilterWithParameters.add(tmpAutheticationFilterWithParameter);
            this.log.debug("Authentication filter with parameters: '{}'. ", (Object)tmpAutheticationFilterWithParameter);
        }
        return tmpAuthenticationFilterWithParameters;
    }

    public static List<AuthenticationFilterWithParameters> getAllowedAuthenticationFilters(Collection<?> attributeNames, List<AuthenticationFilterWithParameters> filterList) {
        ArrayList<AuthenticationFilterWithParameters> tmpAuthenticationFilterWithParameters = new ArrayList<AuthenticationFilterWithParameters>();
        if (attributeNames == null) {
            return tmpAuthenticationFilterWithParameters;
        }
        HashSet<String> normalizedAttributeNames = new HashSet<String>();
        for (Object attributeName : attributeNames) {
            normalizedAttributeNames.add(BaseAuthFilterService.normalizeAttributeName(attributeName.toString()));
        }
        for (AuthenticationFilterWithParameters autheticationFilterWithParameters : filterList) {
            if (!normalizedAttributeNames.containsAll(autheticationFilterWithParameters.getVariableNames())) continue;
            tmpAuthenticationFilterWithParameters.add(autheticationFilterWithParameters);
        }
        return tmpAuthenticationFilterWithParameters;
    }

    public static Map<String, String> normalizeAttributeMap(Map<?, ?> attributeValues) {
        HashMap<String, String> normalizedAttributeValues = new HashMap<String, String>();
        for (Map.Entry<?, ?> attributeValueEntry : attributeValues.entrySet()) {
            String attributeValue = null;
            Object attributeValueEntryValue = attributeValueEntry.getValue();
            if (attributeValueEntryValue instanceof String[]) {
                if (ArrayHelper.isNotEmpty((Object[])((String[])attributeValueEntryValue))) {
                    attributeValue = ((String[])attributeValueEntryValue)[0];
                }
            } else if (attributeValueEntryValue instanceof String) {
                attributeValue = (String)attributeValueEntryValue;
            } else if (attributeValueEntryValue != null) {
                attributeValue = attributeValueEntryValue.toString();
            }
            if (attributeValue == null) continue;
            normalizedAttributeValues.put(BaseAuthFilterService.normalizeAttributeName(attributeValueEntry.getKey().toString()), attributeValue);
        }
        return normalizedAttributeValues;
    }

    public static String buildFilter(AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<String, String> normalizedAttributeValues) {
        String filter = authenticationFilterWithParameters.getAuthenticationFilter().getFilter();
        for (IndexedParameter indexedParameter : authenticationFilterWithParameters.getIndexedVariables()) {
            String attributeValue = normalizedAttributeValues.get(indexedParameter.getParamName());
            if (attributeValue == null) continue;
            filter = filter.replace(indexedParameter.getParamIndex(), attributeValue);
        }
        return filter;
    }

    public <T> String loadEntryDN(PersistenceEntryManager manager, Class<T> entryClass, AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<String, String> normalizedAttributeValues) throws SearchException {
        String filter = BaseAuthFilterService.buildFilter(authenticationFilterWithParameters, normalizedAttributeValues);
        Filter ldapFilter = this.ldapFilterConverter.convertRawLdapFilterToFilter(filter).multiValued(Boolean.valueOf(false));
        this.log.debug("Using filter: '{}'", (Object)ldapFilter);
        List foundEntries = manager.findEntries(authenticationFilterWithParameters.getAuthenticationFilter().getBaseDn(), entryClass, ldapFilter, new String[0]);
        if (foundEntries.size() > 1) {
            this.log.error("Found more than one entry by filter: '{}'. Entries: {}\n", (Object)ldapFilter, (Object)foundEntries);
            return null;
        }
        this.log.debug("Found entries: {}", (Object)foundEntries.size());
        if (foundEntries.size() != 1) {
            return null;
        }
        return ((BaseEntry)foundEntries.get(0)).getDn();
    }

    public String processAuthenticationFilters(Map<?, ?> attributeValues) throws SearchException {
        if (attributeValues == null) {
            return null;
        }
        List<AuthenticationFilterWithParameters> allowedList = this.filterAttributes ? BaseAuthFilterService.getAllowedAuthenticationFilters(attributeValues.keySet(), this.getFilterWithParameters()) : this.getFilterWithParameters();
        for (AuthenticationFilterWithParameters allowed : allowedList) {
            String resultDn = this.processAuthenticationFilter(allowed, attributeValues);
            if (!StringHelper.isNotEmpty((String)resultDn)) continue;
            return resultDn;
        }
        return null;
    }

    public abstract String processAuthenticationFilter(AuthenticationFilterWithParameters var1, Map<?, ?> var2) throws SearchException;

    public List<AuthenticationFilterWithParameters> getFilterWithParameters() {
        return this.filterWithParameters;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isFilterAttributes() {
        return this.filterAttributes;
    }

    public void setFilterAttributes(boolean filterAttributes) {
        this.filterAttributes = filterAttributes;
    }

    public static String normalizeAttributeName(String attributeName) {
        return StringHelper.toLowerCase((String)attributeName.trim());
    }

    public static class IndexedParameter {
        private String paramName;
        private String paramIndex;

        public IndexedParameter(String paramName, String paramIndex) {
            this.paramName = paramName;
            this.paramIndex = paramIndex;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public String getParamIndex() {
            return this.paramIndex;
        }

        public void setParamIndex(String paramIndex) {
            this.paramIndex = paramIndex;
        }

        public String toString() {
            return String.format("IndexedParameter [paramName=%s, paramIndex=%s]", this.paramName, this.paramIndex);
        }
    }

    public static class AuthenticationFilterWithParameters {
        private BaseFilter authenticationFilter;
        private List<String> variableNames;
        private List<IndexedParameter> indexedVariables;

        public AuthenticationFilterWithParameters(BaseFilter authenticationFilter, List<String> variableNames, List<IndexedParameter> indexedVariables) {
            this.authenticationFilter = authenticationFilter;
            this.variableNames = variableNames;
            this.indexedVariables = indexedVariables;
        }

        public BaseFilter getAuthenticationFilter() {
            return this.authenticationFilter;
        }

        public void setAuthenticationFilter(BaseFilter authenticationFilter) {
            this.authenticationFilter = authenticationFilter;
        }

        public List<String> getVariableNames() {
            return this.variableNames;
        }

        public void setVariableNames(List<String> variableNames) {
            this.variableNames = variableNames;
        }

        public List<IndexedParameter> getIndexedVariables() {
            return this.indexedVariables;
        }

        public void setIndexedVariables(List<IndexedParameter> indexedVariables) {
            this.indexedVariables = indexedVariables;
        }

        public String toString() {
            return String.format("AutheticationFilterWithParameters [authenticationFilter=%s, variableNames=%s, indexedVariables=%s]", this.authenticationFilter, this.variableNames, this.indexedVariables);
        }
    }
}

