/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorHandlingMethod;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.service.CookieService;
import io.jans.jsf2.message.FacesMessages;
import io.jans.jsf2.service.FacesService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.application.FacesMessage;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class ErrorHandlerService {
    @Inject
    private Logger log;
    @Inject
    private CookieService cookieService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesMessages facesMessages;

    public void handleError(String facesMessageId, IErrorType errorType, String hint) {
        if (ErrorHandlingMethod.REMOTE == this.appConfiguration.getErrorHandlingMethod()) {
            this.handleRemoteError(facesMessageId, errorType, hint);
        } else {
            this.handleLocalError(facesMessageId);
        }
    }

    private void addMessage(FacesMessage.Severity severity, String facesMessageId) {
        if (StringHelper.isNotEmpty((String)facesMessageId)) {
            this.facesMessages.add(severity, String.format("#{msgs['%s']}", facesMessageId));
        }
    }

    private void handleLocalError(String facesMessageId) {
        this.log.debug("Show /error.xhtml with message {}", (Object)facesMessageId);
        this.addMessage(FacesMessage.SEVERITY_ERROR, facesMessageId);
        this.facesService.redirect("/error.xhtml");
    }

    private void handleRemoteError(String facesMessageId, IErrorType errorType, String hint) {
        String redirectUri = this.cookieService.getRpOriginIdCookie();
        if (StringHelper.isEmpty((String)redirectUri)) {
            this.log.error("Failed to get redirect_uri from cookie");
            this.handleLocalError(facesMessageId);
            return;
        }
        RedirectUri redirectUriResponse = new RedirectUri(redirectUri, null, null);
        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString(errorType, null));
        if (StringHelper.isNotEmpty((String)hint)) {
            redirectUriResponse.addResponseParameter("hint", "Create authorization request to start new authentication session.");
        }
        String redirectTo = redirectUriResponse.toString();
        this.log.debug("Redirect to {}", (Object)redirectTo);
        this.facesService.redirectToExternalURL(redirectTo);
    }
}

