/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.claims.Audience;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidJweException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwe.JweEncrypterImpl;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.token.JwtSigner;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ServerCryptoProvider;
import io.jans.util.security.StringEncrypter;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import org.apache.commons.lang3.BooleanUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@Named
public class IntrospectionService {
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Logger log;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AbstractCryptoProvider cryptoProvider;

    public void validateIntrospectionScopePresence(AuthorizationGrant authorizationGrant) {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getIntrospectionAccessTokenMustHaveIntrospectionScope()) && !authorizationGrant.getScopesAsString().contains("introspection")) {
            String reason = "access_token used to access introspection endpoint does not have 'introspection' scope, however in AS configuration 'introspectionAccessTokenMustHaveIntrospectionScope' is true";
            this.log.trace("access_token used to access introspection endpoint does not have 'introspection' scope, however in AS configuration 'introspectionAccessTokenMustHaveIntrospectionScope' is true");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "access_token used to access introspection endpoint does not have 'introspection' scope, however in AS configuration 'introspectionAccessTokenMustHaveIntrospectionScope' is true")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    public boolean isJwtResponse(String responseAsJwt, String acceptHeader) {
        return Boolean.TRUE.toString().equalsIgnoreCase(responseAsJwt) || "application/token-introspection+jwt".equalsIgnoreCase(acceptHeader);
    }

    public String createResponseJwt(JSONObject response, AuthorizationGrant grant) throws Exception {
        Client client = grant.getClient();
        KeyEncryptionAlgorithm keyAlgorithm = KeyEncryptionAlgorithm.fromName((String)client.getAttributes().getIntrospectionEncryptedResponseAlg());
        BlockEncryptionAlgorithm blockAlgorithm = BlockEncryptionAlgorithm.fromName((String)client.getAttributes().getIntrospectionEncryptedResponseEnc());
        if (keyAlgorithm != null && blockAlgorithm != null) {
            this.log.trace("Preparing encrypted introspection response with keyEncryptionAlgorithm {}, blockEncryptionAlgorithm: {}", (Object)keyAlgorithm, (Object)blockAlgorithm);
            Jwe jwe = new Jwe();
            jwe.getHeader().setType(JwtType.JWT);
            jwe.getHeader().setAlgorithm(keyAlgorithm);
            jwe.getHeader().setEncryptionMethod(blockAlgorithm);
            this.fillPayload((JsonWebResponse)jwe, response, grant);
            JwtSigner jwtSigner = this.newJwtSigner(client);
            Jwt jwt = jwtSigner.newJwt();
            jwt.setClaims(jwe.getClaims());
            jwe.setSignedJWTPayload(this.signJwt(jwt, client));
            if (keyAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
                JSONObject jsonWebKeys = CommonUtils.getJwks((Client)client);
                String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyAlgorithm.getName()), Use.ENCRYPTION, KeyOpsType.CONNECT);
                PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId, jsonWebKeys, null);
                jwe.getHeader().setKeyId(keyId);
                if (publicKey == null) {
                    throw new InvalidJweException("The public key is not valid");
                }
                JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyAlgorithm, blockAlgorithm, publicKey);
                return jweEncrypter.encrypt(jwe).toString();
            }
            if (keyAlgorithm == KeyEncryptionAlgorithm.A128KW || keyAlgorithm == KeyEncryptionAlgorithm.A256KW) {
                byte[] sharedSymmetricKey = this.clientService.decryptSecret(client.getClientSecret()).getBytes(StandardCharsets.UTF_8);
                JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyAlgorithm, blockAlgorithm, sharedSymmetricKey);
                return jweEncrypter.encrypt(jwe).toString();
            }
        }
        this.log.trace("Preparing signed introspection response, client {}", (Object)client.getClientId());
        JwtSigner jwtSigner = this.newJwtSigner(client);
        Jwt jwt = jwtSigner.newJwt();
        this.fillPayload((JsonWebResponse)jwt, response, grant);
        return jwtSigner.sign().toString();
    }

    private JwtSigner newJwtSigner(Client client) throws StringEncrypter.EncryptionException {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getAttributes().getIntrospectionSignedResponseAlg() != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAttributes().getIntrospectionSignedResponseAlg());
        }
        return new JwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
    }

    private Jwt signJwt(Jwt jwt, Client client) throws Exception {
        JwtSigner jwtSigner = this.newJwtSigner(client);
        jwtSigner.setJwt(jwt);
        jwtSigner.sign();
        return jwt;
    }

    public void fillPayload(JsonWebResponse jwt, JSONObject response, AuthorizationGrant grant) throws InvalidJwtException {
        Client client = grant.getClient();
        Audience.setAudience((JwtClaims)jwt.getClaims(), (Client)client);
        jwt.getClaims().setIssuer(this.appConfiguration.getIssuer());
        jwt.getClaims().setIatNow();
        try {
            jwt.getClaims().setClaim("token_introspection", response);
        }
        catch (Exception e) {
            this.log.error("Failed to put claims into jwt. Key: token_introspection, response: " + response.toString(), (Throwable)e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Response before signing: {}", (Object)jwt.getClaims().toJsonString());
        }
    }

    public String createResponseAsJwt(JSONObject response, AuthorizationGrant grant) throws Exception {
        return this.createResponseJwt(response, grant);
    }
}

