/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.service.common.ConfigurationService;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.model.ApplicationType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.service.metric.inject.ReportMetric;
import io.jans.service.net.NetworkService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named(value="metricService")
public class MetricService
extends io.jans.service.metric.MetricService {
    public static final String METRIC_SERVICE_COMPONENT_NAME = "metricService";
    private static final long serialVersionUID = 7875838160379126796L;
    @Inject
    private Instance<MetricService> instance;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private NetworkService networkService;
    @Inject
    @Named(value="persistenceMetricEntryManager")
    @ReportMetric
    private PersistenceEntryManager ldapEntryManager;

    public void initTimer() {
        this.initTimer(this.appConfiguration.getMetricReporterInterval(), this.appConfiguration.getMetricReporterKeepDataDays());
    }

    public String baseDn() {
        return this.staticConfiguration.getBaseDn().getMetric();
    }

    public io.jans.service.metric.MetricService getMetricServiceInstance() {
        return (io.jans.service.metric.MetricService)this.instance.get();
    }

    public boolean isMetricReporterEnabled() {
        return this.appConfiguration.isFeatureEnabled(FeatureFlagType.METRIC);
    }

    public ApplicationType getApplicationType() {
        return ApplicationType.OX_AUTH;
    }

    public PersistenceEntryManager getEntryManager() {
        return this.ldapEntryManager;
    }

    public String getNodeIndetifier() {
        return this.networkService.getMacAdress();
    }
}

