/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.cluster;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.cluster.ClusterNodeService;
import io.jans.model.token.AbstractIndexPool;
import io.jans.model.tokenstatus.StatusList;
import io.jans.model.tokenstatus.TokenStatus;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.exception.operation.DuplicateEntryException;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SortOrder;
import io.jans.orm.search.filter.Filter;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractStatusIndexPoolService<T extends AbstractIndexPool> {
    public static final int ATTEMPT_LIMIT = 10;
    public static long DELAY_AFTER_EXPIRATION = 10800000L;
    public static long LOCK_WAIT_BEFORE_UPDATE = 3000L;
    public static long DELAY_IF_LOCKED = 500L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private PersistenceEntryManager entryManager;
    private int indexAllocationBlockSize;

    public static AbstractIndexPool setIndexes(AbstractIndexPool pool, int indexAllocationBlockSize) {
        if (pool == null) {
            return pool;
        }
        int index = pool.getId();
        pool.setStartIndex(Integer.valueOf(index * indexAllocationBlockSize));
        pool.setEndIndex(Integer.valueOf((index + 1) * indexAllocationBlockSize - 1));
        return pool;
    }

    @PostConstruct
    public void init() {
        String logPrefix = this.logPrefix();
        this.log.info("{} Initializing Status Index Pool Service ...", (Object)logPrefix);
        this.indexAllocationBlockSize = this.appConfiguration.getStatusListIndexAllocationBlockSize();
    }

    public T getPoolByDn(String dn) {
        return (T)this.setIndexes((AbstractIndexPool)this.entryManager.find(this.getEntityClass(), (Object)dn));
    }

    public T getPoolById(int id) {
        return this.getPoolByDn(this.createDn(id));
    }

    public List<T> getAllPools() {
        return this.setIndexes(this.entryManager.findEntries(this.baseDn(), this.getEntityClass(), Filter.createPresenceFilter((String)"jansNum")));
    }

    public T getPoolLast() {
        PagedResult pagedResult;
        String baseDn = this.baseDn();
        int count = 1;
        if (PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(this.entryManager.getPersistenceType(baseDn))) {
            count = Integer.MAX_VALUE;
        }
        if ((pagedResult = this.entryManager.findPagedEntries(baseDn, this.getEntityClass(), Filter.createPresenceFilter((String)"jansNum"), null, "jansNum", SortOrder.DESCENDING, 0, count, count)).getEntriesCount() >= 1) {
            return (T)this.setIndexes((AbstractIndexPool)pagedResult.getEntries().get(0));
        }
        return null;
    }

    public T getPoolByIndex(int index) {
        int poolId = index / this.indexAllocationBlockSize;
        return this.getPoolById(poolId);
    }

    public List<T> getNodePools(Integer nodeId) {
        String baseDn = this.baseDn();
        return this.setIndexes(this.entryManager.findEntries(baseDn, this.getEntityClass(), Filter.createEqualityFilter((String)"jansNodeId", (Object)nodeId)));
    }

    public List<T> getPoolsExpired() {
        String baseDn = this.baseDn();
        Date expirationDate = new Date(System.currentTimeMillis() - DELAY_AFTER_EXPIRATION);
        Filter filter = Filter.createORFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"exp", null), Filter.createLessOrEqualFilter((String)"exp", (Object)this.entryManager.encodeTime(baseDn, expirationDate))});
        return this.setIndexes(this.entryManager.findEntries(baseDn, this.getEntityClass(), filter));
    }

    protected void persist(T pool) {
        this.entryManager.persist(pool);
    }

    public void update(T pool) {
        this.entryManager.merge(pool);
    }

    public T updateWithLock(String poolDn, List<Integer> indexes, TokenStatus status) throws IOException {
        String logPrefix = this.logPrefix();
        this.log.debug("{} Attempt to update pool {} with lock {}...", new Object[]{logPrefix, poolDn, ClusterNodeService.LOCK_KEY});
        int attempt = 1;
        do {
            T loadedPool = this.getPoolByDn(poolDn);
            int bitSize = this.getStatusListBitSize();
            StatusList statusList = StringUtils.isNotBlank((CharSequence)loadedPool.getData()) ? StatusList.fromEncoded((String)loadedPool.getData(), (int)bitSize) : new StatusList(bitSize);
            for (Integer index : indexes) {
                statusList.set(index.intValue(), status.getValue());
            }
            loadedPool.setLockKey(ClusterNodeService.LOCK_KEY);
            loadedPool.setData(statusList.getLst());
            loadedPool.setLastUpdate(new Date());
            loadedPool.setExpirationDate(loadedPool.getExpirationDate());
            this.update(loadedPool);
            loadedPool = this.getPoolByDn(loadedPool.getDn());
            if (ClusterNodeService.LOCK_KEY.equals(loadedPool.getLockKey())) {
                this.log.debug("{} Updated pool {} with lock with attempt {}, lockKey: {}", new Object[]{logPrefix, loadedPool.getId(), attempt, ClusterNodeService.LOCK_KEY});
                return loadedPool;
            }
            this.log.debug("{} Failed to update pool {} with lock {} with attempt {}", new Object[]{logPrefix, loadedPool.getId(), ClusterNodeService.LOCK_KEY, attempt});
        } while (++attempt < 10);
        this.log.error("{} Unable to update pool {} with lock {} with attempt {}", new Object[]{logPrefix, poolDn, ClusterNodeService.LOCK_KEY, attempt});
        return null;
    }

    public T allocate(int nodeId) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String logPrefix = this.logPrefix();
        this.log.debug("{} Allocating status index pool, node {}, LOCK_KEY {}... ", new Object[]{logPrefix, nodeId, ClusterNodeService.LOCK_KEY});
        List<T> expiredPools = this.getPoolsExpired();
        this.log.debug("{} Allocation - found {} expired status index pools, node {}.", new Object[]{logPrefix, expiredPools.size(), nodeId});
        Date expirationDate = new Date(System.currentTimeMillis() + (long)(2 * this.appConfiguration.getAccessTokenLifetime() * 1000));
        for (AbstractIndexPool pool : expiredPools) {
            try {
                pool.setLockKey(ClusterNodeService.LOCK_KEY);
                pool.setExpirationDate(expirationDate);
                pool.setLastUpdate(new Date());
                pool.setNodeId(Integer.valueOf(nodeId));
                this.update(pool);
                T lockedPool = this.getPoolByDn(pool.getDn());
                if (!ClusterNodeService.LOCK_KEY.equals(lockedPool.getLockKey()) || !lockedPool.getNodeId().equals(nodeId)) continue;
                this.log.debug("{} Re-using existing status index pool {}, node {}, LOCK_KEY {}", new Object[]{logPrefix, lockedPool.getId(), nodeId, ClusterNodeService.LOCK_KEY});
                this.markAllIndexesAsValid(lockedPool.enumerateAllIndexes());
                return lockedPool;
            }
            catch (EntryPersistenceException ex) {
                this.log.debug(logPrefix + " Unexpected error happened during entry lock, node " + nodeId, (Throwable)ex);
            }
        }
        int attempt = 1;
        do {
            this.log.debug("{} Attempting to persist new status index pool. Attempt {} out of {}. Node {}.", new Object[]{logPrefix, attempt, 10, nodeId});
            T lastPool = this.getPoolLast();
            int lastPoolIndex = lastPool == null ? 0 : lastPool.getId() + 1;
            Class<T> entityClass = this.getEntityClass();
            AbstractIndexPool pool = (AbstractIndexPool)entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pool.setId(Integer.valueOf(lastPoolIndex));
            pool.setDn(this.createDn(lastPoolIndex));
            pool.setNodeId(Integer.valueOf(nodeId));
            pool.setLastUpdate(new Date());
            pool.setLockKey(ClusterNodeService.LOCK_KEY);
            try {
                expirationDate = new Date(System.currentTimeMillis() + (long)(2 * this.appConfiguration.getAccessTokenLifetime() * 1000));
                pool.setExpirationDate(expirationDate);
                try {
                    this.log.debug("{} Trying to persist index {} for node {}", new Object[]{logPrefix, lastPoolIndex, nodeId});
                    this.persist(pool);
                }
                catch (EntryPersistenceException e) {
                    if (e.getCause() instanceof DuplicateEntryException) {
                        this.log.debug("{} Detected duplicate entry, increased index to {}", (Object)logPrefix, (Object)(++lastPoolIndex));
                        pool.setId(Integer.valueOf(lastPoolIndex));
                        pool.setDn(this.createDn(lastPoolIndex));
                        this.persist(pool);
                    }
                    throw e;
                }
                T lockedPool = this.getPoolByDn(pool.getDn());
                if (ClusterNodeService.LOCK_KEY.equals(lockedPool.getLockKey()) && lockedPool.getNodeId().equals(nodeId)) {
                    this.log.debug("{} Successfully created new status index pool {}, node {}", new Object[]{logPrefix, lockedPool.getId(), nodeId});
                    return this.setIndexes(lockedPool);
                }
                this.log.debug("{} Failed to create new status index pool {}, node {}", new Object[]{logPrefix, lockedPool.getId(), nodeId});
            }
            catch (EntryPersistenceException ex) {
                this.log.debug(logPrefix + " Unexpected error happened during entry lock, node " + nodeId, (Throwable)ex);
            }
        } while (++attempt <= 10);
        throw new EntryPersistenceException(String.format("%s Failed to allocate StatusIndexPool for node %s!!!", logPrefix, nodeId));
    }

    private T setIndexes(T pool) {
        return (T)AbstractStatusIndexPoolService.setIndexes(pool, this.indexAllocationBlockSize);
    }

    private List<T> setIndexes(List<T> pools) {
        if (pools == null) {
            return pools;
        }
        for (AbstractIndexPool pool : pools) {
            this.setIndexes(pool);
        }
        return pools;
    }

    public abstract String baseDn();

    public abstract int getStatusListBitSize();

    public abstract Class<T> getEntityClass();

    public abstract void markAllIndexesAsValid(List<Integer> var1);

    public abstract String logPrefix();

    public String createDn(int id) {
        String baseDn = this.baseDn();
        return String.format("jansNum=%d,%s", id, baseDn);
    }
}

