/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.cluster;

import com.google.common.base.Preconditions;
import io.jans.as.server.service.cdi.event.TokenPoolUpdateEvent;
import io.jans.as.server.service.cluster.ClusterNodeService;
import io.jans.model.cluster.ClusterNode;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

@ApplicationScoped
public class ClusterNodeManager {
    @Inject
    private Logger log;
    @Inject
    private ClusterNodeService clusterNodeService;
    @Inject
    private Event<TimerEvent> timerEvent;
    private AtomicBoolean isActive;
    private ClusterNode node;

    @PostConstruct
    public void init() {
        this.log.info("Initializing Cluster Node Manager ...");
        this.isActive = new AtomicBoolean(false);
        this.node = this.clusterNodeService.allocate();
        if (this.node != null) {
            this.log.info("Assigned cluster node id '{}' for this instance", (Object)this.node.getId());
        } else {
            this.log.error("Failed to initialize Cluster Node Manager.");
        }
    }

    public void initTimer() {
        this.log.debug("Initializing Policy Download Service Timer");
        int delayInSeconds = 30;
        int intervalInSeconds = 30;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new TokenPoolUpdateEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadNodesTimerEvent(@Observes @Scheduled TokenPoolUpdateEvent tokenPoolUpdateEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateNode();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading nodes", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void updateNode() {
        this.checkNodeNotNull();
        this.clusterNodeService.refresh(this.node);
    }

    public void destroy(@Observes @BeforeDestroyed(value=ApplicationScoped.class) ServletContext init) {
        this.log.info("Stopped cluster manager");
    }

    public Integer getClusterNodeId() {
        this.checkNodeNotNull();
        return this.node.getId();
    }

    private void checkNodeNotNull() {
        Preconditions.checkNotNull((Object)this.node, (Object)"Failed to allocate cluster node.");
    }
}

