/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.common.model.registration.Client;
import io.jans.as.server.auth.Authenticator;
import io.jans.as.server.service.external.context.ExternalClientAuthnContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.client.ClientAuthnType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

@ApplicationScoped
public class ExternalClientAuthnService
extends ExternalScriptService {
    @Inject
    private Authenticator authenticator;

    public ExternalClientAuthnService() {
        super(CustomScriptType.CLIENT_AUTHN);
    }

    public Client externalAuthenticateClient(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        List scripts = this.getCustomScriptConfigurations();
        if (scripts == null || scripts.isEmpty()) {
            this.log.trace("Unable to perform client authentication by custom script because there is no `client_authn` scripts.");
            return null;
        }
        for (CustomScriptConfiguration script : scripts) {
            Client client = this.externalAuthenticateClient(script, servletRequest, servletResponse);
            if (client == null) continue;
            this.log.trace("Client {} authenticated successfully by custom script {}.", (Object)ExternalClientAuthnService.getClientId(client), (Object)script.getName());
            return client;
        }
        this.log.trace("All `client_authn` scripts returned false.");
        return null;
    }

    private Client externalAuthenticateClient(CustomScriptConfiguration customScript, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        ClientAuthnType script = (ClientAuthnType)customScript.getExternalType();
        this.log.trace("Executing external 'authenticateClient' method, script name: {}, requestParameters: {}", (Object)customScript.getName(), (Object)servletRequest.getParameterMap());
        ExternalClientAuthnContext context = new ExternalClientAuthnContext(servletRequest, servletResponse);
        Client client = null;
        try {
            client = (Client)script.authenticateClient((Object)context);
            if (client != null) {
                this.authenticator.configureSessionClient(client);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to run external 'authenticateClient' method of script " + customScript.getName(), (Throwable)e);
            client = null;
        }
        this.log.trace("Executed external 'authenticateClient' method, client {}, script name: {}, requestParameters: {}", new Object[]{ExternalClientAuthnService.getClientId(client), customScript.getName(), servletRequest.getParameterMap()});
        return client;
    }

    private static String getClientId(Client client) {
        return client != null ? client.getClientId() : "null";
    }
}

