/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.server.service.external.context.EndSessionContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.logout.EndSessionType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalEndSessionService
extends ExternalScriptService {
    public ExternalEndSessionService() {
        super(CustomScriptType.END_SESSION);
    }

    public String getFrontchannelHtml(EndSessionContext context) {
        if (this.customScriptConfigurations == null || this.customScriptConfigurations.isEmpty()) {
            this.log.trace("There is no any external interception script defined (getFrontchannelHtml).");
            return "";
        }
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            String html = this.getFrontchannelHtml(script, context);
            if (!StringUtils.isNotBlank((CharSequence)html)) continue;
            return html;
        }
        return null;
    }

    private String getFrontchannelHtml(CustomScriptConfiguration scriptConf, EndSessionContext context) {
        try {
            this.log.trace("Executing external 'getFrontchannelHtml' method, script name: {}, context: {}", (Object)scriptConf.getName(), (Object)context);
            EndSessionType script = (EndSessionType)scriptConf.getExternalType();
            context.setScript(scriptConf);
            String html = script.getFrontchannelHtml((Object)context);
            this.log.trace("Finished external 'getFrontchannelHtml' method, script name: {}, context {}, html: {}", new Object[]{scriptConf.getName(), context, html});
            return html;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConf.getCustomScript(), ex);
            return null;
        }
    }
}

