/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external.context;

import io.jans.as.client.RegisterRequest;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.model.util.CertUtils;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.SimpleCustomProperty;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.service.cdi.util.CdiUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClientRegistrationContext
extends ExternalScriptContext {
    private static final Logger log = LoggerFactory.getLogger(DynamicClientRegistrationContext.class);
    private CustomScriptConfiguration script;
    private JSONObject registerRequestJson;
    private RegisterRequest registerRequest;
    private Jwt softwareStatement;
    private Jwt dcr;
    private Jwt evidence;
    private Client client;
    private ErrorResponseFactory errorResponseFactory;
    private X509Certificate certificate;

    public DynamicClientRegistrationContext(HttpServletRequest httpRequest, JSONObject registerRequest, CustomScriptConfiguration script) {
        this(httpRequest, registerRequest, script, null);
    }

    public DynamicClientRegistrationContext(HttpServletRequest httpRequest, JSONObject registerRequest, CustomScriptConfiguration script, Client client) {
        super(httpRequest);
        this.script = script;
        this.registerRequestJson = registerRequest;
        this.client = client;
    }

    public Jwt getEvidence() {
        return this.evidence;
    }

    public void setEvidence(Jwt evidence) {
        this.evidence = evidence;
    }

    public WebApplicationException createStaleEvidenceWebApplicationException() {
        return this.createStaleEvidenceWebApplicationException(UUID.randomUUID().toString());
    }

    public WebApplicationException createStaleEvidenceWebApplicationException(String nonce) {
        String entity = this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.STALE_EVIDENCE, "");
        JSONObject json = new JSONObject(entity);
        json.put("nonce", (Object)nonce);
        return new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).type(MediaType.APPLICATION_JSON_TYPE).build());
    }

    public Jwt getDcr() {
        return this.dcr;
    }

    public void setDcr(Jwt dcr) {
        this.dcr = dcr;
    }

    public Jwt getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(Jwt softwareStatement) {
        this.softwareStatement = softwareStatement;
    }

    public CustomScriptConfiguration getScript() {
        return this.script;
    }

    public void setScript(CustomScriptConfiguration script) {
        this.script = script;
    }

    public JSONObject getRegisterRequestJson() {
        return this.registerRequestJson;
    }

    public void setRegisterRequestJson(JSONObject registerRequestJson) {
        this.registerRequestJson = registerRequestJson;
    }

    public RegisterRequest getRegisterRequest() {
        return this.registerRequest;
    }

    public void setRegisterRequest(RegisterRequest registerRequest) {
        this.registerRequest = registerRequest;
    }

    public Map<String, SimpleCustomProperty> getConfigurationAttibutes() {
        String cert;
        Map attrs = this.script.getConfigurationAttributes();
        if (this.httpRequest != null && StringUtils.isNotBlank((CharSequence)(cert = this.httpRequest.getHeader("X-ClientCert")))) {
            SimpleCustomProperty certProperty = new SimpleCustomProperty();
            certProperty.setValue1(cert);
            attrs.put("certProperty", certProperty);
        }
        return attrs != null ? new HashMap<String, SimpleCustomProperty>(attrs) : new HashMap();
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void validateSSA() {
        this.validateSSANotNull();
        this.validateSSARedirectUri();
        this.validateSoftwareId();
        this.validateCertSubjectHasCNAndOU();
        this.validateCNEqualsSoftwareId();
        this.validateOUEqualsOrgId();
        this.validateIssuer();
    }

    public void validateIssuer() {
        String certificateIssuer;
        Map issuerConfigs = ((AppConfiguration)CdiUtil.bean(AppConfiguration.class)).getTrustedSsaIssuers();
        Set issuers = issuerConfigs.keySet();
        if (issuers.isEmpty()) {
            return;
        }
        String issuer = this.softwareStatement.getClaims().getClaimAsString("iss");
        if (!issuers.contains(issuer)) {
            this.throwWebApplicationException("SSA Issuer is not allowed.", (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
        }
        if (this.certificate != null && !issuers.contains(certificateIssuer = this.certificate.getIssuerX500Principal().getName())) {
            this.throwWebApplicationException("Certificate Issuer is not allowed.", (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
        }
    }

    public void validateCertSubjectHasCNAndOU() {
        this.validateCNIsNotBlank();
        this.validateOUIsNotBlank();
    }

    public String validateOUIsNotBlank() {
        String ou = CertUtils.getAttr((X509Certificate)this.certificate, (ASN1ObjectIdentifier)BCStyle.OU);
        if (StringUtils.isBlank((CharSequence)ou)) {
            this.throwWebApplicationException("OU of certificate is not set.", (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
        }
        return ou;
    }

    public String validateCNIsNotBlank() {
        String cn = CertUtils.getAttr((X509Certificate)this.certificate, (ASN1ObjectIdentifier)BCStyle.CN);
        if (StringUtils.isBlank((CharSequence)cn)) {
            this.throwWebApplicationException("CN of certificate is not set.", (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
        }
        return cn;
    }

    public void throwWebApplicationException(String message, IErrorType errorType) {
        log.error(message);
        this.throwWebApplicationExceptionIfSet();
        throw this.createWebApplicationException(Response.Status.BAD_REQUEST.getStatusCode(), this.errorResponseFactory.getErrorAsJson(errorType));
    }

    public void validateCNEqualsSoftwareId() {
        String cn = this.validateCNIsNotBlank();
        String softwareId = this.softwareStatement.getClaims().getClaimAsString("software_id");
        if (StringUtils.isBlank((CharSequence)softwareId)) {
            this.throwWebApplicationException("softwareId is not set in SSA", (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
            return;
        }
        if (cn.equals(softwareId)) {
            return;
        }
        this.throwWebApplicationException("CN does not equals to softwareId in SSA. CN: " + cn + ", softwareId: " + softwareId, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
    }

    public void validateOUEqualsOrgId() {
        String ou = this.validateOUIsNotBlank();
        String orgId = this.softwareStatement.getClaims().getClaimAsString("org_id");
        if (StringUtils.isBlank((CharSequence)orgId)) {
            this.throwWebApplicationException("orgId is not set in SSA", (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
            return;
        }
        if (ou.equals(orgId)) {
            return;
        }
        this.throwWebApplicationException("OU does not equals to orgId in SSA. OU: " + ou + ", orgId: " + orgId, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
    }

    public void validateSSARedirectUri() {
        this.validateSSARedirectUri("software_redirect_uris");
    }

    public void validateSSARedirectUri(String ssaRedirectUriClaimName) {
        List redirectUris;
        if (!this.softwareStatement.getClaims().hasClaim(ssaRedirectUriClaimName)) {
            return;
        }
        List ssaRedirectUris = this.softwareStatement.getClaims().getClaimAsStringList(ssaRedirectUriClaimName);
        if (ssaRedirectUris.containsAll(redirectUris = this.registerRequest.getRedirectUris())) {
            return;
        }
        this.throwWebApplicationException("SSA redirect_uris does not match redirect_uris of the request. SSA redirect_uris: " + ssaRedirectUris + ", request redirectUris: " + redirectUris, (IErrorType)RegisterErrorResponseType.INVALID_REDIRECT_URI);
    }

    public void validateSSANotNull() {
        if (this.softwareStatement == null) {
            this.throwWebApplicationException("SSA is null", (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT);
        }
    }

    public void validateSoftwareId() {
        String softwareId = this.registerRequest.getSoftwareId();
        if (StringUtils.isBlank((CharSequence)softwareId)) {
            return;
        }
        String ssaSoftwareId = this.softwareStatement.getClaims().getClaimAsString("software_id");
        if (softwareId.equals(ssaSoftwareId)) {
            return;
        }
        this.throwWebApplicationException(String.format("SSA softwareId (%s), does not match to softwareId in request (%s)", ssaSoftwareId, softwareId), (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA);
    }

    public ErrorResponseFactory getErrorResponseFactory() {
        return this.errorResponseFactory;
    }

    public void setErrorResponseFactory(ErrorResponseFactory errorResponseFactory) {
        this.errorResponseFactory = errorResponseFactory;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public String toString() {
        return "DynamicClientRegistrationContext{softwareStatement=" + this.softwareStatement + "registerRequest=" + this.registerRequestJson + "script=" + this.script + "} " + super.toString();
    }
}

