/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.logout;

import com.mysql.cj.util.StringUtils;
import io.jans.as.common.claims.Audience;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.model.util.CertUtils;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.LogoutStatusJwt;
import io.jans.as.server.model.token.JwtSigner;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.DiscoveryService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalLogoutStatusJwtService;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.as.server.service.token.StatusListIndexService;
import io.jans.as.server.util.ServerUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class LogoutStatusJwtService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private DiscoveryService discoveryService;
    @Inject
    private StatusListIndexService statusListIndexService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ExternalLogoutStatusJwtService externalLogoutStatusJwtService;

    public LogoutStatusJwt createLogoutStatusJwt(ExecutionContext context, AuthorizationGrant grant) {
        try {
            context.initFromGrantIfNeeded(grant);
            context.generateRandomTokenReferenceId();
            Integer lifetime = this.appConfiguration.getLogoutStatusJwtLifetime();
            int lifetimeFromScript = this.externalLogoutStatusJwtService.getLifetimeInSeconds(ExternalScriptContext.of(context));
            if (lifetimeFromScript > 0) {
                lifetime = lifetimeFromScript;
                this.log.trace("Override logout_status_jwt lifetime with value from script: {}", (Object)lifetimeFromScript);
            }
            LogoutStatusJwt logoutStatusJwt = new LogoutStatusJwt(lifetime);
            logoutStatusJwt.setSessionDn(grant.getSessionDn());
            logoutStatusJwt.setX5ts256(CertUtils.confirmationMethodHashS256((String)context.getCertAsPem()));
            logoutStatusJwt.setReferenceId(context.getTokenReferenceId());
            String dpop = context.getDpop();
            if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dpop})) {
                logoutStatusJwt.setDpop(dpop);
            }
            Integer statusListIndex = null;
            if (this.errorResponseFactory.isFeatureFlagEnabled(FeatureFlagType.STATUS_LIST)) {
                statusListIndex = this.statusListIndexService.next();
                context.setStatusListIndex(statusListIndex);
                logoutStatusJwt.setStatusListIndex(statusListIndex);
            }
            if (logoutStatusJwt.getExpiresIn() < 0) {
                this.log.trace("Failed to create logout status jwt with negative expiration time");
                return null;
            }
            Client client = grant.getClient();
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
            String logoutStatusJwtSignedResponseAlg = client.getAttributes().getLogoutStatusJwtSignedResponseAlg();
            if (StringUtils.isNullOrEmpty((String)logoutStatusJwtSignedResponseAlg) && SignatureAlgorithm.fromString((String)logoutStatusJwtSignedResponseAlg) != null) {
                signatureAlgorithm = SignatureAlgorithm.fromString((String)logoutStatusJwtSignedResponseAlg);
            }
            JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
            Jwt jwt = jwtSigner.newJwt();
            String jti = this.fillPayload(jwt, statusListIndex, lifetime, grant.getSessionDn());
            logoutStatusJwt.setJti(jti);
            Audience.setAudience((JwtClaims)jwt.getClaims(), (Client)client);
            boolean externalOk = this.externalLogoutStatusJwtService.modifyLogoutStatusJwtMethod((JsonWebResponse)jwt, ExternalScriptContext.of(context));
            if (!externalOk) {
                String reason = "External LogoutStatusJwt script forbids logout_status_jwt creation.";
                this.log.trace("External LogoutStatusJwt script forbids logout_status_jwt creation.");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(ServerUtil.cacheControl(true, false)).header("Pragma", (Object)"no-cache").entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)TokenErrorResponseType.ACCESS_DENIED, "External LogoutStatusJwt script forbids logout_status_jwt creation.")).build());
            }
            String jwtString = jwtSigner.sign().toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Created Logout Status JWT: {}", (Object)(jwtString + ", claims: " + jwtSigner.getJwt().getClaims().toJsonString()));
            }
            logoutStatusJwt.setCode(jwtString);
            return logoutStatusJwt;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Failed to create Logout Status JWT", (Throwable)e);
            return null;
        }
    }

    public String fillPayload(Jwt jwt, Integer index, Integer lifetime, String sessionDn) {
        Date now = new Date();
        Calendar expirationCalendar = Calendar.getInstance();
        expirationCalendar.setTime(now);
        expirationCalendar.add(13, lifetime);
        JSONObject statusList = new JSONObject();
        statusList.put("idx", (Object)index);
        statusList.put("uri", (Object)this.discoveryService.getTokenStatusListEndpoint());
        jwt.getClaims().setExpirationTime(expirationCalendar.getTime());
        jwt.getClaims().setIat(now);
        jwt.getClaims().setNbf(now);
        String jti = UUID.randomUUID().toString();
        jwt.getClaims().setClaim("jti", jti);
        jwt.getClaims().setClaim("status_list", statusList);
        return jti;
    }
}

