/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.token;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.cluster.ClusterNodeManager;
import io.jans.as.server.service.cluster.StatusIndexPoolService;
import io.jans.model.token.StatusIndexPool;
import io.jans.model.tokenstatus.TokenStatus;
import io.jans.util.Pair;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

@ApplicationScoped
public class StatusListIndexService {
    @Inject
    private Logger log;
    @Inject
    private StatusIndexPoolService statusTokenPoolService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ClusterNodeManager clusterManager;
    private final ReentrantLock allocatedLock = new ReentrantLock();
    private StatusIndexPool tokenPool = null;

    public synchronized void updateStatusAtIndexes(List<Integer> indexes, TokenStatus status) {
        try {
            this.log.debug("Updating status list at indexes {} with status {} ...", indexes, (Object)status);
            if (indexes == null || indexes.isEmpty()) {
                return;
            }
            Collection<StatusIndexPool> pools = this.findPoolsByIndexes(indexes);
            for (StatusIndexPool pool : pools) {
                this.updateWithLockSilently(pool, indexes, status);
            }
            this.log.debug("Updated status list at index {} with status {} successfully.", indexes, (Object)status);
        }
        catch (Exception e) {
            this.log.error("Failed to update token list status at index " + indexes + " with status " + status, (Throwable)e);
        }
    }

    private Collection<StatusIndexPool> findPoolsByIndexes(List<Integer> indexes) {
        HashMap<Integer, StatusIndexPool> pools = new HashMap<Integer, StatusIndexPool>();
        for (Integer index : indexes) {
            int poolId = index / this.appConfiguration.getStatusListIndexAllocationBlockSize();
            StatusIndexPool indexHolder = (StatusIndexPool)pools.get(poolId);
            if (indexHolder != null) continue;
            indexHolder = (StatusIndexPool)this.statusTokenPoolService.getPoolByIndex(index);
            this.log.debug("Found pool {} by index {}", (Object)indexHolder.getDn(), (Object)index);
            pools.put(indexHolder.getId(), indexHolder);
        }
        return pools.values();
    }

    private void updateWithLockSilently(StatusIndexPool pool, List<Integer> indexes, TokenStatus status) {
        try {
            this.statusTokenPoolService.updateWithLock(pool.getDn(), indexes, status);
        }
        catch (Exception e) {
            this.log.error("Failed to persist status index pool " + pool.getId(), (Throwable)e);
        }
    }

    public Integer next() {
        try {
            return (Integer)this.nextIndex().getFirst();
        }
        catch (Exception e) {
            this.log.error("Failed to get next index", (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, StatusIndexPool> nextIndex() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        StatusIndexPool localTokenPool = this.tokenPool;
        int newIndex = -1;
        if (localTokenPool != null && (newIndex = localTokenPool.nextIndex()) != -1) {
            return new Pair((Object)newIndex, (Object)localTokenPool);
        }
        this.allocatedLock.lock();
        try {
            if (System.identityHashCode(localTokenPool) != System.identityHashCode(this.tokenPool) && (localTokenPool = this.tokenPool) != null && (newIndex = localTokenPool.nextIndex()) != -1) {
                Pair pair = new Pair((Object)newIndex, (Object)localTokenPool);
                return pair;
            }
            this.tokenPool = (StatusIndexPool)this.statusTokenPoolService.allocate(this.clusterManager.getClusterNodeId());
            newIndex = this.tokenPool.nextIndex();
            Pair pair = new Pair((Object)newIndex, (Object)this.tokenPool);
            return pair;
        }
        finally {
            this.allocatedLock.unlock();
        }
    }
}

