/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.servlet;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.token.TokenService;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/open-banking/v3.1/aisp/account-access-consents"}, loadOnStartup=9)
public class AccountAccessConsentServlet
extends HttpServlet {
    private static final long serialVersionUID = -8224898157373678903L;
    @Inject
    private Logger log;
    @Inject
    private TokenService tokenService;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;

    public void init() {
        this.log.info("AccountAccessConsentServlet initialized.");
    }

    protected void processRequest(HttpServletRequest servletRequest, HttpServletResponse httpResponse) {
        this.log.debug("AccountAccessConsentServlet - Starting processRequest ...");
        String authFromReq = null;
        try (PrintWriter out = httpResponse.getWriter();){
            String jsonBodyStr = IOUtils.toString((InputStream)servletRequest.getInputStream());
            JSONObject jsonBody = new JSONObject(jsonBodyStr);
            httpResponse.setContentType("application/json");
            httpResponse.addHeader("x-fapi-interaction-id", UUID.randomUUID().toString());
            httpResponse.setCharacterEncoding("UTF-8");
            JSONObject jsonObj = new JSONObject();
            String permissionKey = "";
            JSONArray permissionValue = new JSONArray();
            for (String keyStr : jsonBody.keySet()) {
                if (!keyStr.equals("data")) continue;
                JSONObject keyvalueTemp = (JSONObject)jsonBody.get(keyStr);
                for (String keyStr1 : keyvalueTemp.keySet()) {
                    Object keyvalue1 = keyvalueTemp.get(keyStr1);
                    if (keyStr1.equals("permissions")) {
                        String[] temp;
                        permissionKey = keyStr1;
                        String tempstr = keyvalue1.toString();
                        for (String s : temp = tempstr.substring(1, tempstr.length() - 1).split(",")) {
                            permissionValue.put((Object)s.substring(1, s.length() - 1));
                        }
                    }
                    if (!keyStr1.equals("expirationDateTime")) continue;
                    jsonObj.put(keyStr1, (Object)keyvalue1.toString());
                }
            }
            authFromReq = servletRequest.getHeader("Authorization");
            String clientDn = null;
            Client client = null;
            String clientID = null;
            Object consentID = null;
            clientDn = this.tokenService.getClientDn(authFromReq);
            if (StringUtils.isNotBlank((CharSequence)clientDn)) {
                client = this.clientService.getClientByDn(clientDn);
                clientID = client.getClientId();
            }
            this.log.debug("AccountAccessConsentServlet - processRequest, clientDn: {}", (Object)clientDn);
            if (clientID != null) {
                consentID = UUID.randomUUID().toString() + ":" + clientID;
            } else {
                consentID = UUID.randomUUID().toString();
                this.log.info("FAPIOBUK: ClientID is null");
            }
            jsonObj.put(this.capitalize("links"), (Object)new JSONObject().put(this.capitalize("self"), (Object)("/open-banking/v3.1/aisp/account-access-consents/" + (String)consentID)));
            JSONObject data = new JSONObject();
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            data.put(this.capitalize("creationDateTime"), timestamp.getTime());
            data.put(this.capitalize("status"), (Object)"AwaitingAuthorisation");
            data.put(permissionKey, (Object)permissionValue);
            data.put(this.capitalize("consentId"), consentID);
            data.put(this.capitalize("statusUpdateDateTime"), timestamp.getTime());
            jsonObj.put(this.capitalize("data"), (Object)data);
            out.print(jsonObj.toString());
            httpResponse.setStatus(201, "Created");
            out.flush();
            this.log.debug("AccountAccessConsentServlet - Finished processRequest.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String capitalize(String key) {
        boolean uppercase = BooleanUtils.isTrue((Boolean)this.appConfiguration.getUppercaseResponseKeysInAccountAccessConsent());
        return uppercase ? StringUtils.capitalize((String)key) : key;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "AccountAccessConsentServlet";
    }
}

