/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.session.ws.rs;

import io.jans.as.common.claims.Audience;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.server.model.token.JwrService;
import io.jans.as.server.service.SectorIdentifierService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.msgpack.core.Preconditions;
import org.slf4j.Logger;

@Stateless
@Named
public class LogoutTokenFactory {
    private static final String EVENTS_KEY = "http://schemas.openid.net/event/backchannel-logout";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private JwrService jwrService;
    @Inject
    private SectorIdentifierService sectorIdentifierService;

    public JsonWebResponse createLogoutToken(Client rpClient, String outsideSid, User user) {
        try {
            Preconditions.checkNotNull((Object)rpClient);
            JsonWebResponse jwr = this.jwrService.createJwr(rpClient);
            this.fillClaims(jwr, rpClient, outsideSid, user);
            this.jwrService.encode(jwr, rpClient);
            return jwr;
        }
        catch (Exception e) {
            this.log.error("Failed to create logout_token for client: {}", (Object)rpClient.getClientId());
            return null;
        }
    }

    private void fillClaims(JsonWebResponse jwr, Client client, String outsideSid, User user) {
        String sub;
        int lifeTime = this.appConfiguration.getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwr.getClaims().setExpirationTime(expiration);
        jwr.getClaims().setIat(issuedAt);
        jwr.getClaims().setNbf(issuedAt);
        jwr.getClaims().setIssuer(this.appConfiguration.getIssuer());
        jwr.getClaims().setJwtId(UUID.randomUUID());
        jwr.getClaims().setClaim("events", this.getLogoutTokenEvents());
        Audience.setAudience((JwtClaims)jwr.getClaims(), (Client)client);
        if (StringUtils.isNotBlank((CharSequence)outsideSid) && BooleanUtils.isTrue((Boolean)client.getAttributes().getBackchannelLogoutSessionRequired())) {
            jwr.getClaims().setClaim("sid", outsideSid);
        }
        if (StringUtils.isNotBlank((CharSequence)(sub = this.sectorIdentifierService.getSub(client, user, false)))) {
            jwr.getClaims().setSubjectIdentifier(sub);
        }
    }

    private JSONObject getLogoutTokenEvents() {
        JSONObject events = new JSONObject();
        events.put(EVENTS_KEY, (Object)new JSONObject());
        return events;
    }
}

