/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import com.google.common.base.Preconditions;
import io.jans.as.common.claims.Audience;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.uma.UmaPermission;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.token.JwtSigner;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.external.ExternalUmaRptClaimsService;
import io.jans.as.server.service.external.context.ExternalUmaRptClaimsContext;
import io.jans.as.server.service.stat.StatService;
import io.jans.as.server.uma.authorization.UmaPCT;
import io.jans.as.server.uma.authorization.UmaRPT;
import io.jans.as.server.uma.service.UmaPctService;
import io.jans.as.server.uma.service.UmaScopeService;
import io.jans.as.server.util.ServerUtil;
import io.jans.as.server.util.TokenHashUtil;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.util.INumGenerator;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class UmaRptService {
    public static final int DEFAULT_RPT_LIFETIME = 3600;
    private static final String ORGUNIT_OF_RPT = "uma_rpt";
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private UmaPctService pctService;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalUmaRptClaimsService externalUmaRptClaimsService;
    @Inject
    private StatService statService;
    private boolean containsBranch = false;

    public static List<String> getPermissionDns(Collection<io.jans.as.model.uma.persistence.UmaPermission> permissions) {
        ArrayList<String> result = new ArrayList<String>();
        if (permissions != null) {
            for (io.jans.as.model.uma.persistence.UmaPermission p : permissions) {
                result.add(p.getDn());
            }
        }
        return result;
    }

    public String createDn(String tokenCode) {
        return String.format("tknCde=%s,%s", TokenHashUtil.hash(tokenCode), this.branchDn());
    }

    public String branchDn() {
        return String.format("ou=%s,%s", ORGUNIT_OF_RPT, this.staticConfiguration.getBaseDn().getTokens());
    }

    public void persist(UmaRPT rpt) {
        try {
            Preconditions.checkNotNull((Object)rpt.getClientId());
            this.addBranchIfNeeded();
            rpt.setDn(this.createDn(rpt.getNotHashedCode()));
            rpt.setCode(TokenHashUtil.hash(rpt.getNotHashedCode()));
            this.ldapEntryManager.persist((Object)rpt);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public UmaRPT getRPTByCode(String rptCode) {
        try {
            UmaRPT entry = (UmaRPT)this.ldapEntryManager.find(UmaRPT.class, (Object)this.createDn(rptCode));
            if (entry != null) {
                return entry;
            }
            this.log.error("Failed to find RPT by code: {}", (Object)rptCode);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void deleteByCode(String rptCode) {
        try {
            UmaRPT t = this.getRPTByCode(rptCode);
            if (t != null) {
                this.ldapEntryManager.remove((Object)t);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean addPermissionToRPT(UmaRPT rpt, Collection<io.jans.as.model.uma.persistence.UmaPermission> permissions) {
        return this.addPermissionToRPT(rpt, permissions.toArray(new io.jans.as.model.uma.persistence.UmaPermission[permissions.size()]));
    }

    public boolean addPermissionToRPT(UmaRPT rpt, io.jans.as.model.uma.persistence.UmaPermission ... permission) {
        if (ArrayUtils.isEmpty((Object[])permission)) {
            return true;
        }
        List<String> permissions = UmaRptService.getPermissionDns(Arrays.asList(permission));
        if (rpt.getPermissions() != null) {
            permissions.addAll(rpt.getPermissions());
        }
        rpt.setPermissions(permissions);
        try {
            rpt.resetTtlFromExpirationDate();
            this.ldapEntryManager.merge((Object)rpt);
            this.log.trace("Persisted RPT: {}", (Object)rpt);
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List<io.jans.as.model.uma.persistence.UmaPermission> getRptPermissions(UmaRPT rpt) {
        ArrayList<io.jans.as.model.uma.persistence.UmaPermission> result = new ArrayList<io.jans.as.model.uma.persistence.UmaPermission>();
        try {
            if (rpt != null && rpt.getPermissions() != null) {
                List<String> permissionDns = rpt.getPermissions();
                for (String permissionDn : permissionDns) {
                    io.jans.as.model.uma.persistence.UmaPermission permissionObject = (io.jans.as.model.uma.persistence.UmaPermission)this.ldapEntryManager.find(io.jans.as.model.uma.persistence.UmaPermission.class, (Object)permissionDn);
                    if (permissionObject == null) continue;
                    result.add(permissionObject);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Date rptExpirationDate() {
        int lifeTime = this.appConfiguration.getUmaRptLifetime();
        if (lifeTime <= 0) {
            lifeTime = 3600;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifeTime);
        return calendar.getTime();
    }

    public UmaRPT createRPTAndPersist(ExecutionContext executionContext, List<io.jans.as.model.uma.persistence.UmaPermission> permissions) {
        try {
            Date creationDate = new Date();
            Date expirationDate = this.rptExpirationDate();
            Client client = executionContext.getClient();
            Object code = client.isRptAsJwt() ? this.createRptJwt(executionContext, permissions, creationDate, expirationDate) : UUID.randomUUID().toString() + "_" + INumGenerator.generate((int)8);
            UmaRPT rpt = new UmaRPT((String)code, creationDate, expirationDate, null, client.getClientId());
            rpt.setPermissions(UmaRptService.getPermissionDns(permissions));
            this.persist(rpt);
            this.statService.reportUmaToken(GrantType.UMA_TICKET);
            return rpt;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException("Failed to generate RPT, clientId: " + executionContext.getClient().getClientId(), e);
        }
    }

    public void merge(UmaRPT rpt) {
        rpt.resetTtlFromExpirationDate();
        this.ldapEntryManager.merge((Object)rpt);
    }

    private String createRptJwt(ExecutionContext executionContext, List<io.jans.as.model.uma.persistence.UmaPermission> permissions, Date creationDate, Date expirationDate) throws Exception {
        Client client = executionContext.getClient();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getAccessTokenSigningAlg() != null && SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg()) != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg());
        }
        JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
        Jwt jwt = jwtSigner.newJwt();
        jwt.getClaims().setClaim("client_id", client.getClientId());
        jwt.getClaims().setExpirationTime(expirationDate);
        jwt.getClaims().setIat(creationDate);
        jwt.getClaims().setNbf(creationDate);
        Audience.setAudience((JwtClaims)jwt.getClaims(), (Client)client);
        if (permissions != null && !permissions.isEmpty()) {
            String pctCode = (String)permissions.iterator().next().getAttributes().get("pct");
            if (StringHelper.isNotEmpty((String)pctCode)) {
                UmaPCT pct = this.pctService.getByCode(pctCode);
                if (pct != null) {
                    jwt.getClaims().setClaim("pct_claims", pct.getClaims().toJsonObject());
                } else {
                    this.log.error("Failed to find PCT with code: {} which is taken from permission object: {}", (Object)pctCode, (Object)permissions.iterator().next().getDn());
                }
            }
            jwt.getClaims().setClaim("permissions", this.buildPermissionsJSONObject(permissions));
        }
        this.runScriptAndInjectValuesIntoJwt(jwt, executionContext);
        return jwtSigner.sign().toString();
    }

    private void runScriptAndInjectValuesIntoJwt(Jwt jwt, ExecutionContext executionContext) {
        JSONObject responseAsJsonObject = new JSONObject();
        ExternalUmaRptClaimsContext context = new ExternalUmaRptClaimsContext(executionContext);
        if (this.externalUmaRptClaimsService.externalModify(responseAsJsonObject, context)) {
            this.log.trace("Successfully run external RPT Claim scripts.");
            if (context.isTranferPropertiesIntoJwtClaims()) {
                this.log.trace("Transfering claims into jwt ...");
                JwtUtil.transferIntoJwtClaims((JSONObject)responseAsJsonObject, (Jwt)jwt);
                this.log.trace("Transfered.");
            }
        }
    }

    public JSONArray buildPermissionsJSONObject(List<io.jans.as.model.uma.persistence.UmaPermission> permissions) throws IOException, JSONException {
        ArrayList<UmaPermission> result = new ArrayList<UmaPermission>();
        for (io.jans.as.model.uma.persistence.UmaPermission permission : permissions) {
            permission.checkExpired();
            permission.isValid();
            if (permission.isValid()) {
                UmaPermission toAdd = ServerUtil.convert(permission, this.umaScopeService);
                if (toAdd == null) continue;
                result.add(toAdd);
                continue;
            }
            this.log.debug("Ignore permission, skip it in response because permission is not valid. Permission dn: {}", (Object)permission.getDn());
        }
        String json = ServerUtil.asJson(result);
        return new JSONArray(json);
    }

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ORGUNIT_OF_RPT);
        branch.setDn(this.branchDn());
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addBranchIfNeeded() {
        if (this.ldapEntryManager.hasBranchesSupport(this.branchDn())) {
            if (!this.containsBranch() && !this.containsBranch) {
                this.addBranch();
            } else {
                this.containsBranch = true;
            }
        }
    }

    public boolean containsBranch() {
        return this.ldapEntryManager.contains(this.branchDn(), SimpleBranch.class);
    }
}

