/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.common.InumService;
import io.jans.as.model.common.CreatorType;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.service.SpontaneousScopeService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named(value="umaScopeService")
public class UmaScopeService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private InumService inumService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private SpontaneousScopeService spontaneousScopeService;

    public static String asString(Collection<Scope> scopes) {
        StringBuilder result = new StringBuilder();
        for (Scope scope : scopes) {
            result.append(scope.getId()).append(" ");
        }
        return result.toString().trim();
    }

    public Scope getOrCreate(Client client, String scopeId, Set<String> regExps) {
        Scope fromLdap = this.getScope(scopeId);
        if (fromLdap != null) {
            return fromLdap;
        }
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getAllowSpontaneousScopes())) {
            return null;
        }
        if (BooleanUtils.isFalse((Boolean)client.getAttributes().getAllowSpontaneousScopes())) {
            return null;
        }
        if (!this.spontaneousScopeService.isAllowedBySpontaneousScopeRegExps(regExps, scopeId)) {
            return null;
        }
        return this.spontaneousScopeService.createSpontaneousScopeIfNeeded(regExps, scopeId, client.getClientId());
    }

    public Scope getScope(String scopeId) {
        try {
            Filter filter = Filter.createEqualityFilter((String)"jansId", (Object)scopeId);
            List entries = this.ldapEntryManager.findEntries(this.baseDn(), Scope.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error("Found more then one UMA scope, id: {}", (Object)scopeId);
                    for (Scope s : entries) {
                        this.log.error("Scope, Id: {}, dn: {}", (Object)s.getId(), (Object)s.getDn());
                    }
                }
                return (Scope)entries.get(0);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean persist(Scope scope) {
        try {
            if (StringUtils.isBlank((CharSequence)scope.getDn())) {
                scope.setDn(String.format("inum=%s,%s", scope.getInum(), this.baseDn()));
            }
            this.ldapEntryManager.persist((Object)scope);
            return true;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List<String> getScopeDNsByIdsAndAddToPersistenceIfNeeded(List<String> scopeIds) {
        ArrayList<String> result = new ArrayList<String>();
        for (Scope scope : this.getScopesByIds(scopeIds)) {
            result.add(scope.getDn());
        }
        return result;
    }

    public List<Scope> getScopesByDns(List<String> scopeDns) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        try {
            if (scopeDns != null && !scopeDns.isEmpty()) {
                for (String dn : scopeDns) {
                    Scope scopeDescription = (Scope)this.ldapEntryManager.find(Scope.class, (Object)dn);
                    if (scopeDescription != null) {
                        result.add(scopeDescription);
                        continue;
                    }
                    this.log.error("Failed to load UMA scope with dn: {}", (Object)dn);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<String> getScopeIdsByDns(List<String> scopeDns) {
        return this.getScopeIds(this.getScopesByDns(scopeDns));
    }

    public List<String> getScopeIds(List<Scope> scopes) {
        ArrayList<String> result = new ArrayList<String>();
        if (scopes != null && !scopes.isEmpty()) {
            for (Scope scope : scopes) {
                result.add(scope.getId());
            }
        }
        return result;
    }

    public List<Scope> getScopesByIds(List<String> scopeIds) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        if (scopeIds != null && !scopeIds.isEmpty()) {
            ArrayList<String> notInLdap = new ArrayList<String>(scopeIds);
            List entries = this.ldapEntryManager.findEntries(this.baseDn(), Scope.class, this.createAnyFilterByIds(scopeIds));
            if (entries != null) {
                result.addAll(entries);
                for (Scope scope : entries) {
                    notInLdap.remove(scope.getId());
                }
            }
            if (!notInLdap.isEmpty()) {
                for (String scopeId : notInLdap) {
                    result.add(this.addScope(scopeId));
                }
            }
        }
        return result;
    }

    private Scope addScope(String scopeId) {
        Boolean addAutomatically = this.appConfiguration.getUmaAddScopesAutomatically();
        if (addAutomatically != null && addAutomatically.booleanValue()) {
            String inum = this.inumService.generateInum();
            Scope newScope = new Scope();
            newScope.setScopeType(ScopeType.UMA);
            newScope.setInum(inum);
            newScope.setDisplayName(scopeId);
            newScope.setId(scopeId);
            newScope.setDeletable(Boolean.valueOf(false));
            newScope.setCreatorType(CreatorType.AUTO);
            boolean persisted = this.persist(newScope);
            if (persisted) {
                return newScope;
            }
            this.log.error("Failed to persist scope, id: {}", (Object)scopeId);
        }
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_SCOPE, "Failed to persist scope.");
    }

    private Filter createAnyFilterByIds(List<String> scopeIds) {
        if (scopeIds != null && !scopeIds.isEmpty()) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (String url : scopeIds) {
                Filter filter = Filter.createEqualityFilter((String)"jansId", (Object)url);
                filters.add(filter);
            }
            Filter filter = Filter.createORFilter((Filter[])filters.toArray(new Filter[0]));
            this.log.trace("Uma scope ids: {}, ldapFilter: {}", scopeIds, (Object)filter);
            return filter;
        }
        return null;
    }

    public String baseDn() {
        return this.staticConfiguration.getBaseDn().getScopes();
    }
}

