/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.ws.rs;

import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.uma.UmaScopeDescription;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.uma.service.UmaScopeService;
import io.jans.as.server.util.ServerUtil;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/uma/scopes")
public class UmaScopeWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaScopeService umaScopeService;

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getScopeDescription(@PathParam(value="id") String id) {
        this.log.trace("UMA - get scope description: id: {}", (Object)id);
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.UMA);
        try {
            Scope scope;
            if (StringUtils.isNotBlank((CharSequence)id) && (scope = this.umaScopeService.getScope(id)) != null) {
                UmaScopeDescription jsonScope = new UmaScopeDescription();
                jsonScope.setIconUri(scope.getIconUrl());
                jsonScope.setName(scope.getId());
                jsonScope.setDescription(scope.getDescription());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)ServerUtil.asJson(jsonScope)).build();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Internal error.");
        }
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.NOT_FOUND, (IErrorType)UmaErrorResponseType.NOT_FOUND, "Not found.");
    }
}

