/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ws.rs.stat;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Months {
    private static final Logger log = LoggerFactory.getLogger(Months.class);
    public static final DateTimeFormatter YYYYMMDD = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter YYYYMM = DateTimeFormatter.ofPattern("yyyyMM");

    private Months() {
    }

    public static boolean isValid(String months, String startMonth, String endMonth) {
        boolean hasRange;
        boolean hasMonths = StringUtils.isNotBlank((CharSequence)months);
        boolean bl = hasRange = StringUtils.isNotBlank((CharSequence)startMonth) && StringUtils.isNotBlank((CharSequence)endMonth);
        if (hasMonths && hasRange) {
            return false;
        }
        return hasMonths || hasRange;
    }

    public static Set<String> getMonths(String months, String startMonth, String endMonth) {
        if (!Months.isValid(months, startMonth, endMonth)) {
            return new LinkedHashSet<String>();
        }
        boolean hasMonths = StringUtils.isNotBlank((CharSequence)months);
        if (hasMonths) {
            return Months.getMonths(months);
        }
        return Months.getMonths(startMonth, endMonth);
    }

    public static LocalDate parse(String month) {
        return LocalDate.parse(month + "01", YYYYMMDD).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static Set<String> getMonths(String startMonth, String endMonth) {
        LinkedHashSet<String> monthList = new LinkedHashSet<String>();
        if (!Months.checkMonthFormat(startMonth) || !Months.checkMonthFormat(endMonth)) {
            return monthList;
        }
        LocalDate start = Months.parse(startMonth);
        LocalDate end = Months.parse(endMonth);
        LocalDate date = start;
        while (date.isBefore(end)) {
            monthList.add(date.format(YYYYMM));
            date = date.plusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        }
        if (!monthList.isEmpty()) {
            monthList.add(date.format(YYYYMM));
        }
        return monthList;
    }

    public static boolean checkMonthFormat(String month) {
        if (month.length() == 6) {
            return true;
        }
        log.error("Invalid month `{}`, month must be 6 chars length in format yyyyMM, e.g. 202212", (Object)month);
        return false;
    }

    public static Set<String> getMonths(String months) {
        LinkedHashSet<String> monthList = new LinkedHashSet<String>();
        if (StringUtils.isBlank((CharSequence)months)) {
            return monthList;
        }
        for (String m : months.split(" ")) {
            if (!Months.checkMonthFormat(m = m.trim())) continue;
            monthList.add(m);
        }
        return monthList;
    }
}

