/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.audit.debug;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.audit.debug.entity.HttpRequest;
import io.jans.as.server.audit.debug.entity.HttpResponse;
import io.jans.as.server.audit.debug.wrapper.LogResponseWrapper;
import io.jans.as.server.audit.debug.wrapper.RequestWrapper;
import io.jans.as.server.audit.debug.wrapper.ResponseWrapper;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

@WebFilter(filterName="ServletLoggingFilter", urlPatterns={"/*"})
public class ServletLoggingFilter
implements Filter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Instant start = this.now();
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("LoggingFilter just supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!BooleanUtils.toBoolean((Boolean)this.appConfiguration.getHttpLoggingEnabled())) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        Set excludedPaths = this.appConfiguration.getHttpLoggingExcludePaths();
        if (!CollectionUtils.isEmpty((Collection)excludedPaths)) {
            for (String excludedPath : excludedPaths) {
                String requestURI = httpRequest.getRequestURI();
                if (!requestURI.startsWith(excludedPath)) continue;
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
        }
        RequestWrapper requestWrapper = new RequestWrapper(httpRequest);
        ResponseWrapper responseWrapper = null;
        responseWrapper = this.log.isDebugEnabled() && this.appConfiguration.getHttpLoggingResponseBodyContent() != false ? new LogResponseWrapper((HttpServletResponse)response) : new ResponseWrapper(httpResponse);
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)responseWrapper);
        Duration duration = this.duration(start);
        if (this.log.isDebugEnabled()) {
            String strDebugLog = "\nREQUEST: " + this.getRequestDescription(requestWrapper, duration);
            strDebugLog = strDebugLog + "\nRESPONSE: " + this.getResponseDescription(responseWrapper);
            if (this.appConfiguration.getHttpLoggingResponseBodyContent().booleanValue()) {
                strDebugLog = strDebugLog + "\nRESPONSE BODY: " + ((LogResponseWrapper)responseWrapper).getBodyCopy();
            }
            this.log.debug(strDebugLog);
        }
    }

    public void destroy() {
    }

    protected String getRequestDescription(RequestWrapper requestWrapper, Duration duration) {
        try {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setSenderIP(requestWrapper.getLocalAddr());
            httpRequest.setMethod(requestWrapper.getMethod());
            httpRequest.setPath(requestWrapper.getRequestURI());
            httpRequest.setParams(requestWrapper.isFormPost() ? null : requestWrapper.getParameters());
            httpRequest.setHeaders(requestWrapper.getHeaders());
            httpRequest.setBody(requestWrapper.getContent());
            httpRequest.setDuration(duration.toString());
            return OBJECT_MAPPER.writeValueAsString((Object)httpRequest);
        }
        catch (Exception e) {
            this.log.warn("Cannot serialize Request to JSON", (Throwable)e);
            return null;
        }
    }

    protected String getResponseDescription(HttpServletResponseWrapper responseWrapper) {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(responseWrapper.getStatus());
        httpResponse.setHeaders(((ResponseWrapper)responseWrapper).getHeaders());
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)httpResponse);
        }
        catch (JsonProcessingException e) {
            this.log.warn("Cannot serialize Response to JSON", (Throwable)e);
            return null;
        }
    }

    public Instant now() {
        return Instant.now();
    }

    public Duration duration(Instant start) {
        Instant end = Instant.now();
        return Duration.between(start, end);
    }

    public Duration duration(Instant start, Instant end) {
        return Duration.between(start, end);
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

