/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.auth;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.model.ciba.BackchannelAuthenticationErrorResponseType;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.ExchangeTokenType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.SubjectTokenType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.token.ClientAssertionType;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.model.util.Util;
import io.jans.as.server.auth.Authenticator;
import io.jans.as.server.auth.DpopService;
import io.jans.as.server.auth.MTLSService;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AuthorizationCodeGrant;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.token.ClientAssertion;
import io.jans.as.server.model.token.HttpAuthTokenType;
import io.jans.as.server.service.ClientFilterService;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.GrantService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalClientAuthnService;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.token.ws.rs.TxTokenValidator;
import io.jans.as.server.util.ServerUtil;
import io.jans.as.server.util.TokenHashUtil;
import io.jans.model.security.Identity;
import io.jans.model.token.TokenEntity;
import io.jans.service.CacheService;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@WebFilter(filterName="AuthenticationFilter", asyncSupported=true, urlPatterns={"/restv1/authorize", "/restv1/token", "/restv1/userinfo", "/restv1/revoke", "/restv1/revoke_session", "/restv1/global-token-revocation", "/restv1/bc-authorize", "/restv1/par", "/restv1/device_authorization", "/restv1/register", "/restv1/ssa", "/restv1/ssa/jwt"}, displayName="oxAuth")
public class AuthenticationFilter
implements Filter {
    private static final String REALM_CONSTANT = "jans-auth";
    @Inject
    private Logger log;
    @Inject
    private Authenticator authenticator;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ClientService clientService;
    @Inject
    private ClientFilterService clientFilterService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Identity identity;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private MTLSService mtlsService;
    @Inject
    private TokenService tokenService;
    @Inject
    private CacheService cacheService;
    @Inject
    private GrantService grantService;
    @Inject
    private DpopService dPoPService;
    @Inject
    private TxTokenValidator txTokenValidator;
    @Inject
    private ExternalClientAuthnService externalClientAuthnService;
    private String realm;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        try {
            String requestUrl = httpRequest.getRequestURL().toString();
            this.log.trace("Get request to: '{}'", (Object)requestUrl);
            String method = httpRequest.getMethod();
            if (this.appConfiguration.isSkipAuthenticationFilterOptionsMethod().booleanValue() && "OPTIONS".equals(method)) {
                this.log.trace("Ignoring '{}' request to to: '{}'", (Object)method, (Object)requestUrl);
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            Client client = this.externalClientAuthnService.externalAuthenticateClient(httpRequest, httpResponse);
            if (client != null) {
                this.log.debug("Client {} is authenticated by external script.", (Object)client.getClientId());
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            boolean tokenEndpoint = requestUrl.endsWith("/token");
            boolean tokenRevocationEndpoint = requestUrl.endsWith("/revoke");
            boolean backchannelAuthenticationEnpoint = requestUrl.endsWith("/bc-authorize");
            boolean deviceAuthorizationEndpoint = requestUrl.endsWith("/device_authorization");
            boolean revokeSessionEndpoint = requestUrl.endsWith("/revoke_session");
            boolean globalTokenRevocationEndpoint = requestUrl.endsWith("/global-token-revocation");
            boolean isParEndpoint = requestUrl.endsWith("/par");
            boolean ssaEndpoint = requestUrl.endsWith("/ssa") && Arrays.asList("POST", "GET", "DELETE").contains(httpRequest.getMethod());
            boolean ssaJwtEndpoint = requestUrl.endsWith("/ssa/jwt") && httpRequest.getMethod().equals("GET");
            String authorizationHeader = httpRequest.getHeader("Authorization");
            String dpopHeader = httpRequest.getHeader("DPoP");
            if (this.processMTLS(httpRequest, httpResponse, filterChain)) {
                return;
            }
            if ((tokenRevocationEndpoint || deviceAuthorizationEndpoint || isParEndpoint) && this.clientService.isPublic(httpRequest.getParameter("client_id"))) {
                this.log.trace("Skipped authentication for {} for public client.", (Object)requestUrl);
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            if (tokenEndpoint || revokeSessionEndpoint || tokenRevocationEndpoint || deviceAuthorizationEndpoint || isParEndpoint || ssaEndpoint || ssaJwtEndpoint || globalTokenRevocationEndpoint) {
                this.log.debug("Starting endpoint authentication {}", (Object)requestUrl);
                String accessToken = this.tokenService.getToken(authorizationHeader, HttpAuthTokenType.Bearer, HttpAuthTokenType.AccessToken);
                if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                    this.processAuthByAccessToken(accessToken, httpRequest, httpResponse, filterChain);
                    return;
                }
                String requestedTokenType = httpRequest.getParameter("requested_token_type");
                if (ExchangeTokenType.fromString((String)requestedTokenType) == ExchangeTokenType.TX_TOKEN) {
                    this.processTxToken(httpRequest, httpResponse, filterChain);
                    return;
                }
                if (httpRequest.getParameter("client_assertion") != null && httpRequest.getParameter("client_assertion_type") != null) {
                    this.log.debug("Starting JWT token endpoint authentication");
                    this.processJwtAuth(httpRequest, httpResponse, filterChain);
                } else if (this.tokenService.isBasicAuthToken(authorizationHeader)) {
                    this.log.debug("Starting Basic Auth token endpoint authentication");
                    this.processBasicAuth(httpRequest, httpResponse, filterChain);
                } else if (tokenEndpoint && StringUtils.isNotBlank((CharSequence)dpopHeader)) {
                    this.processDPoP(httpRequest, httpResponse, filterChain);
                } else {
                    this.log.debug("Starting POST Auth token endpoint authentication");
                    this.processPostAuth(this.clientFilterService, httpRequest, httpResponse, filterChain, tokenEndpoint);
                }
            } else if (backchannelAuthenticationEnpoint) {
                if (httpRequest.getParameter("client_assertion") != null && httpRequest.getParameter("client_assertion_type") != null) {
                    this.log.debug("Starting JWT token endpoint authentication");
                    this.processJwtAuth(httpRequest, httpResponse, filterChain);
                } else if (this.tokenService.isBasicAuthToken(authorizationHeader)) {
                    this.processBasicAuth(httpRequest, httpResponse, filterChain);
                } else {
                    String entity = this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST);
                    httpResponse.setStatus(400);
                    httpResponse.addHeader("WWW-Authenticate", this.getRealmHeaderValue());
                    httpResponse.setContentType(ContentType.APPLICATION_JSON.toString());
                    httpResponse.setHeader("Content-Length", String.valueOf(entity.length()));
                    PrintWriter out = httpResponse.getWriter();
                    out.print(entity);
                    out.flush();
                }
            } else if (authorizationHeader != null && !this.tokenService.isNegotiateAuthToken(authorizationHeader)) {
                if (this.tokenService.isBearerAuthToken(authorizationHeader)) {
                    this.processBearerAuth(httpRequest, httpResponse, filterChain);
                } else if (this.tokenService.isBasicAuthToken(authorizationHeader)) {
                    this.processBasicAuth(httpRequest, httpResponse, filterChain);
                } else {
                    httpResponse.addHeader("WWW-Authenticate", this.getRealmHeaderValue());
                    httpResponse.sendError(401, "Not authorized");
                }
            } else {
                String sessionId = this.cookieService.getSessionIdFromCookie(httpRequest);
                List prompts = Prompt.fromString((String)httpRequest.getParameter("prompt"), (String)" ");
                if (StringUtils.isBlank((CharSequence)sessionId) && BooleanUtils.isTrue((Boolean)this.appConfiguration.getSessionIdRequestParameterEnabled())) {
                    sessionId = httpRequest.getParameter("session_id");
                }
                SessionId sessionIdObject = null;
                if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                    sessionIdObject = this.sessionIdService.getSessionId(sessionId);
                }
                if (sessionIdObject != null && SessionIdState.AUTHENTICATED == sessionIdObject.getState() && !prompts.contains(Prompt.LOGIN)) {
                    this.processSessionAuth(sessionId, httpRequest, httpResponse, filterChain);
                } else {
                    filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            }
        }
        catch (WebApplicationException ex) {
            this.log.trace(ex.getMessage(), (Throwable)ex);
            if (ex.getResponse() != null) {
                this.sendResponse(httpResponse, ex);
                return;
            }
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void processTxToken(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) {
        try {
            OAuth2AuditLog auditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.TOKEN_REQUEST);
            auditLog.setUsername("tx_token");
            String subjectToken = httpRequest.getParameter("subject_token");
            String subjectTokenType = httpRequest.getParameter("subject_token_type");
            SubjectTokenType subjectTokenTypeEnum = this.txTokenValidator.validateSubjectTokenType(subjectTokenType, auditLog);
            AuthorizationGrant subjectGrant = this.txTokenValidator.validateSubjectToken(subjectToken, subjectTokenTypeEnum, auditLog);
            Client client = subjectGrant.getClient();
            if (client != null) {
                this.authenticator.configureSessionClient(client);
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            this.log.error("Client is not set for grant {}", (Object)subjectGrant.getGrantId());
        }
        catch (Exception ex) {
            this.log.error("Failed to authenticate client by subject_token (Transaction Tokens)", (Throwable)ex);
        }
        this.sendError(httpResponse);
    }

    @NotNull
    public String getRealmHeaderValue() {
        return String.format("Basic realm=\"%s\"", this.getRealm());
    }

    private boolean processMTLS(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws Exception {
        if (this.cryptoProvider == null) {
            this.log.debug("Unable to create cryptoProvider.");
            return false;
        }
        String clientId = httpRequest.getParameter("client_id");
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            Client client = this.clientService.getClient(clientId);
            if (client != null && (client.hasAuthenticationMethod(AuthenticationMethod.TLS_CLIENT_AUTH) || client.hasAuthenticationMethod(AuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH))) {
                return this.mtlsService.processMTLS(httpRequest, httpResponse, filterChain, client);
            }
        } else {
            String requestUrl = httpRequest.getRequestURL().toString();
            boolean isRegisterEndpoint = requestUrl.endsWith("/register");
            boolean isRegistration = "POST".equalsIgnoreCase(httpRequest.getMethod());
            if (this.appConfiguration.getDcrAuthorizationWithMTLS().booleanValue() && isRegistration && isRegisterEndpoint) {
                return this.mtlsService.processRegisterMTLS(httpRequest);
            }
        }
        return false;
    }

    private void processAuthByAccessToken(String accessToken, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) {
        try {
            this.log.trace("Authenticating client by access token {} ...", (Object)accessToken);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                this.sendError(httpResponse);
                return;
            }
            AuthorizationGrant grant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
            if (grant == null) {
                this.sendError(httpResponse);
                return;
            }
            AbstractToken accessTokenObj = grant.getAccessToken(accessToken);
            if (accessTokenObj == null || !accessTokenObj.isValid()) {
                this.sendError(httpResponse);
                return;
            }
            Client client = grant.getClient();
            this.authenticator.configureSessionClient(client);
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        catch (Exception ex) {
            this.log.error("Failed to authenticate client by access_token", (Throwable)ex);
            this.sendError(httpResponse);
            return;
        }
    }

    private void processSessionAuth(String sessionId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) {
        boolean requireAuth;
        boolean bl = requireAuth = !this.authenticator.authenticateBySessionId(sessionId);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Process Session Auth, sessionId = {}, requireAuth = {}", (Object)Util.escapeLog((Object)sessionId), (Object)requireAuth);
        }
        if (!requireAuth) {
            try {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (Exception ex) {
                this.log.error("Failed to process session authentication", (Throwable)ex);
                requireAuth = true;
            }
        }
        if (requireAuth) {
            this.sendError(httpResponse);
        }
    }

    private void processBasicAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        boolean requireAuth = true;
        try {
            String header = servletRequest.getHeader("Authorization");
            if (this.tokenService.isBasicAuthToken(header)) {
                String base64Token = this.tokenService.getBasicToken(header);
                String token = new String(Base64.decodeBase64((String)base64Token), StandardCharsets.UTF_8);
                String username = "";
                String password = "";
                int delim = token.indexOf(":");
                if (delim != -1) {
                    username = URLDecoder.decode(token.substring(0, delim), "UTF-8");
                    password = URLDecoder.decode(token.substring(delim + 1), "UTF-8");
                }
                boolean bl = requireAuth = !StringHelper.equals((String)username, (String)this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn();
                if (requireAuth && !username.equals(this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn()) {
                    this.identity.getCredentials().setUsername(username);
                    this.identity.getCredentials().setPassword(password);
                    if (servletRequest.getRequestURI().endsWith("/token") || servletRequest.getRequestURI().endsWith("/revoke") || servletRequest.getRequestURI().endsWith("/revoke_session") || servletRequest.getRequestURI().endsWith("/global-token-revocation") || servletRequest.getRequestURI().endsWith("/userinfo") || servletRequest.getRequestURI().endsWith("/bc-authorize") || servletRequest.getRequestURI().endsWith("/par") || servletRequest.getRequestURI().endsWith("/device_authorization")) {
                        Client client = this.clientService.getClient(username);
                        if (client == null || !client.hasAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC)) {
                            throw new Exception("The Token Authentication Method is not valid.");
                        }
                        requireAuth = !this.authenticator.authenticateClient(servletRequest);
                    } else {
                        boolean bl2 = requireAuth = !this.authenticator.authenticateUser(servletRequest);
                    }
                }
            }
            if (!requireAuth) {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                return;
            }
        }
        catch (Exception ex) {
            this.log.info("Basic authentication failed", (Throwable)ex);
        }
        if (requireAuth && !this.identity.isLoggedIn()) {
            this.sendError(servletResponse);
        }
    }

    private void processBearerAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        try {
            String header = servletRequest.getHeader("Authorization");
            if (this.tokenService.isBearerAuthToken(header)) {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
        }
        catch (Exception ex) {
            this.log.info("Bearer authorization failed.", (Throwable)ex);
        }
    }

    private void processPostAuth(ClientFilterService clientFilterService, HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain, boolean tokenEndpoint) {
        try {
            String clientId = "";
            String clientSecret = "";
            boolean isExistUserPassword = false;
            if (StringHelper.isNotEmpty((String)servletRequest.getParameter("client_id")) && StringHelper.isNotEmpty((String)servletRequest.getParameter("client_secret"))) {
                clientId = servletRequest.getParameter("client_id");
                clientSecret = servletRequest.getParameter("client_secret");
                isExistUserPassword = true;
            }
            this.log.trace("isExistUserPassword: {}", (Object)isExistUserPassword);
            boolean requireAuth = !StringHelper.equals((String)clientId, (String)this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn();
            this.log.debug("requireAuth: '{}'", (Object)requireAuth);
            if (requireAuth) {
                Client client;
                if (isExistUserPassword) {
                    Client client2 = this.clientService.getClient(clientId);
                    if (client2 != null && client2.hasAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST)) {
                        if (!clientId.equals(this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn()) {
                            this.identity.logout();
                            this.identity.getCredentials().setUsername(clientId);
                            this.identity.getCredentials().setPassword(clientSecret);
                            requireAuth = !this.authenticator.authenticateClient(servletRequest);
                        } else {
                            this.authenticator.configureSessionClient(client2);
                        }
                    }
                } else if (Boolean.TRUE.equals(this.appConfiguration.getClientAuthenticationFiltersEnabled())) {
                    String clientDn = clientFilterService.processAuthenticationFilters(servletRequest.getParameterMap());
                    if (clientDn != null) {
                        Client client3 = this.clientService.getClientByDn(clientDn);
                        this.identity.logout();
                        this.identity.getCredentials().setUsername(client3.getClientId());
                        this.identity.getCredentials().setPassword(null);
                        requireAuth = !this.authenticator.authenticateClient(servletRequest, true);
                    }
                } else if (tokenEndpoint && (client = this.clientService.getClient(servletRequest.getParameter("client_id"))) != null && client.hasAuthenticationMethod(AuthenticationMethod.NONE)) {
                    this.identity.logout();
                    this.identity.getCredentials().setUsername(client.getClientId());
                    this.identity.getCredentials().setPassword(null);
                    boolean bl = requireAuth = !this.authenticator.authenticateClient(servletRequest, true);
                }
            }
            if (!requireAuth) {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                return;
            }
            if (!this.identity.isLoggedIn()) {
                this.sendError(servletResponse);
            }
        }
        catch (Exception ex) {
            this.log.error("Post authentication failed.", (Throwable)ex);
        }
    }

    private void processJwtAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        boolean authorized = false;
        try {
            if (servletRequest.getParameter("client_assertion") != null && servletRequest.getParameter("client_assertion_type") != null) {
                String clientId = servletRequest.getParameter("client_id");
                ClientAssertionType clientAssertionType = ClientAssertionType.fromString((String)servletRequest.getParameter("client_assertion_type"));
                String encodedAssertion = servletRequest.getParameter("client_assertion");
                if (clientAssertionType == ClientAssertionType.JWT_BEARER) {
                    ClientAssertion clientAssertion = new ClientAssertion(this.appConfiguration, this.cryptoProvider, clientId, clientAssertionType, encodedAssertion);
                    clientAssertion.initAndVerify();
                    String username = clientAssertion.getSubjectIdentifier();
                    String password = clientAssertion.getClientSecret();
                    if (!username.equals(this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn()) {
                        this.identity.getCredentials().setUsername(username);
                        this.identity.getCredentials().setPassword(password);
                        this.authenticator.authenticateClient(servletRequest, true);
                        authorized = true;
                    }
                }
            }
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (InvalidJwtException | ServletException | IOException ex) {
            this.log.info("JWT authentication failed.", ex);
        }
        if (!authorized) {
            this.sendError(servletResponse);
        }
    }

    private void processDPoP(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        boolean validDPoPProof = false;
        boolean authorized = false;
        String errorReason = null;
        try {
            this.dPoPService.validateDpopValuesCount(servletRequest);
            String dpopStr = servletRequest.getHeader("DPoP");
            validDPoPProof = this.dPoPService.validateDpop(dpopStr);
            GrantType grantType = GrantType.fromString((String)servletRequest.getParameter("grant_type"));
            if (grantType == GrantType.AUTHORIZATION_CODE) {
                String code = servletRequest.getParameter("code");
                AuthorizationCodeGrant authorizationCodeGrant = this.authorizationGrantList.getAuthorizationCodeGrant(code);
                this.identity.logout();
                this.identity.getCredentials().setUsername(authorizationCodeGrant.getClient().getClientId());
                this.identity.getCredentials().setPassword(null);
                authorized = this.authenticator.authenticateClient(servletRequest, true);
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            } else if (grantType == GrantType.REFRESH_TOKEN) {
                String refreshTokenCode = servletRequest.getParameter("refresh_token");
                TokenEntity tokenEntity = !BooleanUtils.isTrue((Boolean)this.appConfiguration.getPersistRefreshToken()) ? (TokenEntity)this.cacheService.get(TokenHashUtil.hash(refreshTokenCode)) : this.grantService.getGrantByCode(refreshTokenCode);
                String dpopJwkThumbprint = DpopService.getDpopJwkThumbprint(dpopStr);
                if (!dpopJwkThumbprint.equals(tokenEntity.getDpop())) {
                    throw new InvalidJwtException("Invalid DPoP Proof Header. The jwk header is not valid.");
                }
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByRefreshToken(tokenEntity.getClientId(), refreshTokenCode);
                this.identity.logout();
                this.identity.getCredentials().setUsername(authorizationGrant.getClient().getClientId());
                this.identity.getCredentials().setPassword(null);
                authorized = this.authenticator.authenticateClient(servletRequest, true);
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.error("Invalid DPoP.", (Throwable)ex);
            errorReason = ex.getMessage();
        }
        if (!validDPoPProof) {
            this.sendInvalidDPoPError(servletResponse, errorReason);
        }
        if (!authorized) {
            this.sendError(servletResponse);
        }
    }

    private void sendInvalidDPoPError(HttpServletResponse servletResponse, String reason) {
        try (PrintWriter out = servletResponse.getWriter();){
            servletResponse.setStatus(400);
            servletResponse.setContentType("application/json;charset=UTF-8");
            out.write(this.errorResponseFactory.errorAsJson((IErrorType)TokenErrorResponseType.INVALID_DPOP_PROOF, reason));
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void sendError(HttpServletResponse servletResponse) {
        try (PrintWriter out = servletResponse.getWriter();){
            servletResponse.setStatus(401);
            servletResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            servletResponse.setContentType("application/json;charset=UTF-8");
            out.write(this.errorResponseFactory.errorAsJson((IErrorType)TokenErrorResponseType.INVALID_CLIENT, "Unable to authenticate client."));
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void sendResponse(HttpServletResponse servletResponse, WebApplicationException e) {
        try (PrintWriter out = servletResponse.getWriter();){
            servletResponse.setStatus(e.getResponse().getStatus());
            servletResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            servletResponse.setContentType("application/json;charset=UTF-8");
            out.write(e.getResponse().getEntity().toString());
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        return REALM_CONSTANT;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void destroy() {
    }
}

