/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ciba;

import io.jans.as.client.BaseRequest;
import io.jans.as.client.ciba.ping.PingCallbackClient;
import io.jans.as.client.ciba.ping.PingCallbackRequest;
import io.jans.as.client.ciba.ping.PingCallbackResponse;
import io.jans.as.model.configuration.AppConfiguration;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBAPingCallbackService {
    private static final Logger log = LoggerFactory.getLogger(CIBAPingCallbackService.class);
    @Inject
    private AppConfiguration appConfiguration;

    public void pingCallback(String authReqId, String clientNotificationEndpoint, String clientNotificationToken) {
        PingCallbackRequest pingCallbackRequest = new PingCallbackRequest();
        pingCallbackRequest.setClientNotificationToken(clientNotificationToken);
        pingCallbackRequest.setAuthReqId(authReqId);
        PingCallbackClient pingCallbackClient = new PingCallbackClient(clientNotificationEndpoint, this.appConfiguration.isFapi());
        pingCallbackClient.setRequest((BaseRequest)pingCallbackRequest);
        PingCallbackResponse pingCallbackResponse = pingCallbackClient.exec();
        log.debug("CIBA: ping callback result status {}", (Object)pingCallbackResponse.getStatus());
    }
}

