/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.crypto.cert;

import io.jans.util.security.SecurityProviderUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;

public class CertificateParser {
    public static X509Certificate parsePem(String pemEncodedCert) throws CertificateException {
        StringReader sr = new StringReader(pemEncodedCert);
        PEMParser pemReader = new PEMParser((Reader)sr);
        try {
            X509CertificateHolder certificateHolder = (X509CertificateHolder)pemReader.readObject();
            if (certificateHolder == null) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(SecurityProviderUtility.getBCProviderName()).getCertificate(certificateHolder);
            return x509Certificate;
        }
        catch (IOException ex) {
            throw new CertificateException(ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)pemReader);
        }
    }

    public static X509Certificate parseDer(String base64DerEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(Base64.decodeBase64((String)base64DerEncodedCert));
    }

    public static X509Certificate parseDer(byte[] derEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(new ByteArrayInputStream(derEncodedCert));
    }

    public static X509Certificate parseDer(InputStream is) throws CertificateException {
        return (X509Certificate)CertificateFactory.getInstance("X.509", SecurityProviderUtility.getBCProvider()).generateCertificate(is);
    }
}

