/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.common;

import com.google.common.collect.Lists;
import io.jans.as.common.claims.Audience;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.common.AbstractAuthorizationGrant;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationCode;
import io.jans.as.server.model.common.AuthorizationGrantType;
import io.jans.as.server.model.common.CacheGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.IdToken;
import io.jans.as.server.model.common.LogoutStatusJwt;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.model.common.TxToken;
import io.jans.as.server.model.token.HandleTokenFactory;
import io.jans.as.server.model.token.IdTokenFactory;
import io.jans.as.server.model.token.JwtSigner;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.GrantService;
import io.jans.as.server.service.MetricService;
import io.jans.as.server.service.SectorIdentifierService;
import io.jans.as.server.service.external.ExternalIntrospectionService;
import io.jans.as.server.service.external.ExternalUpdateTokenService;
import io.jans.as.server.service.external.context.ExternalIntrospectionContext;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.as.server.service.logout.LogoutStatusJwtService;
import io.jans.as.server.service.stat.StatService;
import io.jans.as.server.service.token.StatusListIndexService;
import io.jans.as.server.service.token.StatusListService;
import io.jans.as.server.util.ServerUtil;
import io.jans.as.server.util.TokenHashUtil;
import io.jans.model.metric.MetricType;
import io.jans.model.token.TokenEntity;
import io.jans.model.token.TokenType;
import io.jans.service.CacheService;
import io.jans.util.security.StringEncrypter;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorizationGrant
extends AbstractAuthorizationGrant {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationGrant.class);
    @Inject
    private CacheService cacheService;
    @Inject
    private GrantService grantService;
    @Inject
    private IdTokenFactory idTokenFactory;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalIntrospectionService externalIntrospectionService;
    @Inject
    private ExternalUpdateTokenService externalUpdateTokenService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private SectorIdentifierService sectorIdentifierService;
    @Inject
    private MetricService metricService;
    @Inject
    private StatService statService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private StatusListService statusListService;
    @Inject
    private StatusListIndexService statusListIndexService;
    @Inject
    private LogoutStatusJwtService logoutStatusJwtService;
    private boolean isCachedWithNoPersistence = false;

    protected AuthorizationGrant() {
    }

    protected AuthorizationGrant(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        super(user, authorizationGrantType, client, authenticationTime);
    }

    @Override
    public void init(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        super.init(user, authorizationGrantType, client, authenticationTime);
    }

    private IdToken createIdTokenInternal(AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, ExecutionContext executionContext) throws Exception {
        executionContext.initFromGrantIfNeeded(this);
        Integer statusListIndex = null;
        if (this.errorResponseFactory.isFeatureFlagEnabled(FeatureFlagType.STATUS_LIST)) {
            statusListIndex = this.statusListIndexService.next();
            executionContext.setStatusListIndex(statusListIndex);
        }
        JsonWebResponse jwr = this.idTokenFactory.createJwr(this, authorizationCode, accessToken, refreshToken, executionContext);
        IdToken idToken = new IdToken(jwr.toString(), jwr.getClaims().getClaimAsDate("iat"), jwr.getClaims().getClaimAsDate("exp"));
        idToken.setReferenceId(executionContext.getTokenReferenceId());
        idToken.setStatusListIndex(statusListIndex);
        if (log.isTraceEnabled()) {
            log.trace("Created id_token: {}", (Object)idToken.getCode());
        }
        return idToken;
    }

    @Override
    public String checkScopesPolicy(String scope) {
        if (StringUtils.isBlank((CharSequence)scope)) {
            return scope;
        }
        String result = super.checkScopesPolicy(scope);
        this.save();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save() {
        if (this.isCachedWithNoPersistence) {
            if (this.getAuthorizationGrantType() == AuthorizationGrantType.AUTHORIZATION_CODE) {
                this.saveInCache();
                return;
            } else {
                if (this.getAuthorizationGrantType() != AuthorizationGrantType.CIBA) throw new UnsupportedOperationException("Grant caching is not supported for : " + this.getAuthorizationGrantType());
                this.saveInCache();
            }
            return;
        } else {
            this.saveImpl();
        }
    }

    private void saveInCache() {
        CacheGrant cachedGrant = new CacheGrant(this, this.appConfiguration);
        this.cacheService.put(cachedGrant.getExpiresIn(), cachedGrant.cacheKey(), (Object)cachedGrant);
    }

    public boolean isImplicitFlow() {
        return this.getAuthorizationGrantType() == null || this.getAuthorizationGrantType() == AuthorizationGrantType.IMPLICIT;
    }

    private void saveImpl() {
        List<TokenEntity> grants;
        String grantId = this.getGrantId();
        if (StringUtils.isNotBlank((CharSequence)grantId) && (grants = this.grantService.getGrantsByGrantId(grantId)) != null && !grants.isEmpty()) {
            for (TokenEntity t : grants) {
                this.initTokenFromGrant(t);
                log.debug("Saving grant: {}, code_challenge: {}", (Object)grantId, (Object)this.getCodeChallenge());
                this.grantService.mergeSilently(t);
            }
        }
    }

    private void initTokenFromGrant(TokenEntity token) {
        String nonce = this.getNonce();
        if (nonce != null) {
            token.setNonce(nonce);
        }
        token.getAttributes().setAuthorizationDetails(this.getAuthzDetailsAsString());
        token.getAttributes().setAuthorizationChallenge(this.isAuthorizationChallenge());
        token.setScope(this.getScopesAsString());
        token.setAuthMode(this.getAcrValues());
        token.setSessionDn(this.getSessionDn());
        token.setAuthenticationTime(this.getAuthenticationTime());
        token.setCodeChallenge(this.getCodeChallenge());
        token.setCodeChallengeMethod(this.getCodeChallengeMethod());
        token.setClaims(this.getClaims());
        JwtAuthorizationRequest jwtRequest = this.getJwtAuthorizationRequest();
        if (jwtRequest != null && StringUtils.isNotBlank((CharSequence)jwtRequest.getEncodedJwt())) {
            token.setJwtRequest(jwtRequest.getEncodedJwt());
        }
    }

    @Override
    public LogoutStatusJwt createLogoutStatusJwt(ExecutionContext context) {
        try {
            LogoutStatusJwt logoutStatusJwt = this.logoutStatusJwtService.createLogoutStatusJwt(context, this);
            if (logoutStatusJwt == null) {
                log.error("Failed to create Logout Status JWT.");
                return null;
            }
            TokenEntity tokenEntity = this.asToken(logoutStatusJwt);
            context.setLogoutStatusJwtEntity(tokenEntity);
            this.persist(tokenEntity);
            this.statService.reportLogoutStatusJwt(this.getGrantType());
            this.metricService.incCounter(MetricType.TOKEN_LOGOUT_STATUS_JWT_COUNT);
            log.debug("Logout Status JWT is successfully persisted, jti: {}", (Object)logoutStatusJwt.getJti());
            return logoutStatusJwt;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public AccessToken createAccessToken(ExecutionContext context) {
        try {
            boolean externalOk;
            context.initFromGrantIfNeeded(this);
            context.generateRandomTokenReferenceId();
            AccessToken accessToken = super.createAccessToken(context);
            Integer statusListIndex = null;
            if (this.errorResponseFactory.isFeatureFlagEnabled(FeatureFlagType.STATUS_LIST)) {
                statusListIndex = this.statusListIndexService.next();
                context.setStatusListIndex(statusListIndex);
                accessToken.setStatusListIndex(statusListIndex);
            }
            if (accessToken.getExpiresIn() < 0) {
                log.trace("Failed to create access token with negative expiration time");
                return null;
            }
            JwtSigner jwtSigner = null;
            if (this.getClient().isAccessTokenAsJwt()) {
                jwtSigner = this.createAccessTokenAsJwt(accessToken, context);
            }
            if (!(externalOk = this.externalUpdateTokenService.modifyAccessToken(accessToken, ExternalUpdateTokenContext.of(context, jwtSigner)))) {
                String reason = "External UpdateToken script forbids access token creation.";
                log.trace("External UpdateToken script forbids access token creation.");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(ServerUtil.cacheControl(true, false)).header("Pragma", (Object)"no-cache").entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)TokenErrorResponseType.ACCESS_DENIED, "External UpdateToken script forbids access token creation.")).build());
            }
            if (this.getClient().isAccessTokenAsJwt() && jwtSigner != null) {
                String accessTokenCode = jwtSigner.sign().toString();
                if (log.isTraceEnabled()) {
                    log.trace("Created access token JWT: {}", (Object)(accessTokenCode + ", claims: " + jwtSigner.getJwt().getClaims().toJsonString()));
                }
                accessToken.setCode(accessTokenCode);
            }
            TokenEntity tokenEntity = this.asToken(accessToken);
            context.setAccessTokenEntity(tokenEntity);
            this.persist(tokenEntity);
            this.statService.reportAccessToken(this.getGrantType());
            this.metricService.incCounter(MetricType.TOKEN_ACCESS_TOKEN_COUNT);
            if (log.isTraceEnabled()) {
                log.trace("Created plain access token: {}", (Object)accessToken.getCode());
            }
            return accessToken;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JwtSigner createAccessTokenAsJwt(AccessToken accessToken, ExecutionContext context) throws StringEncrypter.EncryptionException, CryptoProviderException {
        Client client = this.getClient();
        context.initFromGrantIfNeeded(this);
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getAccessTokenSigningAlg() != null && SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg()) != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg());
        }
        JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, (JSONWebKeySet)this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
        Jwt jwt = jwtSigner.newJwt();
        this.fillPayloadOfAccessTokenJwt(jwt.getClaims(), accessToken, context);
        Audience.setAudience((JwtClaims)jwt.getClaims(), (Client)this.getClient());
        this.statusListService.addStatusClaimWithIndex((JsonWebResponse)jwt, context);
        if (BooleanUtils.isTrue((Boolean)client.getAttributes().getRunIntrospectionScriptBeforeJwtCreation())) {
            this.runIntrospectionScriptAndInjectValuesIntoJwt(jwt, context);
        }
        return jwtSigner;
    }

    public void fillPayloadOfAccessTokenJwt(JwtClaims claims, AccessToken accessToken, ExecutionContext context) {
        String dpop;
        User user = this.getUser();
        claims.setClaim("scope", (List)Lists.newArrayList(this.getScopes()));
        claims.setClaim("client_id", this.getClientId());
        claims.setClaim("username", user != null ? user.getAttribute("displayName") : null);
        claims.setClaim("token_type", accessToken.getTokenType().getName());
        claims.setClaim("acr", this.getAcrValues());
        claims.setClaim("auth_time", ServerUtil.dateToSeconds(this.getAuthenticationTime()));
        claims.setExpirationTime(accessToken.getExpirationDate());
        claims.setIat(accessToken.getCreationDate());
        claims.setNbf(accessToken.getCreationDate());
        claims.setSubjectIdentifier(this.getSub());
        claims.setClaim("x5t#S256", accessToken.getX5ts256());
        claims.setClaim("jti", context.getTokenReferenceId());
        AuthzDetails authzDetails = this.getAuthzDetails();
        if (!AuthzDetails.isEmpty((AuthzDetails)authzDetails)) {
            claims.setClaim("authorization_details", authzDetails.asJsonArray());
        }
        if (StringUtils.isNotBlank((CharSequence)(dpop = context.getDpop()))) {
            claims.setNotBefore(accessToken.getCreationDate());
            JSONObject cnf = new JSONObject();
            cnf.put("jkt", (Object)dpop);
            claims.setClaim("cnf", cnf);
        }
    }

    private void runIntrospectionScriptAndInjectValuesIntoJwt(Jwt jwt, ExecutionContext executionContext) {
        executionContext.initFromGrantIfNeeded(this);
        JSONObject responseAsJsonObject = new JSONObject();
        ExternalIntrospectionContext context = new ExternalIntrospectionContext(this, executionContext.getHttpRequest(), executionContext.getHttpResponse(), this.appConfiguration, this.attributeService);
        context.setAccessTokenAsJwt(jwt);
        if (this.externalIntrospectionService.executeExternalModifyResponse(responseAsJsonObject, context)) {
            log.trace("Successfully run external introspection scripts.");
            if (context.isTranferIntrospectionPropertiesIntoJwtClaims()) {
                log.trace("Transfering claims into jwt ...");
                JwtUtil.transferIntoJwtClaims((JSONObject)responseAsJsonObject, (Jwt)jwt);
                log.trace("Transfered.");
            }
        }
    }

    private RefreshToken saveRefreshToken(RefreshToken refreshToken, ExecutionContext executionContext) {
        try {
            executionContext.initFromGrantIfNeeded(this);
            if (refreshToken.getExpiresIn() > 0) {
                TokenEntity entity = this.asToken(refreshToken);
                executionContext.setRefreshTokenEntity(entity);
                boolean externalOk = this.externalUpdateTokenService.modifyRefreshToken(refreshToken, ExternalUpdateTokenContext.of(executionContext));
                if (!externalOk) {
                    log.trace("External script forbids refresh token creation.");
                    return null;
                }
                if (executionContext.getScopes().contains("online_access")) {
                    entity.getAttributes().setOnlineAccess(true);
                }
                this.persist(entity);
                this.statService.reportRefreshToken(this.getGrantType());
                this.metricService.incCounter(MetricType.TOKEN_REFRESH_TOKEN_COUNT);
                if (log.isTraceEnabled()) {
                    log.trace("Created refresh token: {}", (Object)refreshToken.getCode());
                }
                return refreshToken;
            }
            log.debug("Token expiration date is in the past. Skip refresh_token creation.");
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private RefreshToken saveRefreshToken(Supplier<RefreshToken> supplier, ExecutionContext executionContext) {
        try {
            return this.saveRefreshToken(supplier.get(), executionContext);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public RefreshToken createRefreshToken(ExecutionContext context) {
        context.initFromGrantIfNeeded(this);
        return this.saveRefreshToken(() -> super.createRefreshToken(context), context);
    }

    @Override
    public RefreshToken createRefreshToken(ExecutionContext context, int lifetime) {
        context.initFromGrantIfNeeded(this);
        return this.saveRefreshToken(() -> super.createRefreshToken(context, lifetime), context);
    }

    public RefreshToken createRefreshToken(ExecutionContext context, Date expirationDate) {
        return this.saveRefreshToken(() -> {
            RefreshToken refreshToken = new RefreshToken(HandleTokenFactory.generateHandleToken(), new Date(), expirationDate);
            refreshToken.setSessionDn(this.getSessionDn());
            refreshToken.setDpop(context.getDpop());
            return refreshToken;
        }, context);
    }

    @Override
    public IdToken createIdToken(String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, String state, ExecutionContext executionContext) {
        try {
            executionContext.initFromGrantIfNeeded(this);
            executionContext.setScopes(this.getScopes());
            executionContext.setClaimsAsString(this.getClaims());
            executionContext.setNonce(nonce);
            executionContext.setState(state);
            executionContext.generateRandomTokenReferenceId();
            IdToken idToken = this.createIdTokenInternal(authorizationCode, accessToken, refreshToken, executionContext);
            AuthorizationGrant grant = executionContext.getGrant();
            String acrValues = grant.getAcrValues();
            String sessionDn = grant.getSessionDn();
            if (idToken.getExpiresIn() > 0) {
                TokenEntity tokenEntity = this.asToken(idToken);
                tokenEntity.setAuthMode(acrValues);
                tokenEntity.setSessionDn(sessionDn);
                this.persist(tokenEntity);
            }
            this.setAcrValues(acrValues);
            this.setSessionDn(sessionDn);
            this.statService.reportIdToken(this.getGrantType());
            this.metricService.incCounter(MetricType.TOKEN_ID_TOKEN_COUNT);
            return idToken;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void persist(TokenEntity token) {
        this.grantService.persist(token);
    }

    public void persist(AuthorizationCode code) {
        this.persist(this.asToken(code));
    }

    public TokenEntity asToken(IdToken token) {
        TokenEntity result = this.asTokenEntity(token);
        result.setTokenTypeEnum(TokenType.ID_TOKEN);
        return result;
    }

    public TokenEntity asToken(RefreshToken token) {
        TokenEntity result = this.asTokenEntity(token);
        result.setTokenTypeEnum(TokenType.REFRESH_TOKEN);
        return result;
    }

    public TokenEntity asToken(AuthorizationCode authorizationCode) {
        TokenEntity result = this.asTokenEntity(authorizationCode);
        result.setTokenTypeEnum(TokenType.AUTHORIZATION_CODE);
        return result;
    }

    public TokenEntity asToken(AccessToken accessToken) {
        TokenEntity result = this.asTokenEntity(accessToken);
        result.setTokenTypeEnum(TokenType.ACCESS_TOKEN);
        return result;
    }

    public TokenEntity asToken(LogoutStatusJwt logoutStatusJwt) {
        TokenEntity result = this.asTokenEntity(logoutStatusJwt);
        result.setTokenTypeEnum(TokenType.LOGOUT_STATUS_JWT);
        return result;
    }

    public TokenEntity asToken(TxToken txToken) {
        TokenEntity result = this.asTokenEntity(txToken);
        result.setTokenTypeEnum(TokenType.TX_TOKEN);
        return result;
    }

    public String getScopesAsString() {
        StringBuilder scopes = new StringBuilder();
        for (String s : this.getScopes()) {
            scopes.append(s).append(" ");
        }
        return scopes.toString().trim();
    }

    public TokenEntity asTokenEntity(AbstractToken token) {
        AuthorizationCode authorizationCode;
        TokenEntity result = new TokenEntity();
        String hashedCode = TokenHashUtil.hash(token.getCode());
        result.setDn(this.grantService.buildDn(hashedCode));
        result.setGrantId(this.getGrantId());
        result.setCreationDate(token.getCreationDate());
        result.setExpirationDate(token.getExpirationDate());
        result.setTtl(Integer.valueOf(token.getTtl()));
        result.setTokenCode(hashedCode);
        result.setUserId(this.getUserId());
        result.setUserDn(this.getUserDn());
        result.setClientId(this.getClientId());
        result.setReferenceId(token.getReferenceId());
        result.setJti(token.getJti());
        result.getAttributes().setStatusListIndex(token.getStatusListIndex());
        result.getAttributes().setX5cs256(token.getX5ts256());
        result.getAttributes().setDpopJkt(this.getDpopJkt());
        result.setDpop(token.getDpop());
        AuthorizationGrantType grantType = this.getAuthorizationGrantType();
        if (grantType != null) {
            result.setGrantType(grantType.getParamName());
        }
        if ((authorizationCode = this.getAuthorizationCode()) != null) {
            result.setAuthorizationCode(TokenHashUtil.hash(authorizationCode.getCode()));
        }
        this.initTokenFromGrant(result);
        return result;
    }

    @Override
    public void revokeAllTokens() {
        TokenEntity tokenEntity = this.getTokenEntity();
        if (tokenEntity != null && StringUtils.isNotBlank((CharSequence)tokenEntity.getGrantId())) {
            this.grantService.removeAllByGrantId(tokenEntity.getGrantId());
        }
    }

    @Override
    public void checkExpiredTokens() {
    }

    @Override
    public String getSub() {
        String sub = this.sectorIdentifierService.getSub(this);
        if (StringUtils.isBlank((CharSequence)sub)) {
            String clientId = this.getClientId();
            return StringUtils.isNotBlank((CharSequence)clientId) ? clientId : "";
        }
        return sub;
    }

    public boolean isCachedWithNoPersistence() {
        return this.isCachedWithNoPersistence;
    }

    public void setIsCachedWithNoPersistence(boolean isCachedWithNoPersistence) {
        this.isCachedWithNoPersistence = isCachedWithNoPersistence;
    }
}

