/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.common;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.common.UserService;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.util.Util;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.common.AbstractAuthorizationGrant;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationCode;
import io.jans.as.server.model.common.AuthorizationCodeGrant;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantType;
import io.jans.as.server.model.common.CIBAGrant;
import io.jans.as.server.model.common.CacheGrant;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.as.server.model.common.ClientCredentialsGrant;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.as.server.model.common.DeviceCodeGrant;
import io.jans.as.server.model.common.IAuthorizationGrantList;
import io.jans.as.server.model.common.IdToken;
import io.jans.as.server.model.common.ImplicitGrant;
import io.jans.as.server.model.common.JwtBearerGrant;
import io.jans.as.server.model.common.LogoutStatusJwt;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.model.common.ResourceOwnerPasswordCredentialsGrant;
import io.jans.as.server.model.common.SimpleAuthorizationGrant;
import io.jans.as.server.model.common.TokenExchangeGrant;
import io.jans.as.server.model.common.TxToken;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.GrantService;
import io.jans.as.server.service.MetricService;
import io.jans.as.server.util.TokenHashUtil;
import io.jans.model.metric.MetricType;
import io.jans.model.token.TokenEntity;
import io.jans.model.token.TokenType;
import io.jans.service.CacheService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Dependent
public class AuthorizationGrantList
implements IAuthorizationGrantList {
    @Inject
    private Logger log;
    @Inject
    private Instance<AbstractAuthorizationGrant> grantInstance;
    @Inject
    private GrantService grantService;
    @Inject
    private UserService userService;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CacheService cacheService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private MetricService metricService;

    @Override
    public void removeAuthorizationGrants(List<AuthorizationGrant> authorizationGrants) {
        if (authorizationGrants != null && !authorizationGrants.isEmpty()) {
            for (AuthorizationGrant r : authorizationGrants) {
                this.grantService.remove(r);
            }
        }
    }

    @Override
    public AuthorizationGrant createAuthorizationGrant(User user, Client client, Date authenticationTime) {
        AuthorizationGrant grant = (AuthorizationGrant)this.grantInstance.select(SimpleAuthorizationGrant.class, new Annotation[0]).get();
        grant.init(user, null, client, authenticationTime);
        return grant;
    }

    @Override
    public AuthorizationCodeGrant createAuthorizationCodeGrant(User user, Client client, Date authenticationTime) {
        AuthorizationCodeGrant grant = (AuthorizationCodeGrant)this.grantInstance.select(AuthorizationCodeGrant.class, new Annotation[0]).get();
        grant.init(user, client, authenticationTime);
        CacheGrant memcachedGrant = new CacheGrant(grant, this.appConfiguration);
        this.cacheService.put(grant.getAuthorizationCode().getExpiresIn(), memcachedGrant.cacheKey(), (Object)memcachedGrant);
        String escapedCode = Util.escapeLog((Object)grant.getAuthorizationCode().getCode());
        String escapedClientId = Util.escapeLog((Object)grant.getClientId());
        this.log.trace("Put authorization grant in cache, code: {}, clientId: {}", (Object)escapedCode, (Object)escapedClientId);
        this.metricService.incCounter(MetricType.TOKEN_AUTHORIZATION_CODE_COUNT);
        return grant;
    }

    @Override
    public ImplicitGrant createImplicitGrant(User user, Client client, Date authenticationTime) {
        ImplicitGrant grant = (ImplicitGrant)this.grantInstance.select(ImplicitGrant.class, new Annotation[0]).get();
        grant.init(user, client, authenticationTime);
        return grant;
    }

    @Override
    public ClientCredentialsGrant createClientCredentialsGrant(User user, Client client) {
        ClientCredentialsGrant grant = (ClientCredentialsGrant)this.grantInstance.select(ClientCredentialsGrant.class, new Annotation[0]).get();
        grant.init(user, client);
        return grant;
    }

    @Override
    public ResourceOwnerPasswordCredentialsGrant createResourceOwnerPasswordCredentialsGrant(User user, Client client) {
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)this.grantInstance.select(ResourceOwnerPasswordCredentialsGrant.class, new Annotation[0]).get();
        grant.init(user, client);
        return grant;
    }

    @Override
    public TokenExchangeGrant createTokenExchangeGrant(User user, Client client) {
        TokenExchangeGrant grant = (TokenExchangeGrant)this.grantInstance.select(TokenExchangeGrant.class, new Annotation[0]).get();
        grant.init(user, client);
        return grant;
    }

    @Override
    public JwtBearerGrant createJwtBearerGrant(User user, Client client) {
        JwtBearerGrant grant = (JwtBearerGrant)this.grantInstance.select(JwtBearerGrant.class, new Annotation[0]).get();
        grant.init(user, client);
        return grant;
    }

    @Override
    public CIBAGrant createCIBAGrant(CibaRequestCacheControl request) {
        CIBAGrant grant = (CIBAGrant)this.grantInstance.select(CIBAGrant.class, new Annotation[0]).get();
        grant.init(request);
        CacheGrant memcachedGrant = new CacheGrant(grant, this.appConfiguration);
        this.cacheService.put(request.getExpiresIn(), memcachedGrant.getAuthReqId(), (Object)memcachedGrant);
        String escapedAuthReqId = Util.escapeLog((Object)grant.getAuthReqId());
        String escapedGrantId = Util.escapeLog((Object)grant.getGrantId());
        this.log.trace("Ciba grant saved in cache, authReqId: {}, grantId: {}", (Object)escapedAuthReqId, (Object)escapedGrantId);
        return grant;
    }

    @Override
    public CIBAGrant getCIBAGrant(String authReqId) {
        Object cachedGrant = this.cacheService.get(authReqId);
        if (cachedGrant == null) {
            cachedGrant = this.cacheService.get(authReqId);
            String escapedAuthReqId = Util.escapeLog((Object)authReqId);
            this.log.trace("Failed to fetch CIBA grant from cache, authReqId: {}", (Object)escapedAuthReqId);
        }
        return cachedGrant instanceof CacheGrant ? ((CacheGrant)cachedGrant).asCibaGrant(this.grantInstance) : null;
    }

    @Override
    public DeviceCodeGrant createDeviceGrant(DeviceAuthorizationCacheControl data, User user) {
        DeviceCodeGrant grant = (DeviceCodeGrant)this.grantInstance.select(DeviceCodeGrant.class, new Annotation[0]).get();
        grant.init(data, user);
        CacheGrant memcachedGrant = new CacheGrant(grant, this.appConfiguration);
        this.cacheService.put(data.getExpiresIn(), memcachedGrant.getDeviceCode(), (Object)memcachedGrant);
        String escapedDeviceCode = Util.escapeLog((Object)grant.getDeviceCode());
        String escapedGrantId = Util.escapeLog((Object)grant.getGrantId());
        this.log.trace("Device code grant saved in cache, deviceCode: {}, grantId: {}", (Object)escapedDeviceCode, (Object)escapedGrantId);
        return grant;
    }

    @Override
    public DeviceCodeGrant getDeviceCodeGrant(String deviceCode) {
        Object cachedGrant = this.cacheService.get(deviceCode);
        if (cachedGrant == null) {
            cachedGrant = this.cacheService.get(deviceCode);
            String escapedDeviceCode = Util.escapeLog((Object)deviceCode);
            this.log.trace("Failed to fetch Device code grant from cache, deviceCode: {}", (Object)escapedDeviceCode);
        }
        return cachedGrant instanceof CacheGrant ? ((CacheGrant)cachedGrant).asDeviceCodeGrant(this.grantInstance) : null;
    }

    @Override
    public AuthorizationCodeGrant getAuthorizationCodeGrant(String authorizationCode) {
        Object cachedGrant = this.cacheService.get(CacheGrant.cacheKey(authorizationCode, null));
        if (cachedGrant == null) {
            cachedGrant = this.cacheService.get(CacheGrant.cacheKey(authorizationCode, null));
            String escapedAuthorizationCode = Util.escapeLog((Object)authorizationCode);
            this.log.trace("Failed to fetch authorization grant from cache, code: {}", (Object)escapedAuthorizationCode);
        }
        return cachedGrant instanceof CacheGrant ? ((CacheGrant)cachedGrant).asCodeGrant(this.grantInstance) : null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByRefreshToken(String clientId, String refreshTokenCode) {
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getPersistRefreshToken())) {
            return this.assertTokenType((TokenEntity)this.cacheService.get(TokenHashUtil.hash(refreshTokenCode)), TokenType.REFRESH_TOKEN, clientId);
        }
        return this.assertTokenType(this.grantService.getGrantByCode(refreshTokenCode), TokenType.REFRESH_TOKEN, clientId);
    }

    public AuthorizationGrant assertTokenType(TokenEntity tokenEntity, TokenType tokenType, String clientId) {
        if (tokenEntity == null || tokenEntity.getTokenTypeEnum() != tokenType) {
            return null;
        }
        AuthorizationGrant grant = this.asGrant(tokenEntity);
        if (grant == null || !grant.getClientId().equals(clientId)) {
            return null;
        }
        return grant;
    }

    @Override
    public List<AuthorizationGrant> getAuthorizationGrant(String clientId) {
        ArrayList<AuthorizationGrant> result = new ArrayList<AuthorizationGrant>();
        try {
            ArrayList<TokenEntity> entries = new ArrayList<TokenEntity>(this.grantService.getGrantsOfClient(clientId));
            for (TokenEntity t : entries) {
                AuthorizationGrant grant = this.asGrant(t);
                if (grant == null) continue;
                result.add(grant);
            }
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByAccessToken(String accessToken) {
        TokenEntity tokenEntity = this.grantService.getGrantByCode(accessToken);
        if (tokenEntity != null && (tokenEntity.getTokenTypeEnum() == TokenType.ACCESS_TOKEN || tokenEntity.getTokenTypeEnum() == TokenType.LONG_LIVED_ACCESS_TOKEN || tokenEntity.getTokenTypeEnum() == TokenType.TX_TOKEN)) {
            return this.asGrant(tokenEntity);
        }
        return null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByJti(String jti) {
        TokenEntity tokenEntity = this.grantService.getGrantsByJti(jti);
        if (tokenEntity != null) {
            return this.asGrant(tokenEntity);
        }
        return null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByIdToken(String idToken) {
        if (StringUtils.isBlank((CharSequence)idToken)) {
            return null;
        }
        TokenEntity tokenEntity = this.grantService.getGrantByCode(idToken);
        if (tokenEntity != null && tokenEntity.getTokenTypeEnum() == TokenType.ID_TOKEN) {
            return this.asGrant(tokenEntity);
        }
        return null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByReferenceId(String referenceId) {
        if (StringUtils.isBlank((CharSequence)referenceId)) {
            return null;
        }
        TokenEntity tokenEntity = this.grantService.getGrantByReferenceId(referenceId);
        if (tokenEntity != null) {
            return this.asGrant(tokenEntity);
        }
        return null;
    }

    public AuthorizationGrant asGrant(TokenEntity tokenEntity) {
        AuthorizationGrantType grantType;
        if (tokenEntity != null && (grantType = AuthorizationGrantType.fromString(tokenEntity.getGrantType())) != null) {
            AuthorizationGrant result;
            String userId = tokenEntity.getUserId();
            User user = null;
            if (StringHelper.isNotEmpty((String)userId)) {
                user = this.userService.getUser(userId, new String[0]);
            }
            Client client = this.clientService.getClient(tokenEntity.getClientId());
            Date authenticationTime = tokenEntity.getAuthenticationTime();
            String nonce = tokenEntity.getNonce();
            switch (grantType) {
                case AUTHORIZATION_CODE: {
                    AuthorizationCodeGrant authorizationCodeGrant = (AuthorizationCodeGrant)this.grantInstance.select(AuthorizationCodeGrant.class, new Annotation[0]).get();
                    authorizationCodeGrant.init(user, client, authenticationTime);
                    result = authorizationCodeGrant;
                    break;
                }
                case CLIENT_CREDENTIALS: {
                    ClientCredentialsGrant clientCredentialsGrant = (ClientCredentialsGrant)this.grantInstance.select(ClientCredentialsGrant.class, new Annotation[0]).get();
                    clientCredentialsGrant.init(user, client);
                    result = clientCredentialsGrant;
                    break;
                }
                case IMPLICIT: {
                    ImplicitGrant implicitGrant = (ImplicitGrant)this.grantInstance.select(ImplicitGrant.class, new Annotation[0]).get();
                    implicitGrant.init(user, client, authenticationTime);
                    result = implicitGrant;
                    break;
                }
                case RESOURCE_OWNER_PASSWORD_CREDENTIALS: {
                    ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = (ResourceOwnerPasswordCredentialsGrant)this.grantInstance.select(ResourceOwnerPasswordCredentialsGrant.class, new Annotation[0]).get();
                    resourceOwnerPasswordCredentialsGrant.init(user, client);
                    result = resourceOwnerPasswordCredentialsGrant;
                    break;
                }
                case CIBA: {
                    CIBAGrant cibaGrant = (CIBAGrant)this.grantInstance.select(CIBAGrant.class, new Annotation[0]).get();
                    cibaGrant.init(user, AuthorizationGrantType.CIBA, client, tokenEntity.getCreationDate());
                    result = cibaGrant;
                    break;
                }
                case DEVICE_CODE: {
                    DeviceCodeGrant deviceCodeGrant = (DeviceCodeGrant)this.grantInstance.select(DeviceCodeGrant.class, new Annotation[0]).get();
                    deviceCodeGrant.init(user, AuthorizationGrantType.DEVICE_CODE, client, tokenEntity.getCreationDate());
                    result = deviceCodeGrant;
                    break;
                }
                case TX_TOKEN: 
                case TOKEN_EXCHANGE: {
                    TokenExchangeGrant tokenExchangeGrant = (TokenExchangeGrant)this.grantInstance.select(TokenExchangeGrant.class, new Annotation[0]).get();
                    tokenExchangeGrant.init(user, AuthorizationGrantType.TOKEN_EXCHANGE, client, tokenEntity.getCreationDate());
                    result = tokenExchangeGrant;
                    break;
                }
                case JWT_BEARER: {
                    JwtBearerGrant jwtBearerGrant = (JwtBearerGrant)this.grantInstance.select(JwtBearerGrant.class, new Annotation[0]).get();
                    jwtBearerGrant.init(user, AuthorizationGrantType.JWT_BEARER, client, tokenEntity.getCreationDate());
                    result = jwtBearerGrant;
                    break;
                }
                default: {
                    return null;
                }
            }
            String grantId = tokenEntity.getGrantId();
            String jwtRequest = tokenEntity.getJwtRequest();
            String authMode = tokenEntity.getAuthMode();
            String sessionDn = tokenEntity.getSessionDn();
            String claims = tokenEntity.getClaims();
            result.setTokenBindingHash(tokenEntity.getTokenBindingHash());
            result.setNonce(nonce);
            result.setX5ts256(tokenEntity.getAttributes().getX5cs256());
            result.setDpopJkt(tokenEntity.getAttributes().getDpopJkt());
            result.setTokenEntity(tokenEntity);
            result.setReferenceId(tokenEntity.getReferenceId());
            result.setStatusListIndex(tokenEntity.getAttributes().getStatusListIndex());
            result.setAuthorizationChallenge(tokenEntity.getAttributes().isAuthorizationChallenge());
            if (StringUtils.isNotBlank((CharSequence)grantId)) {
                result.setGrantId(grantId);
            }
            result.setScopes(Util.splittedStringAsList((String)tokenEntity.getScope(), (String)" "));
            result.setAuthzDetails(AuthzDetails.ofSilently((String)tokenEntity.getAttributes().getAuthorizationDetails()));
            result.setCodeChallenge(tokenEntity.getCodeChallenge());
            result.setCodeChallengeMethod(tokenEntity.getCodeChallengeMethod());
            if (StringUtils.isNotBlank((CharSequence)jwtRequest)) {
                try {
                    result.setJwtAuthorizationRequest(new JwtAuthorizationRequest(this.appConfiguration, this.cryptoProvider, jwtRequest, client));
                }
                catch (Exception e) {
                    this.log.trace(e.getMessage(), (Throwable)e);
                }
            }
            result.setAcrValues(authMode);
            result.setSessionDn(sessionDn);
            result.setClaims(claims);
            if (tokenEntity.getTokenTypeEnum() != null) {
                switch (tokenEntity.getTokenTypeEnum()) {
                    case AUTHORIZATION_CODE: {
                        if (!(result instanceof AuthorizationCodeGrant)) break;
                        AuthorizationCode code = new AuthorizationCode(tokenEntity.getTokenCode(), tokenEntity.getCreationDate(), tokenEntity.getExpirationDate());
                        AuthorizationCodeGrant g = (AuthorizationCodeGrant)result;
                        code.setX5ts256(g.getX5ts256());
                        code.setReferenceId(tokenEntity.getReferenceId());
                        code.setStatusListIndex(tokenEntity.getAttributes().getStatusListIndex());
                        code.setJti(tokenEntity.getJti());
                        g.setAuthorizationCode(code);
                        break;
                    }
                    case REFRESH_TOKEN: {
                        RefreshToken refreshToken = new RefreshToken(tokenEntity.getTokenCode(), tokenEntity.getCreationDate(), tokenEntity.getExpirationDate());
                        refreshToken.setX5ts256(result.getX5ts256());
                        refreshToken.setReferenceId(tokenEntity.getReferenceId());
                        refreshToken.setStatusListIndex(tokenEntity.getAttributes().getStatusListIndex());
                        refreshToken.setJti(tokenEntity.getJti());
                        result.setRefreshTokens(Collections.singletonList(refreshToken));
                        break;
                    }
                    case ACCESS_TOKEN: {
                        AccessToken accessToken = new AccessToken(tokenEntity.getTokenCode(), tokenEntity.getCreationDate(), tokenEntity.getExpirationDate());
                        accessToken.setDpop(tokenEntity.getDpop());
                        accessToken.setX5ts256(result.getX5ts256());
                        accessToken.setReferenceId(tokenEntity.getReferenceId());
                        accessToken.setStatusListIndex(tokenEntity.getAttributes().getStatusListIndex());
                        accessToken.setJti(tokenEntity.getJti());
                        result.setAccessTokens(Collections.singletonList(accessToken));
                        break;
                    }
                    case TX_TOKEN: {
                        TxToken txToken = new TxToken(tokenEntity.getTokenCode(), tokenEntity.getCreationDate(), tokenEntity.getExpirationDate());
                        txToken.setDpop(tokenEntity.getDpop());
                        txToken.setX5ts256(result.getX5ts256());
                        txToken.setReferenceId(tokenEntity.getReferenceId());
                        txToken.setStatusListIndex(tokenEntity.getAttributes().getStatusListIndex());
                        txToken.setJti(tokenEntity.getJti());
                        result.setTxTokens(Collections.singletonList(txToken));
                        break;
                    }
                    case ID_TOKEN: {
                        IdToken idToken = new IdToken(tokenEntity.getTokenCode(), tokenEntity.getCreationDate(), tokenEntity.getExpirationDate());
                        idToken.setX5ts256(result.getX5ts256());
                        idToken.setReferenceId(tokenEntity.getReferenceId());
                        idToken.setStatusListIndex(tokenEntity.getAttributes().getStatusListIndex());
                        idToken.setJti(tokenEntity.getJti());
                        result.setIdToken(idToken);
                        break;
                    }
                    case LONG_LIVED_ACCESS_TOKEN: {
                        AccessToken longLivedAccessToken = new AccessToken(tokenEntity.getTokenCode(), tokenEntity.getCreationDate(), tokenEntity.getExpirationDate());
                        longLivedAccessToken.setX5ts256(result.getX5ts256());
                        longLivedAccessToken.setReferenceId(tokenEntity.getReferenceId());
                        longLivedAccessToken.setStatusListIndex(tokenEntity.getAttributes().getStatusListIndex());
                        longLivedAccessToken.setJti(tokenEntity.getJti());
                        result.setLongLivedAccessToken(longLivedAccessToken);
                        break;
                    }
                    case LOGOUT_STATUS_JWT: {
                        LogoutStatusJwt logoutStatusJwt = new LogoutStatusJwt(tokenEntity.getTokenCode(), tokenEntity.getCreationDate(), tokenEntity.getExpirationDate());
                        logoutStatusJwt.setDpop(tokenEntity.getDpop());
                        logoutStatusJwt.setX5ts256(result.getX5ts256());
                        logoutStatusJwt.setReferenceId(tokenEntity.getReferenceId());
                        logoutStatusJwt.setStatusListIndex(tokenEntity.getAttributes().getStatusListIndex());
                        logoutStatusJwt.setJti(tokenEntity.getJti());
                        result.setLogoutStatusJwts(Collections.singletonList(logoutStatusJwt));
                    }
                }
            }
            return result;
        }
        return null;
    }
}

