/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.common;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.model.common.AbstractAuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationCode;
import io.jans.as.server.model.common.AuthorizationCodeGrant;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantType;
import io.jans.as.server.model.common.CIBAGrant;
import io.jans.as.server.model.common.DeviceCodeGrant;
import jakarta.enterprise.inject.Instance;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CacheGrant
implements Serializable {
    private String authorizationCodeString;
    private Date authorizationCodeCreationDate;
    private Date authorizationCodeExpirationDate;
    private User user;
    private Client client;
    private Date authenticationTime;
    private Set<String> scopes;
    private String authzDetails;
    private String grantId;
    private String tokenBindingHash;
    private String nonce;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String claims;
    private String deviceCode;
    private String acrValues;
    private String sessionDn;
    private int expiresIn = 1;
    private boolean isAuthorizationChallenge;
    private String authReqId;
    private boolean tokensDelivered;

    public CacheGrant() {
    }

    public CacheGrant(AuthorizationGrant grant, AppConfiguration appConfiguration) {
        if (grant.getAuthorizationCode() != null) {
            this.authorizationCodeString = grant.getAuthorizationCode().getCode();
            this.authorizationCodeCreationDate = grant.getAuthorizationCode().getCreationDate();
            this.authorizationCodeExpirationDate = grant.getAuthorizationCode().getExpirationDate();
        }
        this.initExpiresIn(grant, appConfiguration);
        this.user = grant.getUser();
        this.client = grant.getClient();
        this.authenticationTime = grant.getAuthenticationTime();
        this.scopes = grant.getScopes();
        this.authzDetails = grant.getAuthzDetailsAsString();
        this.tokenBindingHash = grant.getTokenBindingHash();
        this.grantId = grant.getGrantId();
        this.nonce = grant.getNonce();
        this.acrValues = grant.getAcrValues();
        this.codeChallenge = grant.getCodeChallenge();
        this.codeChallengeMethod = grant.getCodeChallengeMethod();
        this.claims = grant.getClaims();
        this.sessionDn = grant.getSessionDn();
        this.isAuthorizationChallenge = grant.isAuthorizationChallenge();
    }

    public CacheGrant(CIBAGrant grant, AppConfiguration appConfiguration) {
        if (grant.getAuthorizationCode() != null) {
            this.authorizationCodeString = grant.getAuthorizationCode().getCode();
            this.authorizationCodeCreationDate = grant.getAuthorizationCode().getCreationDate();
            this.authorizationCodeExpirationDate = grant.getAuthorizationCode().getExpirationDate();
        }
        this.initExpiresIn(grant, appConfiguration);
        this.user = grant.getUser();
        this.client = grant.getClient();
        this.authenticationTime = grant.getAuthenticationTime();
        this.scopes = grant.getScopes();
        this.authzDetails = grant.getAuthzDetailsAsString();
        this.tokenBindingHash = grant.getTokenBindingHash();
        this.grantId = grant.getGrantId();
        this.nonce = grant.getNonce();
        this.acrValues = grant.getAcrValues();
        this.codeChallenge = grant.getCodeChallenge();
        this.codeChallengeMethod = grant.getCodeChallengeMethod();
        this.claims = grant.getClaims();
        this.sessionDn = grant.getSessionDn();
        this.authReqId = grant.getAuthReqId();
        this.tokensDelivered = grant.isTokensDelivered();
    }

    public CacheGrant(DeviceCodeGrant grant, AppConfiguration appConfiguration) {
        if (grant.getAuthorizationCode() != null) {
            this.authorizationCodeString = grant.getAuthorizationCode().getCode();
            this.authorizationCodeCreationDate = grant.getAuthorizationCode().getCreationDate();
            this.authorizationCodeExpirationDate = grant.getAuthorizationCode().getExpirationDate();
        }
        this.initExpiresIn(grant, appConfiguration);
        this.user = grant.getUser();
        this.client = grant.getClient();
        this.authenticationTime = grant.getAuthenticationTime();
        this.scopes = grant.getScopes();
        this.authzDetails = grant.getAuthzDetailsAsString();
        this.tokenBindingHash = grant.getTokenBindingHash();
        this.grantId = grant.getGrantId();
        this.nonce = grant.getNonce();
        this.acrValues = grant.getAcrValues();
        this.codeChallenge = grant.getCodeChallenge();
        this.codeChallengeMethod = grant.getCodeChallengeMethod();
        this.claims = grant.getClaims();
        this.sessionDn = grant.getSessionDn();
        this.deviceCode = grant.getDeviceCode();
    }

    private void initExpiresIn(AuthorizationGrant grant, AppConfiguration appConfiguration) {
        if (grant.getAuthorizationCode() != null) {
            this.expiresIn = grant.getAuthorizationCode().getExpiresIn();
        } else {
            this.expiresIn = appConfiguration.getAccessTokenLifetime();
            if (this.client != null && this.client.getAccessTokenLifetime() != null && this.client.getAccessTokenLifetime() > 0) {
                this.expiresIn = this.client.getAccessTokenLifetime();
            }
        }
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public Date getAuthorizationCodeCreationDate() {
        return this.authorizationCodeCreationDate;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getAuthzDetails() {
        return this.authzDetails;
    }

    public void setAuthzDetails(String authzDetails) {
        this.authzDetails = authzDetails;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String getGrantId() {
        return this.grantId;
    }

    public void setGrantId(String grantId) {
        this.grantId = grantId;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public String getAuthorizationCodeString() {
        return this.authorizationCodeString;
    }

    public void setAuthorizationCodeString(String authorizationCodeString) {
        this.authorizationCodeString = authorizationCodeString;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getSessionDn() {
        return this.sessionDn;
    }

    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    public AuthorizationCodeGrant asCodeGrant(Instance<AbstractAuthorizationGrant> grantInstance) {
        AuthorizationCodeGrant grant = (AuthorizationCodeGrant)grantInstance.select(AuthorizationCodeGrant.class, new Annotation[0]).get();
        grant.init(this.user, this.client, this.authenticationTime);
        grant.setAuthorizationCode(new AuthorizationCode(this.authorizationCodeString, this.authorizationCodeCreationDate, this.authorizationCodeExpirationDate));
        grant.setScopes(this.scopes);
        grant.setAuthzDetails(AuthzDetails.ofSilently((String)this.authzDetails));
        grant.setGrantId(this.grantId);
        grant.setSessionDn(this.sessionDn);
        grant.setCodeChallenge(this.codeChallenge);
        grant.setCodeChallengeMethod(this.codeChallengeMethod);
        grant.setAcrValues(this.acrValues);
        grant.setNonce(this.nonce);
        grant.setClaims(this.claims);
        grant.setAuthorizationChallenge(this.isAuthorizationChallenge);
        return grant;
    }

    public CIBAGrant asCibaGrant(Instance<AbstractAuthorizationGrant> grantInstance) {
        CIBAGrant grant = (CIBAGrant)grantInstance.select(CIBAGrant.class, new Annotation[0]).get();
        grant.init(this.user, AuthorizationGrantType.CIBA, this.client, this.authenticationTime);
        grant.setScopes(this.scopes);
        grant.setAuthzDetails(AuthzDetails.ofSilently((String)this.authzDetails));
        grant.setGrantId(this.grantId);
        grant.setSessionDn(this.sessionDn);
        grant.setCodeChallenge(this.codeChallenge);
        grant.setCodeChallengeMethod(this.codeChallengeMethod);
        grant.setAcrValues(this.acrValues);
        grant.setNonce(this.nonce);
        grant.setClaims(this.claims);
        grant.setAuthReqId(this.authReqId);
        grant.setTokensDelivered(this.tokensDelivered);
        return grant;
    }

    public DeviceCodeGrant asDeviceCodeGrant(Instance<AbstractAuthorizationGrant> grantInstance) {
        DeviceCodeGrant grant = (DeviceCodeGrant)grantInstance.select(DeviceCodeGrant.class, new Annotation[0]).get();
        grant.init(this.user, AuthorizationGrantType.DEVICE_CODE, this.client, this.authenticationTime);
        grant.setScopes(this.scopes);
        grant.setAuthzDetails(AuthzDetails.ofSilently((String)this.getAuthzDetails()));
        grant.setGrantId(this.grantId);
        grant.setSessionDn(this.sessionDn);
        grant.setCodeChallenge(this.codeChallenge);
        grant.setCodeChallengeMethod(this.codeChallengeMethod);
        grant.setAcrValues(this.acrValues);
        grant.setNonce(this.nonce);
        grant.setClaims(this.claims);
        grant.setDeviceCode(this.deviceCode);
        return grant;
    }

    public String cacheKey() {
        return CacheGrant.cacheKey(this.authorizationCodeString, this.grantId);
    }

    public static String cacheKey(String code, String grantId) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return grantId;
        }
        return code;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public boolean isTokensDelivered() {
        return this.tokensDelivered;
    }

    public void setTokensDelivered(boolean tokensDelivered) {
        this.tokensDelivered = tokensDelivered;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String toString() {
        return "CacheGrant{authorizationCode=" + this.authorizationCodeString + ", user=" + this.user + ", client=" + this.client + ", authenticationTime=" + this.authenticationTime + ", isAuthorizationChallenge=" + this.isAuthorizationChallenge + "}";
    }
}

